/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.FieldMapping;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.javascript.editor.EditorUtils;
import org.eclipse.stardust.modeling.javascript.editor.JavaScriptValidator;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.IProblem;

public class MessageTransformationApplicationValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        MessageTransformationController controller;
        VariableContext context;
        ModelType model;
        ArrayList<Issue> issues;
        block6: {
            issues = new ArrayList<Issue>();
            model = ModelUtils.findContainingModel((EObject)element);
            context = VariableContextHelper.getInstance().getContext(model);
            controller = new MessageTransformationController();
            try {
                controller.intializeModel(model, element);
            }
            catch (RuntimeException ex) {
                if (ex.getMessage().indexOf("external reference") <= 0) break block6;
                issues.add(Issue.warning((EObject)element, (String)Modeling_Messages.MSG_MTA_INVALID_REFERENCES));
                return issues.toArray(new Issue[issues.size()]);
            }
        }
        controller.initializeMappings(element);
        IProject project = WorkspaceUtils.getProjectFromEObject((EObject)element);
        IJavaScriptProject javaProject = JavaScriptCore.create((IProject)project);
        try {
            EditorUtils.addJSSupport((IProject)project, (ModelType)model);
        }
        catch (CoreException coreException) {}
        String toCheck = controller.getJScriptProlog();
        Map<String, FieldMapping> fieldMappings = controller.getFieldMappings();
        List<AccessPointType> aps = controller.getExternalClassTypes();
        for (AccessPointType apt : aps) {
            if (apt.getElementOid() != -99L) continue;
            issues.add(Issue.warning((EObject)element, (String)Modeling_Messages.MSG_MTA_REFERRED_CLASS_MISSING));
        }
        Iterator<Object> i = fieldMappings.keySet().iterator();
        while (i.hasNext()) {
            String path = i.next().toString();
            FieldMapping fm = fieldMappings.get(path);
            if (fm == null) continue;
            JavaScriptValidator javaScriptValidator = new JavaScriptValidator(javaProject);
            String mappingExpression = fm.getMappingExpression();
            mappingExpression = context.replaceAllVariablesByDefaultValue(mappingExpression);
            IProblem[] test = javaScriptValidator.validate(String.valueOf(toCheck) + "\n" + mappingExpression);
            if (test == null || test.length <= 0) continue;
            issues.add(Issue.warning((EObject)element, (String)Modeling_Messages.MSG_MTA_INVALID_JAVASCRIPT));
            return issues.toArray(new Issue[issues.size()]);
        }
        return issues.toArray(new Issue[issues.size()]);
    }
}

