/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.util.Collections;
import java.util.List;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.validation.Issue;

public class IssueDelta {
    public static final IssueDelta[] ISSUE_DELTA_ARRAY = new IssueDelta[0];
    private final Object target;
    private List<Issue> addedIssues;
    private List<Issue> modifiedIssues;
    private List<Issue> removedIssues;

    public IssueDelta(Object target) {
        this.target = target;
    }

    public Object getTarget() {
        return this.target;
    }

    public List<Issue> getAddedIssues() {
        return IssueDelta.nullSafeGet(this.addedIssues);
    }

    public void issueAdded(Issue issue) {
        this.addedIssues = IssueDelta.addElement(this.addedIssues, issue);
    }

    public void issuesAdded(Issue[] issues) {
        this.addedIssues = IssueDelta.addElements(this.addedIssues, issues);
    }

    public List<Issue> getModifiedIssues() {
        return IssueDelta.nullSafeGet(this.modifiedIssues);
    }

    public void issueModified(Issue issue) {
        this.modifiedIssues = IssueDelta.addElement(this.modifiedIssues, issue);
    }

    public void issuesModified(Issue[] issues) {
        this.modifiedIssues = IssueDelta.addElements(this.modifiedIssues, issues);
    }

    public List<Issue> getRemovedIssues() {
        return IssueDelta.nullSafeGet(this.removedIssues);
    }

    public void issueRemoved(Issue issue) {
        this.removedIssues = IssueDelta.addElement(this.removedIssues, issue);
    }

    public void issuesRemoved(Issue[] issues) {
        this.removedIssues = IssueDelta.addElements(this.removedIssues, issues);
    }

    private static List<Issue> nullSafeGet(List<Issue> list) {
        return list == null ? Collections.emptyList() : list;
    }

    private static List<Issue> addElement(List<Issue> list, Issue element) {
        if (list == null) {
            list = CollectionUtils.newList();
        }
        list.add(element);
        return list;
    }

    private static List<Issue> addElements(List<Issue> list, Issue[] elements) {
        if (list == null) {
            list = CollectionUtils.newList();
        }
        int i = 0;
        while (i < elements.length) {
            list.add(elements[i]);
            ++i;
        }
        return list;
    }
}

