/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ScopeUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.impl.RoleValidator;
import org.eclipse.stardust.modeling.validation.util.IModelParticipantUtils;

public class OrganizationValidator
implements IModelElementValidator {
    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        OrganizationType organization = (OrganizationType)element;
        if (IModelParticipantUtils.isDuplicateId((IModelParticipant)organization)) {
            result.add(Issue.error((EObject)organization, Validation_Messages.ERR_ORGANIZATION_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (RoleValidator.worksForAnyOrganization((IModelParticipant)organization) > 1) {
            result.add(Issue.error((EObject)organization, Validation_Messages.ERR_ORGANIZATION_PartOf, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (AttributeUtil.getBooleanValue((IExtensibleElement)organization, (String)"carnot:engine:bound") && !ScopeUtils.isValidScopeData((IExtensibleElement)organization, null, null)) {
            result.add(Issue.error((EObject)organization, Validation_Messages.ERR_ORGANIZATION_InvalidScopeData, "carnot:engine:dataId"));
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

