/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime.listener;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelLookupService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;

public class RuntimeModelRunControlServiceListener
implements IRunControl.RunControlListener {
    private final IRuntimeModel model;

    public RuntimeModelRunControlServiceListener(IRuntimeModel model) {
        Assert.isNotNull((Object)model);
        this.model = model;
    }

    public final IRuntimeModel getModel() {
        return this.model;
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
    }

    public void contextRemoved(String[] context_ids) {
        if (context_ids != null && context_ids.length > 0) {
            IModelLookupService lkupService = (IModelLookupService)this.model.getService(IModelLookupService.class);
            IModelRefreshService refreshService = (IModelRefreshService)this.model.getService(IModelRefreshService.class);
            ArrayList<String> parentContextIDs = new ArrayList<String>();
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String contextID = stringArray[n2];
                if (contextID != null && !"".equals(contextID.trim())) {
                    String[] parts;
                    int n3;
                    IModelNode[] candidates = lkupService.lkupModelNodesById(contextID);
                    if (candidates != null && candidates.length > 0) {
                        IModelNode[] iModelNodeArray = candidates;
                        n3 = candidates.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelNode node = iModelNodeArray[n4];
                            refreshService.refresh(node, null);
                            ++n4;
                        }
                    }
                    if ((parts = contextID.split("\\.")).length > 1) {
                        String[] stringArray2 = parts;
                        int n5 = parts.length;
                        n3 = 0;
                        while (n3 < n5) {
                            String partID = stringArray2[n3];
                            candidates = lkupService.lkupModelNodesById(contextID);
                            if (candidates != null && candidates.length > 0 && !parentContextIDs.contains(partID)) {
                                parentContextIDs.add(partID);
                            }
                            ++n3;
                        }
                    }
                }
                ++n2;
            }
            for (String parentContextID : parentContextIDs) {
                IModelNode[] candidates = lkupService.lkupModelNodesById(parentContextID);
                if (candidates == null || candidates.length <= 0) continue;
                IModelNode[] iModelNodeArray = candidates;
                int n6 = candidates.length;
                int n7 = 0;
                while (n7 < n6) {
                    IModelNode node = iModelNodeArray[n7];
                    refreshService.refresh(node, null);
                    ++n7;
                }
            }
        }
    }

    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
    }

    public void contextResumed(String context) {
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
    }

    public void containerResumed(String[] context_ids) {
    }

    public void contextException(String context, String msg) {
    }
}

