/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.compare;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.AbstractGetFileContentOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.GetLocalFileContentOperation;
import org.eclipse.team.svn.core.operation.remote.GetFileContentOperation;
import org.eclipse.team.svn.core.resource.ILocalFile;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceCompareInput
extends SaveableCompareEditorInput {
    protected ResourceCompareViewer viewer;
    protected BaseCompareNode root;
    protected IRepositoryResource rootLeft;
    protected IRepositoryResource rootAncestor;
    protected IRepositoryResource rootRight;
    protected String forceId;

    public static void openCompareEditor(ResourceCompareInput compare, boolean forceReuse) {
        IWorkbenchPage page = UIMonitorUtility.getActivePage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part instanceof IReusableEditor && !part.isDirty() && ((Object)((Object)compare)).getClass().equals(part.getEditorInput().getClass())) {
                ResourceCompareInput existing = (ResourceCompareInput)part.getEditorInput();
                if (compare.equals((Object)existing)) {
                    page.activate((IWorkbenchPart)part);
                    return;
                }
                if (forceReuse || existing.getForceId() != null && existing.getForceId().equals(compare.getForceId())) {
                    CompareUI.reuseCompareEditor((CompareEditorInput)compare, (IReusableEditor)((IReusableEditor)part));
                    page.activate((IWorkbenchPart)part);
                    return;
                }
            }
            ++i;
        }
        CompareUI.openCompareEditor((CompareEditorInput)compare);
    }

    protected void fireInputChange() {
        if (this.root != null) {
            this.root.fireChange();
        }
    }

    public ResourceCompareInput(CompareConfiguration configuration) {
        super(configuration, UIMonitorUtility.getActivePage());
    }

    public void setForceId(String forceId) {
        this.forceId = forceId;
    }

    public String getForceId() {
        return this.forceId;
    }

    public void initialize(IProgressMonitor monitor) throws Exception {
        this.refreshTitles();
    }

    public final Viewer createDiffViewer(Composite parent) {
        this.viewer = this.createDiffViewerImpl(parent, this.getCompareConfiguration());
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                TreeSelection selection = (TreeSelection)ResourceCompareInput.this.viewer.getSelection();
                if (selection.size() != 0) {
                    ResourceCompareInput.this.fillMenu(manager, selection);
                    manager.add((IContributionItem)new Separator());
                }
                manager.add((IAction)new Action(SVNUIMessages.SynchronizeActionGroup_ExpandAll){

                    public void run() {
                        (this).ResourceCompareInput.this.viewer.expandAll();
                    }
                });
            }
        });
        this.viewer.getControl().setMenu(menu);
        return this.viewer;
    }

    protected abstract void fillMenu(IMenuManager var1, TreeSelection var2);

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(((Object)((Object)this)).getClass())) {
            ResourceCompareInput other = (ResourceCompareInput)((Object)obj);
            return this.rootLeft.equals(other.rootLeft) && this.rootRight.equals(other.rootRight) && (this.rootAncestor == other.rootAncestor || this.rootAncestor != null && this.rootAncestor.equals(other.rootAncestor));
        }
        return false;
    }

    protected ResourceCompareViewer createDiffViewerImpl(Composite parent, CompareConfiguration config) {
        return new ResourceCompareViewer(parent, config);
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.root != null) {
            CompositeOperation op;
            ResourceElement left = (ResourceElement)this.root.getLeft();
            ResourceElement ancestor = (ResourceElement)this.root.getAncestor();
            ResourceElement right = (ResourceElement)this.root.getRight();
            if ((left.getType() == "FOLDER" || ancestor != null && ancestor.getType() == "FOLDER" || right.getType() == "FOLDER") && (this.root.getKind() & 3) != 0) {
                this.root = (BaseCompareNode)this.root.getParent();
            }
            if ((op = this.root.getFetcher()) != null) {
                ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
            }
        }
        monitor.done();
        return this.root;
    }

    protected void findRootNode(Map<IPath, IDiffElement> path2node, IRepositoryResource resource, IProgressMonitor monitor) {
        this.root = (BaseCompareNode)path2node.get(SVNUtility.createPathForSVNUrl((String)resource.getUrl()));
    }

    protected void refreshTitles() throws Exception {
        if (this.root == null) {
            return;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftLabel(this.getLeftLabel());
        cc.setLeftImage(this.getLeftImage());
        cc.setRightLabel(this.getRightLabel());
        cc.setRightImage(this.getRightImage());
        ResourceElement left = this.getLeftResourceElement();
        String leftRevisionPart = this.getRevisionPart(left);
        String leftResourceName = left.getName();
        ResourceElement right = this.getRightResourceElement();
        String rightRevisionPart = this.getRevisionPart(right);
        String rightResourceName = right.getName();
        if (this.isThreeWay()) {
            cc.setAncestorLabel(this.getAncestorLabel());
            cc.setAncestorImage(this.getAncestorImage());
            ResourceElement ancestor = this.getAncestorResourceElement();
            String ancestorRevisionPart = this.getRevisionPart(ancestor);
            String ancestorResourceName = ancestor.getName();
            String leftPart = String.valueOf(leftResourceName) + " [" + leftRevisionPart;
            String ancestorPart = " ";
            String rightPart = " ";
            boolean leftEquals = leftResourceName.equals(ancestorResourceName);
            boolean rightEquals = rightResourceName.equals(ancestorResourceName);
            if (leftEquals) {
                leftPart = String.valueOf(leftPart) + " ";
                if (rightEquals) {
                    ancestorPart = String.valueOf(ancestorPart) + ancestorRevisionPart + " ";
                    rightPart = String.valueOf(rightPart) + rightRevisionPart + "]";
                } else {
                    ancestorPart = String.valueOf(ancestorPart) + ancestorRevisionPart + "] ";
                    rightPart = String.valueOf(rightPart) + rightResourceName + " [" + rightRevisionPart + "]";
                }
            } else if (rightEquals) {
                leftPart = String.valueOf(leftPart) + "] ";
                ancestorPart = String.valueOf(ancestorPart) + ancestorResourceName + " [" + ancestorRevisionPart + " ";
                rightPart = String.valueOf(rightPart) + rightRevisionPart + "]";
            } else {
                leftPart = String.valueOf(leftPart) + "] ";
                ancestorPart = String.valueOf(ancestorPart) + ancestorResourceName + " [" + ancestorRevisionPart + "] ";
                rightPart = String.valueOf(rightPart) + rightResourceName + " [" + rightRevisionPart + "]";
            }
            this.setTitle(SVNUIMessages.format((String)SVNUIMessages.ResourceCompareInput_Title3, (Object[])new Object[]{leftPart, ancestorPart, rightPart}));
        } else {
            String leftPart = String.valueOf(leftResourceName) + " [" + leftRevisionPart;
            String rightPart = " ";
            if (leftResourceName.equals(rightResourceName)) {
                leftPart = String.valueOf(leftPart) + " ";
                rightPart = String.valueOf(rightPart) + rightRevisionPart + "]";
            } else {
                leftPart = String.valueOf(leftPart) + "] ";
                rightPart = String.valueOf(rightPart) + rightResourceName + " [" + rightRevisionPart + "]";
            }
            this.setTitle(SVNUIMessages.format((String)SVNUIMessages.ResourceCompareInput_Title2, (Object[])new Object[]{leftPart, rightPart}));
        }
    }

    protected String getAncestorLabel() throws Exception {
        return this.getLabel(this.getAncestorResourceElement());
    }

    protected Image getAncestorImage() throws Exception {
        return CompareUI.getImage((IAdaptable)RepositoryFolder.wrapChild(null, this.getAncestorResourceElement().getRepositoryResource(), null));
    }

    protected String getLeftLabel() throws Exception {
        return this.getLabel(this.getLeftResourceElement());
    }

    protected Image getLeftImage() throws Exception {
        return CompareUI.getImage((IAdaptable)RepositoryFolder.wrapChild(null, this.getLeftResourceElement().getRepositoryResource(), null));
    }

    protected String getRightLabel() throws Exception {
        return this.getLabel(this.getRightResourceElement());
    }

    protected Image getRightImage() throws Exception {
        return CompareUI.getImage((IAdaptable)RepositoryFolder.wrapChild(null, this.getRightResourceElement().getRepositoryResource(), null));
    }

    protected String getLabel(ResourceElement element) throws Exception {
        return String.valueOf(element.getRepositoryResource().getUrl()) + " [" + this.getRevisionPart(element) + "]";
    }

    protected String getRevisionPart(ResourceElement element) throws Exception {
        IRepositoryResource resource = element.getRepositoryResource();
        SVNRevision selected = resource.getSelectedRevision();
        if (selected == SVNRevision.INVALID_REVISION) {
            return SVNUIMessages.ResourceCompareInput_ResourceIsNotAvailable;
        }
        return SVNUIMessages.format((String)SVNUIMessages.ResourceCompareInput_RevisionSign, (Object[])new String[]{String.valueOf(resource.getRevision())});
    }

    protected ResourceElement getLeftResourceElement() {
        DiffNode node = this.getSelectedNode();
        if (node != null) {
            return (ResourceElement)node.getLeft();
        }
        return (ResourceElement)this.root.getLeft();
    }

    protected ResourceElement getRightResourceElement() {
        DiffNode node = this.getSelectedNode();
        if (node != null) {
            return (ResourceElement)node.getRight();
        }
        return (ResourceElement)this.root.getRight();
    }

    protected ResourceElement getAncestorResourceElement() {
        DiffNode node = this.getSelectedNode();
        if (node != null) {
            return (ResourceElement)node.getAncestor();
        }
        return (ResourceElement)this.root.getAncestor();
    }

    protected DiffNode getSelectedNode() {
        IStructuredSelection selection;
        if (this.viewer != null && (selection = (IStructuredSelection)this.viewer.getSelection()) != null && !selection.isEmpty() && selection.getFirstElement() instanceof DiffNode) {
            return (DiffNode)selection.getFirstElement();
        }
        return null;
    }

    protected IDiffContainer getParentCompareNode(IRepositoryResource current, Map<IPath, IDiffContainer> path2node) throws Exception {
        IRepositoryResource parent = current.getParent();
        if (parent == null) {
            return null;
        }
        IPath parentUrl = SVNUtility.createPathForSVNUrl((String)parent.getUrl());
        IDiffContainer node = path2node.get(parentUrl);
        if (node == null) {
            node = this.makeStubNode(this.getParentCompareNode(parent, path2node), parent);
            path2node.put(parentUrl, node);
        }
        return node;
    }

    protected static int getDiffKind(SVNEntryStatus.Kind textStatus, SVNEntryStatus.Kind propStatus) {
        if (textStatus == SVNEntryStatus.Kind.ADDED || textStatus == SVNEntryStatus.Kind.UNVERSIONED) {
            return 1;
        }
        if (textStatus == SVNEntryStatus.Kind.DELETED) {
            return 2;
        }
        if (textStatus == SVNEntryStatus.Kind.REPLACED) {
            return 3;
        }
        if (textStatus == SVNEntryStatus.Kind.MODIFIED || propStatus == SVNEntryStatus.Kind.MODIFIED) {
            return 3;
        }
        return 0;
    }

    protected SVNEntry.Kind getNodeKind(SVNDiffStatus st, boolean ignoreNone) {
        return SVNUtility.getNodeKind((String)st.pathPrev, (SVNEntry.Kind)st.nodeKind, (boolean)ignoreNone);
    }

    protected IRepositoryResource createResourceFor(IRepositoryLocation location, SVNEntry.Kind kind, String url) {
        IRepositoryFile retVal = null;
        if (kind == SVNEntry.Kind.FILE) {
            retVal = location.asRepositoryFile(url, false);
        } else if (kind == SVNEntry.Kind.DIR) {
            retVal = location.asRepositoryContainer(url, false);
        }
        if (retVal == null) {
            throw new RuntimeException(SVNUIMessages.getErrorString("Error_CompareUnknownNodeKind"));
        }
        return retVal;
    }

    protected abstract boolean isThreeWay();

    protected abstract IDiffContainer makeStubNode(IDiffContainer var1, IRepositoryResource var2);

    protected class BaseCompareNode
    extends DiffNode {
        public BaseCompareNode(IDiffContainer parent, int kind) {
            super(parent, kind);
        }

        public void fireChange() {
            super.fireChange();
        }

        protected String detectCharset(InputStream stream) throws Exception {
            String string;
            try {
                IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(stream, this.getName(), IContentDescription.ALL);
                string = description == null ? null : description.getCharset();
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (Exception exception) {}
            return string;
        }

        public CompositeOperation getFetcher() {
            AbstractGetFileContentOperation fetchOp;
            final ResourceElement left = (ResourceElement)this.getLeft();
            final ResourceElement ancestor = (ResourceElement)this.getAncestor();
            final ResourceElement right = (ResourceElement)this.getRight();
            CompositeOperation op = new CompositeOperation(SVNUIMessages.ResourceCompareInput_Fetch, SVNUIMessages.class);
            boolean hasFile = false;
            if (left != null && left.getType() != "FOLDER") {
                fetchOp = left.getFetcher();
                if (fetchOp != null) {
                    op.add((IActionOperation)fetchOp);
                    op.add((IActionOperation)new AbstractActionOperation("Operation_DetectCharset", SVNMessages.class){

                        protected void runImpl(IProgressMonitor monitor) throws Exception {
                            left.setCharset(BaseCompareNode.this.detectCharset(fetchOp.getContent()));
                        }
                    }, new IActionOperation[]{fetchOp});
                }
                hasFile = true;
            }
            if (ancestor != null && ancestor.getType() != "FOLDER") {
                fetchOp = ancestor.getFetcher();
                if (fetchOp != null) {
                    op.add((IActionOperation)fetchOp);
                    op.add((IActionOperation)new AbstractActionOperation("Operation_DetectCharset", SVNMessages.class){

                        protected void runImpl(IProgressMonitor monitor) throws Exception {
                            ancestor.setCharset(BaseCompareNode.this.detectCharset(fetchOp.getContent()));
                        }
                    }, new IActionOperation[]{fetchOp});
                }
                hasFile = true;
            }
            if (right != null && right.getType() != "FOLDER") {
                fetchOp = right.getFetcher();
                if (fetchOp != null) {
                    op.add((IActionOperation)fetchOp);
                    op.add((IActionOperation)new AbstractActionOperation("Operation_DetectCharset", SVNMessages.class){

                        protected void runImpl(IProgressMonitor monitor) throws Exception {
                            right.setCharset(BaseCompareNode.this.detectCharset(fetchOp.getContent()));
                        }
                    }, new IActionOperation[]{fetchOp});
                }
                hasFile = true;
            }
            return hasFile ? op : null;
        }
    }

    protected class ResourceCompareViewer
    extends DiffTreeViewer {
        public ResourceCompareViewer(Composite parent, CompareConfiguration configuration) {
            super(parent, configuration);
        }

        public void setComparator(ViewerComparator comparator) {
            super.setComparator(new ViewerComparator(){

                public int category(Object element) {
                    return ((IDiffElement)element).getType() == "FOLDER" ? 0 : 1;
                }
            });
        }

        protected void handleDoubleSelect(final SelectionEvent event) {
            BaseCompareNode node = (BaseCompareNode)((Object)((TreeItem)event.item).getData());
            CompositeOperation fetchContent = node.getFetcher();
            if (fetchContent != null) {
                if (!fetchContent.isEmpty()) {
                    fetchContent.add((IActionOperation)new AbstractActionOperation("Operation_FetchContent", SVNUIMessages.class){

                        protected void runImpl(IProgressMonitor monitor) throws Exception {
                            final Throwable[] t = new Throwable[1];
                            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    try {
                                        ResourceCompareInput.this.refreshTitles();
                                        ResourceCompareViewer.super.handleOpen(event);
                                    }
                                    catch (Exception e) {
                                        t[0] = e;
                                    }
                                }
                            });
                            if (t[0] != null) {
                                this.reportStatus(4, null, t[0]);
                            }
                        }
                    });
                    UIMonitorUtility.doTaskNowDefault((IActionOperation)fetchContent, true);
                } else {
                    try {
                        ResourceCompareInput.this.refreshTitles();
                    }
                    catch (Exception exception) {}
                }
            } else {
                ISelection selection = this.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object next : (IStructuredSelection)selection) {
                        if (!this.getExpandedState(next)) {
                            this.expandToLevel(next, 1);
                            continue;
                        }
                        this.collapseToLevel(next, 1);
                    }
                }
            }
            super.handleDoubleSelect(event);
        }

        protected class LabelProviderWrapper
        implements ILabelProvider {
            protected Map<Object, Image> images = new HashMap<Object, Image>();
            protected ILabelProvider baseProvider;

            public LabelProviderWrapper(ILabelProvider baseProvider) {
                this.baseProvider = baseProvider;
            }

            public void addListener(ILabelProviderListener listener) {
                this.baseProvider.addListener(listener);
            }

            public void removeListener(ILabelProviderListener listener) {
                this.baseProvider.removeListener(listener);
            }

            public boolean isLabelProperty(Object element, String property) {
                return this.baseProvider.isLabelProperty(element, property);
            }

            public String getText(Object element) {
                return this.baseProvider.getText(element);
            }

            public Image getImage(Object element) {
                return this.baseProvider.getImage(element);
            }

            public void dispose() {
                Iterator<Image> it = this.images.values().iterator();
                while (it.hasNext()) {
                    it.next().dispose();
                }
                this.baseProvider.dispose();
            }
        }
    }

    public class ResourceElement
    implements ITypedElement,
    IEncodedStreamContentAccessor,
    IContentChangeNotifier,
    IEditableContent {
        protected Vector<IContentChangeListener> listenerList;
        protected boolean dirty;
        protected String charset;
        protected IRepositoryResource resource;
        protected AbstractGetFileContentOperation op;
        protected ILocalResource localAlias;
        protected boolean editable;

        public ResourceElement(IRepositoryResource resource, ILocalResource alias, boolean showContent) {
            this.resource = resource;
            this.localAlias = alias;
            this.editable = false;
            this.listenerList = new Vector();
            if (!showContent) {
                this.resource.setSelectedRevision((SVNRevision)SVNRevision.INVALID_REVISION);
            }
        }

        public String getCharset() {
            if (this.charset == null) {
                if (this.localAlias != null && this.localAlias.getResource() instanceof IEncodedStorage) {
                    IEncodedStorage es = (IEncodedStorage)this.localAlias.getResource();
                    try {
                        return es.getCharset();
                    }
                    catch (CoreException coreException) {}
                }
                return null;
            }
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void addContentChangeListener(IContentChangeListener listener) {
            this.listenerList.add(listener);
        }

        public void removeContentChangeListener(IContentChangeListener listener) {
            this.listenerList.remove(listener);
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean isEditable() {
            return this.editable && this.localAlias instanceof ILocalFile;
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return dest;
        }

        public void commit(IProgressMonitor pm) throws CoreException {
            if (this.isDirty()) {
                IFile file = (IFile)this.localAlias.getResource();
                file.refreshLocal(0, pm);
                this.dirty = false;
            }
        }

        public void setContent(byte[] newContent) {
            if (this.isEditable() && this.op != null) {
                this.op.setContent(newContent);
                this.fireContentChanged();
            }
        }

        public IRepositoryResource getRepositoryResource() {
            return this.resource;
        }

        public ILocalResource getLocalResource() {
            return this.localAlias;
        }

        public String getName() {
            return this.resource.getName();
        }

        public Image getImage() {
            return CompareUI.getImage((IAdaptable)RepositoryFolder.wrapChild(null, this.resource, null));
        }

        public String getType() {
            if (this.resource instanceof IRepositoryContainer) {
                return "FOLDER";
            }
            String fileName = this.resource.getName();
            int dotIdx = fileName.lastIndexOf(46);
            return dotIdx == -1 ? "???" : fileName.substring(dotIdx + 1);
        }

        public AbstractGetFileContentOperation getFetcher() {
            if (this.op != null && this.op.getExecutionState() == 0) {
                return null;
            }
            if (this.resource instanceof IRepositoryFile) {
                if (this.resource.getSelectedRevision() != SVNRevision.INVALID_REVISION) {
                    SVNRevision.Kind revisionKind = this.resource.getSelectedRevision().getKind();
                    this.op = revisionKind == SVNRevision.Kind.WORKING || revisionKind == SVNRevision.Kind.BASE ? new GetLocalFileContentOperation(this.localAlias.getResource(), revisionKind) : new GetFileContentOperation(this.resource);
                    return this.op;
                }
                if (this.isEditable()) {
                    this.op = new GetLocalFileContentOperation(this.localAlias.getResource(), SVNRevision.Kind.WORKING);
                    return this.op;
                }
            }
            this.op = null;
            return null;
        }

        public InputStream getContents() {
            return this.op == null || this.op.getExecutionState() != 0 ? null : this.op.getContent();
        }

        protected void fireContentChanged() {
            this.dirty = true;
            IContentChangeListener[] listeners = this.listenerList.toArray(new IContentChangeListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].contentChanged((IContentChangeNotifier)this);
                ++i;
            }
        }
    }
}

