/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.decorator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.decorator.DecoratorVariables;
import org.eclipse.team.svn.ui.decorator.IDecorationFilter;
import org.eclipse.team.svn.ui.decorator.IVariable;
import org.eclipse.team.svn.ui.decorator.IVariableContentProvider;
import org.eclipse.team.svn.ui.decorator.TextVariableSetProvider;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.DateFormatter;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.mapping.ITeamStateDescription;
import org.eclipse.team.ui.mapping.SynchronizationStateTester;
import org.eclipse.team.ui.synchronize.TeamStateDescription;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class SVNLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IResourceStatesListener {
    public static final String ID = "org.eclipse.team.svn.ui.decorator.SVNLightweightDecorator";
    protected static final ImageDescriptor OVR_VERSIONED = TeamImages.getImageDescriptor((String)"ovr/version_controlled.gif");
    protected static final ImageDescriptor OVR_ADDED = TeamImages.getImageDescriptor((String)"ovr/waiting_ovr.gif");
    protected static ImageDescriptor OVR_NEW = TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif");
    protected static ImageDescriptor OVR_MODIFIED = TeamImages.getImageDescriptor((String)"ovr/dirty_ov.gif");
    protected static ImageDescriptor OVR_CONFLICTED;
    protected static ImageDescriptor OVR_OBSTRUCTED;
    protected static ImageDescriptor OVR_DELETED;
    protected static ImageDescriptor OVR_LOCKED;
    protected static ImageDescriptor OVR_NEEDS_LOCK;
    protected static ImageDescriptor OVR_SWITCHED;
    protected IPropertyChangeListener configurationListener;
    protected boolean indicateConflicted;
    protected boolean indicateModified;
    protected boolean indicateRemote;
    protected boolean indicateAdded;
    protected boolean indicateNew;
    protected boolean indicateLocked;
    protected boolean indicateNeedsLock;
    protected boolean indicateSwitched;
    protected String outgoingChars;
    protected String addedChars;
    protected String trunkPrefix;
    protected String branchPrefix;
    protected String tagPrefix;
    protected boolean useFonts;
    protected IDecorationFilter filter;
    protected Font ignoredFont;
    protected Font changedFont;
    protected Color ignoredForegroundColor;
    protected Color ignoredBackgroundColor;
    protected Color changedForegroundColor;
    protected Color changedBackgroundColor;
    protected IVariable[] fileFormat;
    protected IVariable[] folderFormat;
    protected IVariable[] projectFormat;
    protected DecoratorVariables decorator;
    protected boolean computeDeep;
    private static final SynchronizationStateTester DEFAULT_TESTER;

    static {
        DEFAULT_TESTER = new SynchronizationStateTester();
    }

    public SVNLightweightDecorator() {
        this.initStatic();
        this.configurationListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("preference.decoration.") || event.getProperty().startsWith("preference.dateFormat.")) {
                    SVNLightweightDecorator.this.loadConfiguration();
                    String decoratorId = this.getClass().getName();
                    SVNTeamUIPlugin.instance().getWorkbench().getDecoratorManager().update(decoratorId);
                }
            }
        };
        this.filter = ExtensionsManager.getInstance().getCurrentDecorationFilter();
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener(this.configurationListener);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener(this.configurationListener);
        SVNRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, (IResourceStatesListener)this);
        this.decorator = new DecoratorVariables(TextVariableSetProvider.instance);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener(this.configurationListener);
        SVNTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener(this.configurationListener);
        SVNRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, (IResourceStatesListener)this);
        super.dispose();
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            IResource resource = this.getResource(element);
            if (!(resource == null || resource.getType() != 8 && resource.isAccessible())) {
                return;
            }
            ResourceMapping mapping = Utils.getResourceMapping((Object)element);
            if (mapping == null || !this.isMappedToSVN(mapping)) {
                return;
            }
            IDecorationContext context = decoration.getDecorationContext();
            SynchronizationStateTester tester = DEFAULT_TESTER;
            Object property = context.getProperty("org.eclipse.team.ui.syncStateTester");
            if (property instanceof SynchronizationStateTester) {
                tester = (SynchronizationStateTester)property;
            }
            if (tester.isDecorationEnabled(element) && this.isSupervised(mapping)) {
                if (resource != null) {
                    this.decorateResource(resource, decoration);
                } else {
                    this.decorateModel(element, decoration, tester);
                }
            }
        }
        catch (Throwable ex) {
            LoggedOperation.reportError((String)"SVN Decorator", (Throwable)ex);
        }
    }

    protected void decorateModel(Object element, IDecoration decoration, SynchronizationStateTester tester) throws CoreException {
        int stateFlags = tester.getState(element, 263, (IProgressMonitor)new NullProgressMonitor());
        if (this.indicateRemote) {
            decoration.addOverlay(OVR_VERSIONED);
        }
        if ((stateFlags & 0x100) != 0) {
            decoration.addPrefix(this.outgoingChars != null ? String.valueOf(this.outgoingChars) + " " : "");
        }
        tester.elementDecorated(element, (ITeamStateDescription)new TeamStateDescription(stateFlags));
    }

    protected void decorateResource(IResource resource, IDecoration decoration) {
        int mask;
        if (!this.filter.isAcceptable(resource)) {
            return;
        }
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
        if (IStateFilter.SF_INTERNAL_INVALID.accept(local) || remote == null) {
            return;
        }
        String localStatus = this.getStatus(local);
        if (!IStateFilter.SF_NOTEXISTS.accept(resource, localStatus, mask = local.getChangeMask())) {
            if (this.fileFormat == null) {
                this.loadConfiguration();
                localStatus = this.getStatus(local);
            }
            this.decorateResourceImpl(remote, local, resource, localStatus, mask, decoration);
        }
    }

    protected void decorateResourceImpl(final IRepositoryResource remote, final ILocalResource local, final IResource resource, final String state, final int mask, IDecoration decoration) {
        if (IStateFilter.SF_TREE_CONFLICTING.accept(resource, state, mask) && this.indicateConflicted) {
            decoration.addOverlay(OVR_CONFLICTED);
        } else if (local.isLocked() && this.indicateLocked) {
            decoration.addOverlay(OVR_LOCKED);
        } else if (IStateFilter.SF_IGNORED.accept(resource, state, mask)) {
            if (this.useFonts) {
                decoration.setBackgroundColor(this.ignoredBackgroundColor);
                decoration.setForegroundColor(this.ignoredForegroundColor);
                decoration.setFont(this.ignoredFont);
            }
        } else if (IStateFilter.SF_NEW.accept(resource, state, mask)) {
            if (this.indicateNew) {
                decoration.addOverlay(OVR_NEW);
            }
        } else if (this.indicateNeedsLock && IStateFilter.SF_NEEDS_LOCK.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_NEEDS_LOCK);
        } else if (IStateFilter.SF_ADDED.accept(resource, state, mask)) {
            if (this.indicateAdded) {
                decoration.addOverlay(OVR_ADDED);
            }
        } else if (this.indicateDeleted(resource) && IStateFilter.SF_DELETED.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_DELETED);
        } else if (IStateFilter.SF_CONFLICTING.accept(resource, state, mask)) {
            if (this.indicateConflicted) {
                decoration.addOverlay(OVR_CONFLICTED);
            } else if (this.indicateModified) {
                decoration.addOverlay(OVR_MODIFIED);
            } else if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        } else if (IStateFilter.SF_MODIFIED.accept(resource, state, mask)) {
            if (this.indicateModified) {
                decoration.addOverlay(OVR_MODIFIED);
            } else if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        } else if (IStateFilter.SF_OBSTRUCTED.accept(resource, state, mask)) {
            decoration.addOverlay(OVR_OBSTRUCTED);
        } else if (IStateFilter.SF_VERSIONED.accept(resource, state, mask)) {
            if (this.indicateSwitched && (local.getChangeMask() & 8) != 0) {
                decoration.addOverlay(OVR_SWITCHED);
            } else if (this.indicateRemote) {
                decoration.addOverlay(OVR_VERSIONED);
            }
        }
        if (this.useFonts && IStateFilter.SF_ANY_CHANGE.accept(resource, state, mask)) {
            decoration.setBackgroundColor(this.changedBackgroundColor);
            decoration.setForegroundColor(this.changedForegroundColor);
            decoration.setFont(this.changedFont);
        }
        this.decorator.decorateText(decoration, this.getFormat(resource), new IVariableContentProvider(){

            public String getValue(IVariable var) {
                if (var.equals(TextVariableSetProvider.VAR_ADDED_FLAG)) {
                    return IStateFilter.SF_ADDED.accept(resource, state, mask) ? SVNLightweightDecorator.this.addedChars : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_OUTGOING_FLAG)) {
                    return IStateFilter.SF_COMMITABLE.accept(resource, state, mask) || IStateFilter.SF_CONFLICTING.accept(resource, state, mask) || IStateFilter.SF_TREE_CONFLICTING.accept(resource, state, mask) ? SVNLightweightDecorator.this.outgoingChars : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_REVISION)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(resource, state, mask) ? String.valueOf(local.getRevision()) : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_AUTHOR)) {
                    String author = local.getAuthor() == null ? "[no author]" : local.getAuthor();
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? author : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_DATE)) {
                    if (!IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return "";
                    }
                    long date = local.getLastCommitDate();
                    if (date == 0L) {
                        return SVNMessages.SVNInfo_NoDate;
                    }
                    return DateFormatter.formatDate(date);
                }
                if (var.equals(TextVariableSetProvider.VAR_RESOURCE_URL)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? SVNUtility.decodeURL((String)remote.getUrl()) : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_SHORT_RESOURCE_URL)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        String shortURL = SVNUtility.decodeURL((String)remote.getUrl()).substring(remote.getRepositoryLocation().getRepositoryRootUrl().length());
                        return shortURL.startsWith("/") ? shortURL.substring(1) : shortURL;
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_LOCATION_URL)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? remote.getRepositoryLocation().getUrlAsIs() : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_LOCATION_LABEL)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        IRepositoryLocation location = remote.getRepositoryLocation();
                        String label = location.getLabel();
                        return label == null || label.length() == 0 ? location.getUrlAsIs() : label;
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_ROOT_PREFIX)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        int kind = ((IRepositoryRoot)remote.getRoot()).getKind();
                        return kind == 3 ? SVNLightweightDecorator.this.tagPrefix : (kind == 2 ? SVNLightweightDecorator.this.branchPrefix : (kind == 1 ? SVNLightweightDecorator.this.trunkPrefix : ""));
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_ASCENDANT)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return SVNUtility.getAscendant((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_DESCENDANT)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return SVNUtility.getDescendant((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_FULLNAME)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        return SVNUtility.getPathUpToRoot((IRepositoryResource)remote);
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_FULLPATH)) {
                    if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                        String retVal = SVNUtility.getPathUpToRoot((IRepositoryResource)remote);
                        int pos = retVal.lastIndexOf(47);
                        if (pos != -1) {
                            retVal = retVal.substring(0, pos);
                        }
                        return retVal;
                    }
                    return "";
                }
                if (var.equals(TextVariableSetProvider.VAR_REMOTE_NAME)) {
                    return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) ? remote.getName() : "";
                }
                if (var.equals(TextVariableSetProvider.VAR_NAME)) {
                    return local.getName();
                }
                return var.toString();
            }
        });
    }

    protected boolean indicateDeleted(IResource resource) {
        return resource.getType() != 1;
    }

    protected IVariable[] getFormat(IResource resource) {
        if (resource.getType() == 2) {
            return this.folderFormat;
        }
        if (resource.getType() == 4) {
            return this.projectFormat;
        }
        return this.fileFormat;
    }

    protected String getStatus(ILocalResource local) {
        if (this.computeDeep && local.getResource().getType() != 1 && local.getStatus() == "Normal" && FileUtility.checkForResourcesPresenceRecursive((IResource[])new IResource[]{local.getResource()}, (IStateFilter)IStateFilter.SF_MODIFIED_NOT_IGNORED)) {
            return "Modified";
        }
        return local.getStatus();
    }

    protected boolean isSupervised(ResourceMapping mapping) throws CoreException {
        ResourceTraversal[] resourceTraversalArray = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
        int n = resourceTraversalArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] iResourceArray = traversal.getResources();
            int n3 = iResourceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resource = iResourceArray[n4];
                if (UpdateSubscriber.instance().isSupervised(resource)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isMappedToSVN(ResourceMapping mapping) {
        IProject[] iProjectArray = mapping.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryProvider provider;
            IProject project = iProjectArray[n2];
            if (project != null && project.isAccessible() && (provider = RepositoryProvider.getProvider((IProject)project)) instanceof SVNTeamProvider) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IResource getResource(Object element) {
        if (element instanceof ResourceMapping) {
            element = ((ResourceMapping)element).getModelObject();
        }
        return Utils.getResource((Object)element);
    }

    protected synchronized void initStatic() {
        OVR_NEW = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/new_resource.gif");
        OVR_CONFLICTED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/conflicted_unresolved.gif");
        OVR_OBSTRUCTED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/obstructed.gif");
        OVR_DELETED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/deleted.gif");
        OVR_LOCKED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/lock.gif");
        OVR_NEEDS_LOCK = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/needs_lock.gif");
        OVR_SWITCHED = SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/switched.gif");
    }

    protected void loadConfiguration() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        this.indicateConflicted = SVNTeamPreferences.getDecorationBoolean(store, "icon.conflicted");
        this.indicateModified = SVNTeamPreferences.getDecorationBoolean(store, "icon.modified");
        this.indicateRemote = SVNTeamPreferences.getDecorationBoolean(store, "icon.remote");
        this.indicateAdded = SVNTeamPreferences.getDecorationBoolean(store, "icon.added");
        this.indicateNew = SVNTeamPreferences.getDecorationBoolean(store, "icon.new");
        this.indicateLocked = SVNTeamPreferences.getDecorationBoolean(store, "icon.locked");
        this.indicateNeedsLock = SVNTeamPreferences.getDecorationBoolean(store, "icon.needslock");
        this.indicateSwitched = SVNTeamPreferences.getDecorationBoolean(store, "icon.switched");
        this.outgoingChars = SVNTeamPreferences.getDecorationString(store, "flag.outgoing");
        this.addedChars = SVNTeamPreferences.getDecorationString(store, "flag.added");
        this.trunkPrefix = SVNTeamPreferences.getDecorationString(store, "trunk.branch");
        this.branchPrefix = SVNTeamPreferences.getDecorationString(store, "prefix.branch");
        this.tagPrefix = SVNTeamPreferences.getDecorationString(store, "prefix.tag");
        this.useFonts = SVNTeamPreferences.getDecorationBoolean(store, "use.fontdecor");
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                Color sample = Display.getCurrent().getSystemColor(25);
                SVNLightweightDecorator.this.ignoredFont = current.getFontRegistry().get(SVNTeamPreferences.fullDecorationName("ignored_resource_font"));
                SVNLightweightDecorator.this.changedFont = current.getFontRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_font"));
                SVNLightweightDecorator.this.ignoredForegroundColor = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("ignored_resource_foreground_color"));
                Color c = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("ignored_resource_background_color"));
                SVNLightweightDecorator.this.ignoredBackgroundColor = c == null || c.equals((Object)sample) ? null : c;
                SVNLightweightDecorator.this.changedForegroundColor = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_foreground_color"));
                c = current.getColorRegistry().get(SVNTeamPreferences.fullDecorationName("outgoing_change_background_color"));
                SVNLightweightDecorator.this.changedBackgroundColor = c == null || c.equals((Object)sample) ? null : c;
            }
        });
        this.computeDeep = SVNTeamPreferences.getDecorationBoolean(store, "compute.deep");
        String formatLine = SVNTeamPreferences.getDecorationString(store, "format.folder");
        this.folderFormat = this.decorator.parseFormatLine(formatLine);
        formatLine = SVNTeamPreferences.getDecorationString(store, "format.file");
        this.fileFormat = this.decorator.parseFormatLine(formatLine);
        formatLine = SVNTeamPreferences.getDecorationString(store, "format.project");
        this.projectFormat = this.decorator.parseFormatLine(formatLine);
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])event.getResourcesRecursivelly()));
    }
}

