/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IPostCommitErrorsProvider;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.eclipse.team.svn.core.operation.local.MarkAsMergedOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.ResourcesTraversalOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.RevertOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.operation.local.change.visitors.RemoveNonVersionedVisitor;
import org.eclipse.team.svn.core.resource.ILocalFile;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.core.synchronize.UpdateSyncInfo;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.local.UpdateAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.eclipse.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.eclipse.team.svn.ui.operation.ShowPostCommitErrorsOperation;
import org.eclipse.team.svn.ui.panel.local.OverrideResourcesPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.utility.UnacceptableOperationNotificator;

public class UpdateSubscriberContext
extends SubscriberMergeContext {
    protected int type;

    public UpdateSubscriberContext(Subscriber subscriber, ISynchronizationScopeManager manager, int type) {
        super(subscriber, manager);
        this.type = type;
    }

    public IStatus merge(IDiff[] deltas, boolean force, IProgressMonitor monitor) throws CoreException {
        if (force) {
            OverrideResourcesPanel panel;
            IResource[][] resources = new IResource[1][];
            ArrayList<IResource> obstructedList = new ArrayList<IResource>();
            ArrayList<IResource> overrideList = new ArrayList<IResource>();
            IDiff[] iDiffArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff diff = iDiffArray[n2];
                try {
                    IResource current = this.getDiffTree().getResource(diff);
                    AbstractSVNSyncInfo info = (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo(current);
                    if (info != null) {
                        ILocalResource local = info.getLocalResource();
                        ILocalResource remote = info.getRemoteChangeResource();
                        if (remote instanceof IResourceChange && ISyncStateFilter.SF_OVERRIDE.acceptRemote(remote.getResource(), remote.getStatus(), remote.getChangeMask()) || ISyncStateFilter.SF_OVERRIDE.accept(local)) {
                            overrideList.add(current);
                        }
                        if (IStateFilter.SF_OBSTRUCTED.accept(local)) {
                            obstructedList.add(current);
                        }
                    }
                }
                catch (Exception ex) {
                    LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex);
                }
                ++n2;
            }
            IResource[] obstructedResources = FileUtility.addOperableParents((IResource[])obstructedList.toArray(new IResource[obstructedList.size()]), (IStateFilter)IStateFilter.SF_OBSTRUCTED);
            HashSet<IResource> allResources = new HashSet<IResource>(Arrays.asList(obstructedResources));
            final IResource[][] changedResources = new IResource[][]{overrideList.toArray(new IResource[overrideList.size()])};
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    changedResources[0] = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(UIMonitorUtility.getShell(), changedResources[0]);
                }
            });
            ArrayList<IResource> affected = new ArrayList<IResource>();
            if (changedResources[0] != null) {
                IResource[] changedWithOperableParents = FileUtility.addOperableParents((IResource[])changedResources[0], (IStateFilter)IStateFilter.SF_NOTONREPOSITORY);
                ArrayList<IResource> changedList = new ArrayList<IResource>(Arrays.asList(changedResources[0]));
                IResource[] iResourceArray = changedWithOperableParents;
                int n3 = changedWithOperableParents.length;
                int remote = 0;
                while (remote < n3) {
                    IResource current = iResourceArray[remote];
                    if (!changedList.contains(current)) {
                        IResource[] currentAffectedArray;
                        changedList.add(current);
                        IResource[] iResourceArray2 = currentAffectedArray = FileUtility.getResourcesRecursive((IResource[])new IResource[]{current}, (IStateFilter)IStateFilter.SF_ANY_CHANGE);
                        int n4 = currentAffectedArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            IResource currentAffected = iResourceArray2[n5];
                            if (!changedList.contains(currentAffected)) {
                                affected.add(currentAffected);
                            }
                            ++n5;
                        }
                    }
                    ++remote;
                }
                changedResources[0] = changedWithOperableParents;
                allResources.addAll(Arrays.asList(changedResources[0]));
            }
            if (allResources.size() > 0) {
                IResource[] fullSet = allResources.toArray(new IResource[allResources.size()]);
                panel = new OverrideResourcesPanel(fullSet, fullSet, 1, affected.toArray(new IResource[affected.size()]));
                final int[] dialogRetVal = new int[1];
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                        dialogRetVal[0] = dialog.open();
                    }
                });
                if (dialogRetVal[0] != 0) {
                    return Status.OK_STATUS;
                }
            } else {
                return Status.OK_STATUS;
            }
            resources[0] = panel.getSelectedResources();
            CompositeOperation op = new CompositeOperation("Operation_UOverrideAndUpdate", SVNUIMessages.class);
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources[0]);
            op.add((IActionOperation)saveOp);
            ResourcesTraversalOperation removeNonVersionedResourcesOp = new ResourcesTraversalOperation("Operation_RemoveNonSVN", SVNMessages.class, resources[0], (IResourceChangeVisitor)new RemoveNonVersionedVisitor(true), 2);
            op.add((IActionOperation)removeNonVersionedResourcesOp);
            RevertOperation revertOp = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_REVERTABLE, (int)0), true);
            op.add((IActionOperation)revertOp);
            op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
            RevertOperation revertOp1 = new RevertOperation(FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_OBSTRUCTED, (int)0), true);
            op.add((IActionOperation)revertOp1);
            op.add((IActionOperation)new ClearLocalStatusesOperation(resources[0]));
            HashMap<SVNRevision, HashSet<IResource>> splitted = new HashMap<SVNRevision, HashSet<IResource>>();
            splitted.put(SVNRevision.HEAD, new HashSet<IResource>(Arrays.asList(resources[0])));
            for (Map.Entry entry : splitted.entrySet()) {
                final IResource[] toUpdate = ((Set)entry.getValue()).toArray(new IResource[0]);
                boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
                UpdateOperation mainOp = new UpdateOperation(new IResourceProvider(){

                    public IResource[] getResources() {
                        return FileUtility.getResourcesRecursive((IResource[])toUpdate, (IStateFilter)new IStateFilter.AbstractStateFilter(){

                            protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
                                return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask) || IStateFilter.SF_NOTEXISTS.accept(resource, state, mask);
                            }

                            protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
                                return true;
                            }
                        }, (int)0);
                    }
                }, (SVNRevision)entry.getKey(), ignoreExternals);
                op.add((IActionOperation)mainOp, new IActionOperation[]{revertOp, revertOp1, removeNonVersionedResourcesOp});
                op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp), new IActionOperation[]{mainOp});
            }
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
            ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
        } else {
            ArrayList<IResource> resourcesList = new ArrayList<IResource>();
            IDiff[] allResources = deltas;
            int obstructedResources = deltas.length;
            int overrideList = 0;
            while (overrideList < obstructedResources) {
                IDiff diff = allResources[overrideList];
                try {
                    IResource current = this.getDiffTree().getResource(diff);
                    AbstractSVNSyncInfo info = (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo(current);
                    if (SyncInfo.getDirection((int)info.getKind()) == 8 || SyncInfo.getDirection((int)info.getKind()) == 12 && !IStateFilter.SF_OBSTRUCTED.accept(((UpdateSyncInfo)info).getLocalResource())) {
                        resourcesList.add(current);
                    }
                }
                catch (Exception ex) {
                    LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex);
                }
                ++overrideList;
            }
            if (resourcesList.isEmpty()) {
                return Status.OK_STATUS;
            }
            final IResource[][] resources = new IResource[][]{resourcesList.toArray(new IResource[resourcesList.size()])};
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    resources[0] = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(UIMonitorUtility.getShell(), resources[0]);
                }
            });
            if (resources[0] == null || resources[0].length == 0) {
                return Status.OK_STATUS;
            }
            resources[0] = FileUtility.addOperableParents((IResource[])resources[0], (IStateFilter)IStateFilter.SF_UNVERSIONED);
            final IResource[] missing = FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)UpdateAction.SF_MISSING_RESOURCES);
            final boolean[] missingRetVal = new boolean[1];
            if (missing.length > 0) {
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        missingRetVal[0] = UpdateAction.updateMissing(UIMonitorUtility.getShell().getShell(), missing);
                    }
                });
                if (!missingRetVal[0]) {
                    return Status.OK_STATUS;
                }
            }
            CompositeOperation op = new CompositeOperation("Operation_Update", SVNMessages.class);
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources[0]);
            op.add((IActionOperation)saveOp);
            HashMap<SVNRevision, HashSet<IResource>> splitted = new HashMap<SVNRevision, HashSet<IResource>>();
            splitted.put(SVNRevision.HEAD, new HashSet<IResource>(Arrays.asList(resources[0])));
            for (Map.Entry entry : splitted.entrySet()) {
                boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
                UpdateOperation mainOp = new UpdateOperation(((Set)entry.getValue()).toArray(new IResource[0]), (SVNRevision)entry.getKey(), ignoreExternals);
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp), new IActionOperation[]{mainOp});
                op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
            }
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
            ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
        }
        return Status.OK_STATUS;
    }

    public void markAsMerged(IDiff[] nodes, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        ArrayList<IResource> resourceList = new ArrayList<IResource>();
        IDiff[] iDiffArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff node = iDiffArray[n2];
            IResource current = this.getDiffTree().getResource(node);
            try {
                AbstractSVNSyncInfo info = (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo(current);
                if (info != null) {
                    boolean localIsFile = info.getLocalResource().getResource() instanceof IFile;
                    boolean remoteIsFile = info.getRemoteChangeResource() instanceof ILocalFile;
                    if (!IStateFilter.SF_OBSTRUCTED.accept(info.getLocalResource()) && localIsFile && remoteIsFile) {
                        resourceList.add(current);
                    }
                }
            }
            catch (Exception ex) {
                LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex);
            }
            ++n2;
        }
        IResource[] resources = resourceList.toArray(new IResource[resourceList.size()]);
        if (resources == null || resources.length == 0) {
            return;
        }
        boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
        MarkAsMergedOperation mainOp = new MarkAsMergedOperation(resources, false, null, ignoreExternals);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new ShowPostCommitErrorsOperation((IPostCommitErrorsProvider)mainOp));
        op.add((IActionOperation)new ClearUpdateStatusesOperation(resources), new IActionOperation[]{mainOp});
        op.add((IActionOperation)new RefreshResourcesOperation(FileUtility.getParents((IResource[])resources, (boolean)false)));
        ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
    }

    public ISchedulingRule getMergeRule(IDiff diff) {
        return null;
    }

    public ISchedulingRule getMergeRule(IDiff[] deltas) {
        return null;
    }

    protected void makeInSync(IDiff diff, IProgressMonitor monitor) throws CoreException {
    }

    public void markAsMerged(IDiff node, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
    }

    public void reject(IDiff diff, IProgressMonitor monitor) throws CoreException {
    }

    public static SubscriberScopeManager createWorkspaceScopeManager(ResourceMapping[] mappings, boolean consultModels, boolean consultChangeSets) {
        return new ChangeSetSubscriberScopeManager(UpdateSubscriber.instance().getName(), mappings, (Subscriber)UpdateSubscriber.instance(), consultModels, consultChangeSets);
    }

    public static SubscriberScopeManager createUpdateScopeManager(ResourceMapping[] mappings, boolean consultModels) {
        SubscriberScopeManager manager = new SubscriberScopeManager(UpdateSubscriber.instance().getName(), mappings, (Subscriber)UpdateSubscriber.instance(), consultModels);
        return manager;
    }

    public static UpdateSubscriberContext createContext(ISynchronizationScopeManager manager, int type) {
        UpdateSubscriber subscriber = UpdateSubscriber.instance();
        UpdateSubscriberContext mergeContext = new UpdateSubscriberContext((Subscriber)subscriber, manager, type);
        mergeContext.initialize();
        return mergeContext;
    }

    public static final class ChangeSetSubscriberScopeManager
    extends SubscriberScopeManager {
        private final boolean consultSets;

        private ChangeSetSubscriberScopeManager(String name, ResourceMapping[] mappings, Subscriber subscriber, boolean consultModels, boolean consultSets) {
            super(name, mappings, subscriber, consultModels);
            this.consultSets = consultSets;
        }

        protected ResourceTraversal[] adjustInputTraversals(ResourceTraversal[] traversals) {
            if (this.isConsultSets()) {
                return SVNTeamPlugin.instance().getModelChangeSetManager().adjustInputTraversals(traversals);
            }
            return super.adjustInputTraversals(traversals);
        }

        public boolean isConsultSets() {
            return this.consultSets;
        }
    }
}

