/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNDiffStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.ILocalFolder;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.compare.ComparePanel;
import org.eclipse.team.svn.ui.compare.ResourceCompareInput;
import org.eclipse.team.svn.ui.compare.ThreeWayResourceCompareInput;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareResourcesInternalOperation
extends AbstractActionOperation {
    protected ILocalResource local;
    protected IRepositoryResource ancestor;
    protected IRepositoryResource remote;
    protected boolean showInDialog;
    protected boolean forceReuse;
    protected String forceId;

    public CompareResourcesInternalOperation(ILocalResource local, IRepositoryResource remote, boolean forceReuse, boolean showInDialog) {
        super("Operation_CompareLocal", SVNUIMessages.class);
        this.local = local;
        this.ancestor = local.isCopied() ? SVNUtility.getCopiedFrom((ILocalResource)local) : SVNRemoteStorage.instance().asRepositoryResource(local.getResource());
        this.ancestor.setSelectedRevision((SVNRevision)(local.getBaseRevision() != -1L ? SVNRevision.fromNumber((long)local.getBaseRevision()) : SVNRevision.INVALID_REVISION));
        this.remote = remote;
        this.showInDialog = showInDialog;
        this.forceReuse = forceReuse;
    }

    public void setForceId(String forceId) {
        this.forceId = forceId;
    }

    public String getForceId() {
        return this.forceId;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final ArrayList<SVNDiffStatus> localChanges = new ArrayList<SVNDiffStatus>();
        final ArrayList<SVNDiffStatus> remoteChanges = new ArrayList<SVNDiffStatus>();
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.local.getResource());
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            if (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() == 7 || this.remote.getSelectedRevision() == SVNRevision.BASE) {
                this.fetchStatuses17(proxy, localChanges, remoteChanges, monitor);
            } else {
                this.fetchStatuses18(proxy, localChanges, remoteChanges, monitor);
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                CompareConfiguration cc = new CompareConfiguration();
                cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.TRUE);
                final ThreeWayResourceCompareInput compare = new ThreeWayResourceCompareInput(cc, CompareResourcesInternalOperation.this.local, CompareResourcesInternalOperation.this.ancestor, CompareResourcesInternalOperation.this.remote, localChanges, remoteChanges);
                compare.setForceId(CompareResourcesInternalOperation.this.forceId);
                compare.initialize(monitor);
                if (!monitor.isCanceled()) {
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if ((this).CompareResourcesInternalOperation.this.showInDialog) {
                                if (CompareResourcesInternalOperation.this.compareResultOK((CompareEditorInput)compare)) {
                                    ComparePanel panel = new ComparePanel((CompareEditorInput)compare, (this).CompareResourcesInternalOperation.this.local.getResource());
                                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                                    dialog.open();
                                }
                            } else {
                                ResourceCompareInput.openCompareEditor(compare, (this).CompareResourcesInternalOperation.this.forceReuse);
                            }
                        }
                    });
                }
            }
        }, monitor, 100, 50);
    }

    protected void fetchStatuses17(final ISVNConnector proxy, final ArrayList<SVNDiffStatus> localChanges, final ArrayList<SVNDiffStatus> remoteChanges, IProgressMonitor monitor) throws Exception {
        final HashMap resourcesWithChanges = new HashMap();
        final IContainer compareRoot = this.local instanceof ILocalFolder ? (IContainer)this.local.getResource() : this.local.getResource().getParent();
        IRepositoryResource resource = SVNRemoteStorage.instance().asRepositoryResource(this.local.getResource());
        final long cmpTargetRevision = resource.exists() ? resource.getRevision() : -1L;
        final LinkedHashSet<Long> revisions = new LinkedHashSet<Long>();
        if (cmpTargetRevision != -1L) {
            revisions.add(cmpTargetRevision);
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    final String rootPath = FileUtility.getWorkingCopyPath((IResource)CompareResourcesInternalOperation.this.local.getResource());
                    proxy.status(rootPath, SVNDepth.INFINITY, 8589934657L, null, new ISVNEntryStatusCallback(){

                        public void next(SVNChangeStatus status) {
                            String textStatus;
                            Path tPath = new Path(status.path.substring(rootPath.length()));
                            IResource resource = compareRoot.findMember((IPath)tPath);
                            if (resource == null) {
                                Object object = resource = status.nodeKind == SVNEntry.Kind.FILE ? compareRoot.getFile((IPath)tPath) : compareRoot.getFolder((IPath)tPath);
                            }
                            if (IStateFilter.SF_ANY_CHANGE.accept(resource, textStatus = SVNRemoteStorage.getTextStatusString((SVNEntryStatus.Kind)status.propStatus, (SVNEntryStatus.Kind)status.textStatus, (boolean)false), 0) || status.propStatus == SVNEntryStatus.Kind.MODIFIED) {
                                localChanges.add(new SVNDiffStatus(status.path, status.path, status.nodeKind, status.textStatus, status.propStatus));
                            }
                            if ((IStateFilter.SF_ANY_CHANGE.accept(resource, textStatus = SVNRemoteStorage.getTextStatusString((SVNEntryStatus.Kind)status.repositoryPropStatus, (SVNEntryStatus.Kind)status.repositoryTextStatus, (boolean)true), 0) || status.repositoryTextStatus == SVNEntryStatus.Kind.MODIFIED) && status.revision != cmpTargetRevision) {
                                resourcesWithChanges.put(resource, status.revision);
                                revisions.add(status.revision);
                            }
                        }
                    }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesInternalOperation.this, monitor, null, false));
                }
            }, monitor, 100, 10);
        } else {
            String path = FileUtility.getWorkingCopyPath((IResource)this.local.getResource());
            localChanges.add(new SVNDiffStatus(path, path, this.local.getResource().getType() == 1 ? SVNEntry.Kind.FILE : SVNEntry.Kind.DIR, SVNEntryStatus.Kind.UNVERSIONED, SVNEntryStatus.Kind.NORMAL));
        }
        if (this.remote.getSelectedRevision() != SVNRevision.BASE) {
            Iterator iterator = revisions.iterator();
            while (iterator.hasNext()) {
                final long revision = (Long)iterator.next();
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        IRepositoryResource resource = SVNRemoteStorage.instance().asRepositoryResource(CompareResourcesInternalOperation.this.local.getResource());
                        resource.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)revision));
                        SVNEntryRevisionReference refPrev = SVNUtility.getEntryRevisionReference((IRepositoryResource)resource);
                        final SVNEntryRevisionReference refNext = SVNUtility.getEntryRevisionReference((IRepositoryResource)CompareResourcesInternalOperation.this.remote);
                        final String prevRootURL = resource.getUrl();
                        proxy.diffStatusTwo(refPrev, refNext, SVNDepth.INFINITY, 0L, null, new ISVNDiffStatusCallback(){

                            public void next(SVNDiffStatus status) {
                                Long rev;
                                Path tPath = new Path(status.pathPrev.substring(prevRootURL.length()));
                                IResource resource = compareRoot.findMember((IPath)tPath);
                                if (resource == null) {
                                    Object object = resource = status.nodeKind == SVNEntry.Kind.FILE ? compareRoot.getFile((IPath)tPath) : compareRoot.getFolder((IPath)tPath);
                                }
                                if ((rev = (Long)resourcesWithChanges.get(resource)) == null || rev == revision) {
                                    String pathPrev = String.valueOf((this).CompareResourcesInternalOperation.this.ancestor.getUrl()) + status.pathNext.substring(refNext.path.length());
                                    remoteChanges.add(new SVNDiffStatus(pathPrev, status.pathNext, status.nodeKind, status.textStatus, status.propStatus));
                                }
                            }
                        }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesInternalOperation.this, monitor, null, false));
                    }
                }, monitor, 100, 40 / revisions.size());
            }
        }
    }

    protected void fetchStatuses18(final ISVNConnector proxy, final ArrayList<SVNDiffStatus> localChanges, final ArrayList<SVNDiffStatus> remoteChanges, IProgressMonitor monitor) {
        final IContainer compareRoot = this.local instanceof ILocalFolder ? (IContainer)this.local.getResource() : this.local.getResource().getParent();
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                String rootPath = FileUtility.getWorkingCopyPath((IResource)CompareResourcesInternalOperation.this.local.getResource());
                final String searchPath = CompareResourcesInternalOperation.this.local.getResource().getType() == 1 ? FileUtility.getWorkingCopyPath((IResource)CompareResourcesInternalOperation.this.local.getResource().getParent()) : rootPath;
                proxy.status(rootPath, SVNDepth.INFINITY, 8589934657L, null, new ISVNEntryStatusCallback(){

                    public void next(SVNChangeStatus status) {
                        String textStatus;
                        Path tPath = new Path(status.path.substring(searchPath.length()));
                        IResource resource = compareRoot.findMember((IPath)tPath);
                        if (resource == null) {
                            Object object = resource = status.nodeKind == SVNEntry.Kind.FILE ? compareRoot.getFile((IPath)tPath) : compareRoot.getFolder((IPath)tPath);
                        }
                        if (IStateFilter.SF_ANY_CHANGE.accept(resource, textStatus = SVNRemoteStorage.getTextStatusString((SVNEntryStatus.Kind)status.propStatus, (SVNEntryStatus.Kind)status.textStatus, (boolean)false), 0) || status.propStatus == SVNEntryStatus.Kind.MODIFIED) {
                            localChanges.add(new SVNDiffStatus(status.path, status.path, status.nodeKind, status.textStatus, status.propStatus));
                        }
                    }
                }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesInternalOperation.this, monitor, null, false));
            }
        }, monitor, 100, 10);
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                final IPath rootPath = FileUtility.getResourcePath((IResource)compareRoot);
                SVNEntryRevisionReference refPrev = new SVNEntryRevisionReference(FileUtility.getWorkingCopyPath((IResource)CompareResourcesInternalOperation.this.local.getResource()), null, SVNRevision.WORKING);
                final SVNEntryRevisionReference refNext = SVNUtility.getEntryRevisionReference((IRepositoryResource)CompareResourcesInternalOperation.this.remote);
                proxy.diffStatusTwo(refPrev, refNext, SVNDepth.INFINITY, 0L, null, new ISVNDiffStatusCallback(){

                    public void next(SVNDiffStatus status) {
                        ILocalResource local;
                        Path tPath = new Path(status.pathPrev);
                        IResource resource = compareRoot.findMember((IPath)(tPath = tPath.removeFirstSegments(rootPath.segmentCount())));
                        if (resource == null) {
                            Object object = resource = status.nodeKind == SVNEntry.Kind.FILE ? compareRoot.getFile((IPath)tPath) : compareRoot.getFolder((IPath)tPath);
                        }
                        if (!IStateFilter.SF_ANY_CHANGE.accept(local = SVNRemoteStorage.instance().asLocalResource(resource)) || IStateFilter.SF_NOTEXISTS.accept(local)) {
                            SVNEntryStatus.Kind change = status.textStatus == SVNEntryStatus.Kind.ADDED ? SVNEntryStatus.Kind.DELETED : (status.textStatus == SVNEntryStatus.Kind.DELETED ? SVNEntryStatus.Kind.ADDED : status.textStatus);
                            String pathPrev = status.pathNext.startsWith(refNext.path) ? status.pathNext.substring(refNext.path.length()) : status.pathNext;
                            pathPrev = String.valueOf((this).CompareResourcesInternalOperation.this.ancestor.getUrl()) + pathPrev;
                            remoteChanges.add(new SVNDiffStatus(pathPrev, status.pathNext, status.nodeKind, change, status.propStatus));
                        }
                    }
                }, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareResourcesInternalOperation.this, monitor, null, false));
            }
        }, monitor, 100, 40);
    }

    protected boolean compareResultOK(CompareEditorInput input) {
        block5: {
            Shell shell = UIMonitorUtility.getShell();
            try {
                SVNTeamUIPlugin.instance().getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)input);
                String message = input.getMessage();
                if (message != null) {
                    MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)message);
                    break block5;
                }
                if (input.getCompareResult() == null) {
                    MessageDialog.openInformation((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.dialogTitle"), (String)Utilities.getString((String)"CompareUIPlugin.noDifferences"));
                    break block5;
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException x) {
                MessageDialog.openError((Shell)shell, (String)Utilities.getString((String)"CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
            }
        }
        return false;
    }
}

