/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.extensions;

import java.io.File;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.extensions.ExtensionPointProxy;
import org.eclipse.thym.core.platform.AbstractProjectGeneratorDelegate;
import org.osgi.framework.Bundle;

public class PlatformSupport
extends ExtensionPointProxy {
    public static final String ASSEMBLY_ROOT = "/proj_gen/";
    public static final String EXTENSION_POINT_ID = "org.eclipse.thym.core.platformSupport";
    public static final String ATTR_PLATFORM = "platform";
    public static final String ATTR_PROJECT_GENERATOR = "projectGenerator";
    public static final String ATTR_LIBRARY_RESOLVER = "libraryResolver";
    public static final String ATTR_ID = "id";
    private static final String ATTR_PLATFORM_ID = "platformID";
    private String platform;
    private Expression expression;
    private String id;
    private String platformId;

    PlatformSupport(IConfigurationElement configurationElement) {
        super(configurationElement);
        this.id = configurationElement.getAttribute(ATTR_ID);
        this.platform = configurationElement.getAttribute(ATTR_PLATFORM);
        this.platformId = configurationElement.getAttribute(ATTR_PLATFORM_ID);
        this.configureEnablement(configurationElement.getChildren("enablement"));
    }

    private void configureEnablement(IConfigurationElement[] enablementNodes) {
        if (enablementNodes == null || enablementNodes.length < 1) {
            return;
        }
        IConfigurationElement node = enablementNodes[0];
        try {
            this.expression = ExpressionConverter.getDefault().perform(node);
        }
        catch (CoreException e) {
            HybridCore.log(4, "Error while reading the enablement", e);
        }
    }

    public AbstractProjectGeneratorDelegate createDelegate(IProject project, File generationFolder) throws CoreException {
        if (generationFolder == null) {
            generationFolder = new File(this.getTempGenerationDirectory(), this.getPlatformId());
        }
        IExtension[] extensions = this.getContributorExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getExtensionPointUniqueIdentifier().equals(EXTENSION_POINT_ID)) {
                IConfigurationElement[] configs = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    if (configs[j].getAttribute(ATTR_PLATFORM_ID).equals(this.getPlatformId())) {
                        AbstractProjectGeneratorDelegate delegate = (AbstractProjectGeneratorDelegate)configs[j].createExecutableExtension(ATTR_PROJECT_GENERATOR);
                        delegate.init(project, generationFolder, this.platformId);
                        return delegate;
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Contributing platform has changed"));
    }

    private IExtension[] getContributorExtensions() throws CoreException {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensions(this.contributor);
        if (extensions == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Contributing platform is no longer available."));
        }
        return extensions;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getID() {
        return this.id;
    }

    public boolean isEnabled(IEvaluationContext context) throws CoreException {
        if (this.expression == null) {
            return true;
        }
        if (context == null) {
            throw new IllegalArgumentException("Must have an evalutation context");
        }
        return this.expression.evaluate(context) == EvaluationResult.TRUE;
    }

    public HybridMobileLibraryResolver getLibraryResolver() throws CoreException {
        IExtension[] extensions = this.getContributorExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getExtensionPointUniqueIdentifier().equals(EXTENSION_POINT_ID)) {
                IConfigurationElement[] configs = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    if (configs[j].getAttribute(ATTR_PLATFORM_ID).equals(this.getPlatformId())) {
                        HybridMobileLibraryResolver resolver = (HybridMobileLibraryResolver)configs[j].createExecutableExtension(ATTR_LIBRARY_RESOLVER);
                        return resolver;
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Contributing platform has changed"));
    }

    public String getPlatformId() {
        return this.platformId;
    }

    protected File getTempGenerationDirectory() {
        Bundle bundle = HybridCore.getContext().getBundle();
        return bundle.getDataFile(ASSEMBLY_ROOT);
    }
}

