/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.simulator;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.ios.core.simulator.IOSDevice;
import org.eclipse.thym.ios.core.simulator.IOSSimulator;
import org.eclipse.thym.ios.core.xcode.XCodeBuild;
import org.osgi.framework.Version;

public class IOSSimulatorLaunchDelegate
implements ILaunchConfigurationDelegate2 {
    private static Version MIN_VERSION = Version.valueOf((String)"6.0.0");
    private File buildArtifact;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launch iOS Simulator", 10);
        IProject kernelProject = this.getProject(configuration);
        Assert.isNotNull((Object)kernelProject, (String)"Can not launch with a null project");
        String deviceId = configuration.getAttribute("org.eclipse.thym.ios.core.ATTR_DEVICE_IDENTIFIER", "");
        List<IOSDevice> devices = IOSSimulator.listDevices(monitor);
        if (devices == null || devices.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Failed to find an iOS simulator"));
        }
        IOSDevice device = devices.get(0);
        for (IOSDevice iosDevice : devices) {
            if (!deviceId.equals(iosDevice.getDeviceId())) continue;
            device = iosDevice;
            break;
        }
        IOSSimulator simulator = new IOSSimulator(device);
        HybridProject project = HybridProject.getHybridProject((IProject)kernelProject);
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", NLS.bind((String)"{0} is not a hybrid mobile project", (Object)kernelProject.getName())));
        }
        String bundleId = WidgetModel.getModel((HybridProject)project).getWidgetForRead().getId();
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        simulator.setProcessEnvironmentVariables(envp).launch().installApp(this.buildArtifact.getPath()).startApp(bundleId);
        monitor.worked(2);
        simulator.launch();
        monitor.done();
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return null;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        XCodeBuild build = new XCodeBuild();
        build.setLaunchConfiguration(configuration);
        build.init(this.getProject(configuration), null);
        build.buildNow(monitor);
        this.buildArtifact = build.getBuildArtifact();
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.done();
        return true;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        XCodeBuild xcode = new XCodeBuild();
        String version = xcode.version();
        try {
            Version v = Version.parseVersion((String)version);
            if (v.compareTo(MIN_VERSION) < 0) {
                throw new CoreException((IStatus)new HybridMobileStatus(4, "org.eclipse.thym.ios.core", 300, NLS.bind((String)"Hybrid mobile projects require XCode version {0} or greater to build iOS applications", (Object)"6.0.0"), null));
            }
        }
        catch (IllegalArgumentException e) {
            HybridCore.log((int)2, (String)("Error parsing the xcode version. Version String is " + version), (Throwable)e);
            return true;
        }
        monitor.done();
        return true;
    }

    private IProject getProject(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("org.eclipse.thym.core.ATTR_BUILD_SCOPE", null);
            if (projectName != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }
}

