/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.plugins.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.ui.HybridUI;
import org.eclipse.thym.ui.config.internal.ConfigEditor;
import org.eclipse.thym.ui.plugins.internal.CordovaPluginWizard;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LaunchCordovaPluginWizardAction
extends Action {
    private final ImageDescriptor icon = HybridUI.getImageDescriptor("org.eclipse.thym.ui", "/icons/obj16/plug16_obj.png");
    private ConfigEditor configEditor;
    private int initialTab = 1;

    public LaunchCordovaPluginWizardAction() {
        super("Install Cordova Plug-in");
        this.setImageDescriptor(this.icon);
    }

    public LaunchCordovaPluginWizardAction(ConfigEditor editor) {
        this();
        this.configEditor = editor;
    }

    public LaunchCordovaPluginWizardAction(ConfigEditor editor, int initialTab) {
        this(editor);
        this.initialTab = initialTab;
    }

    public void run() {
        IWorkbenchPage page;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        ISelection selection = workbenchWindow.getSelectionService().getSelection();
        if ((selection == null || selection.isEmpty()) && (page = workbenchWindow.getActivePage()) != null && page.getActiveEditor() instanceof ConfigEditor) {
            ConfigEditor editor = (ConfigEditor)page.getActiveEditor();
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
            selection = new StructuredSelection((Object)input.getFile().getProject());
        }
        Object selectionToPass = null;
        selectionToPass = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
        CordovaPluginWizard wizard = new CordovaPluginWizard();
        if (this.configEditor == null) {
            wizard.init(workbench, (IStructuredSelection)selectionToPass);
        } else {
            IResource resource = (IResource)this.configEditor.getEditorInput().getAdapter(IResource.class);
            if (resource != null) {
                HybridProject project = HybridProject.getHybridProject((IProject)resource.getProject());
                if (project != null) {
                    wizard.init(project, this.initialTab);
                } else {
                    wizard.init(workbench, (IStructuredSelection)selectionToPass);
                }
            }
        }
        WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(550, 450);
        dialog.open();
    }
}

