/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.wizard.export;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.ui.util.DirectorySelectionGroup;
import org.eclipse.thym.ui.util.HybridProjectContentProvider;
import org.eclipse.thym.ui.wizard.export.CheckboxTableSelectionGroup;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class BaseExportWizardDestinationPage
extends WizardPage {
    private CheckboxTableSelectionGroup projectGroup;
    private CheckboxTableSelectionGroup platformsGroup;
    private DirectorySelectionGroup destinationDirectoryGroup;
    private IStructuredSelection initialSelection;

    protected BaseExportWizardDestinationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.initialSelection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.projectGroup = new CheckboxTableSelectionGroup(container, 0);
        this.projectGroup.setText("Select Projects:");
        this.projectGroup.setLayoutData(new GridData(4, 0x1000000, true, true, 1, 1));
        this.projectGroup.getTableViewer().setContentProvider((IContentProvider)new HybridProjectContentProvider());
        this.projectGroup.getTableViewer().setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.projectGroup.getTableViewer().setInput((Object)HybridCore.getHybridProjects());
        this.projectGroup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BaseExportWizardDestinationPage.this.setPageComplete(BaseExportWizardDestinationPage.this.validatePage());
            }
        });
        this.platformsGroup = new CheckboxTableSelectionGroup(container, 0);
        this.platformsGroup.setLayoutData(new GridData(4, 0x1000000, true, true, 1, 1));
        this.platformsGroup.setText("Select Platforms:");
        this.platformsGroup.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BaseExportWizardDestinationPage.this.setPageComplete(BaseExportWizardDestinationPage.this.validatePage());
            }
        });
        this.platformsGroup.getTableViewer().setContentProvider(this.getPlatformContentProvider());
        this.platformsGroup.getTableViewer().setLabelProvider(this.getPlatformLabelProvider());
        this.destinationDirectoryGroup = new DirectorySelectionGroup(container, 0);
        this.destinationDirectoryGroup.setText("Destination:");
        this.destinationDirectoryGroup.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.destinationDirectoryGroup.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                BaseExportWizardDestinationPage.this.setPageComplete(BaseExportWizardDestinationPage.this.validatePage());
            }
        });
        this.restoreWidgetValues();
        this.setupFromInitialSelection();
        this.setPageComplete(this.validatePage());
    }

    protected abstract IContentProvider getPlatformContentProvider();

    protected abstract IBaseLabelProvider getPlatformLabelProvider();

    private void setupFromInitialSelection() {
        if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            for (Object obj : this.initialSelection) {
                IResource res;
                IProject project;
                HybridProject hybrid;
                if (!(obj instanceof IResource) || (hybrid = HybridProject.getHybridProject((IProject)(project = (res = (IResource)obj).getProject()))) == null) continue;
                this.projectGroup.getTableViewer().setChecked((Object)hybrid, true);
            }
        }
    }

    protected CheckboxTableSelectionGroup getPlatformsGroup() {
        return this.platformsGroup;
    }

    protected boolean validatePage() {
        TableItem[] items = this.projectGroup.getTableViewer().getTable().getItems();
        if (items == null || items.length < 1) {
            this.setMessage("No suitable projects are available", 3);
            return false;
        }
        Object[] selectedProjects = this.projectGroup.getTableViewer().getCheckedElements();
        if (selectedProjects.length < 1) {
            this.setMessage("No projects are selected. Please select projects to export", 3);
            return false;
        }
        Object[] selection = this.platformsGroup.getTableViewer().getCheckedElements();
        if (selection.length < 1) {
            this.setMessage("No platform is selected. Please select a platform", 3);
            return false;
        }
        String destination = this.destinationDirectoryGroup.getValue();
        if (destination == null || destination.isEmpty()) {
            this.setMessage("Specify a destination directory", 3);
            return false;
        }
        File dstFile = new File(destination);
        if (!DirectorySelectionGroup.isValidDirectory(dstFile)) {
            this.setMessage("Specified destination is not a valid directory", 3);
            return false;
        }
        this.setMessage(null, 0);
        return true;
    }

    void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.destinationDirectoryGroup.saveHistory(settings);
        }
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.destinationDirectoryGroup.restoreHistory(settings);
        }
    }

    public String getDestinationDirectory() {
        return this.destinationDirectoryGroup.getValue();
    }

    public List<HybridProject> getSelectedProjects() {
        Object[] checked = this.projectGroup.getTableViewer().getCheckedElements();
        ArrayList<HybridProject> list = new ArrayList<HybridProject>(checked.length);
        int i = 0;
        while (i < checked.length) {
            list.add((HybridProject)checked[i]);
            ++i;
        }
        return list;
    }
}

