/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.internal.util.FileUtils;
import org.eclipse.thym.wp.core.WPCore;
import org.eclipse.thym.wp.internal.core.Messages;

public class WPLibraryResolver
extends HybridMobileLibraryResolver {
    private static final String WP8 = "wp8";
    public static final String VERSION = "VERSION";
    public static final String WP_APP_MANIFEST_XML = "WMAppManifest.xml";
    public static final String APP_XAML = "App.xaml";
    public static final String APP_XAML_CS = "App.xaml.cs";
    public static final String MAIN_PAGE_XAML = "MainPage.xaml";
    public static final String MAIN_PAGE_XAML_CS = "MainPage.xaml.cs";
    public static final String DEFAULT_APP_NAME = "CordovaWP8AppProj";
    public static final String DEFAULT_APP_NAME_CSPROJ = "CordovaWP8AppProj.csproj";
    public static final String DEFAULT_SLN_NAME = "CordovaWP8Solution.sln";
    private static final String TEMPLATE = "template";
    private static final String PROPERTIES = "Properties";
    private HashMap<IPath, URL> files = new HashMap();

    public URL getTemplateFile(IPath destination) {
        if (this.files.isEmpty()) {
            this.initFiles();
        }
        Assert.isNotNull((Object)destination);
        Assert.isTrue((!destination.isAbsolute() ? 1 : 0) != 0);
        return this.files.get(destination);
    }

    public IStatus isLibraryConsistent() {
        if (this.version == null) {
            return new Status(4, "org.eclipse.thym.core", Messages.WPLibraryResolver_NotCompatibleError);
        }
        return this.libraryRoot.lastSegment().equals(WP8) ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    public void preCompile(IProgressMonitor monitor) throws CoreException {
    }

    public boolean needsPreCompilation() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String detectVersion() {
        File versionFile = this.libraryRoot.append(VERSION).toFile();
        if (!versionFile.exists()) {
            WPCore.log(4, NLS.bind((String)Messages.WPLibraryResolver_NoVersionError, (Object)versionFile.toString()), null);
            return null;
        }
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(versionFile));
                String version = reader.readLine();
                if (version == null) return null;
                String string = version.trim();
                return string;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            WPCore.log(4, Messages.WPLibraryResolver_CannotDetectError, e);
            return null;
        }
    }

    private void initFiles() {
        IPath templatePrjRoot = this.libraryRoot.append(TEMPLATE);
        this.files.put(PATH_CORDOVA_JS, this.getEngineFile(templatePrjRoot.append("www").append("cordova.js")));
        this.files.put((IPath)new Path("$appname"), this.getEngineFile(templatePrjRoot));
        this.files.put((IPath)new Path(VERSION), this.getEngineFile(this.libraryRoot.append(VERSION)));
        this.files.put((IPath)new Path(WP_APP_MANIFEST_XML), this.getEngineFile(templatePrjRoot.append(PROPERTIES).append(WP_APP_MANIFEST_XML)));
        this.files.put((IPath)new Path(APP_XAML), this.getEngineFile(templatePrjRoot.append(APP_XAML)));
        this.files.put((IPath)new Path(APP_XAML_CS), this.getEngineFile(templatePrjRoot.append(APP_XAML_CS)));
        this.files.put((IPath)new Path(MAIN_PAGE_XAML), this.getEngineFile(templatePrjRoot.append(MAIN_PAGE_XAML)));
        this.files.put((IPath)new Path(MAIN_PAGE_XAML_CS), this.getEngineFile(templatePrjRoot.append(MAIN_PAGE_XAML_CS)));
        this.files.put((IPath)new Path(DEFAULT_APP_NAME_CSPROJ), this.getEngineFile(templatePrjRoot.append(DEFAULT_APP_NAME_CSPROJ)));
        this.files.put((IPath)new Path(DEFAULT_SLN_NAME), this.getEngineFile(templatePrjRoot.append(DEFAULT_SLN_NAME)));
    }

    private URL getEngineFile(IPath path) {
        File file = path.toFile();
        if (!file.exists()) {
            WPCore.log(2, NLS.bind((String)Messages.WPLibraryResolver_MissingEngineError, (Object)file.toString()), null);
        }
        return FileUtils.toURL((File)file);
    }
}

