/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.wp.core.vstudio;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.thym.core.internal.util.ExternalProcessUtility;
import org.eclipse.thym.wp.core.WPCore;
import org.eclipse.thym.wp.internal.core.Messages;

public class WPEmulator {
    private static final String APP_DEPLOY_CMD_EXE = "AppDeployCmd.exe";
    private static final String APP_DEPLOY = "AppDeploy";
    private static final String XAP_DEPLOY_CMD_EXE = "XapDeployCmd.exe";
    private static final String XAP_DEPLOYMENT = "XAP Deployment";
    private static final String TOOLS = "Tools";
    private String sdkLocation;
    private String[] environment;
    private IProgressMonitor monitor;

    public WPEmulator(String sdkLocation) {
        this.sdkLocation = sdkLocation;
    }

    public void emulate(File xapFile, int deviceId) throws CoreException {
        if (this.sdkLocation == null) {
            this.sdkLocation = WPCore.getSDKLocation();
            if (this.sdkLocation == null) {
                return;
            }
        }
        File deployCmd = this.getDeployCommand();
        this.installLaunch(deployCmd, xapFile, deviceId);
    }

    public Map<String, Integer> getDevices() throws CoreException {
        if (this.sdkLocation == null) {
            this.sdkLocation = WPCore.getSDKLocation();
            if (this.sdkLocation == null) {
                return null;
            }
        }
        File deployCmd = this.getDeployCommand();
        StringBuilder cmdLine = new StringBuilder();
        cmdLine.append(this.addQuotes(deployCmd.getAbsolutePath()));
        cmdLine.append(" /EnumerateDevices");
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        DeviceListParser parser = new DeviceListParser();
        processUtility.execSync(cmdLine.toString(), null, (IStreamListener)parser, (IStreamListener)parser, this.monitor, null, null);
        return parser.parseDevices();
    }

    public WPEmulator setProcessEnvironmentVariables(String[] envp) {
        this.environment = envp;
        return this;
    }

    public WPEmulator setProgressMonitor(IProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        return this;
    }

    private File getDeployCommand() throws CoreException {
        File deployCmd = this.getAppDeployCmd();
        if (deployCmd == null && (deployCmd = this.getXapDeployCmd()) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.wp.core", Messages.WPEmulator_NoDeployCmdError));
        }
        return deployCmd;
    }

    private IProgressMonitor getProgressMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    private void installLaunch(File deployCmd, File xapFile, int deviceId) throws CoreException {
        StringBuilder cmdLine = new StringBuilder();
        cmdLine.append(this.addQuotes(deployCmd.getAbsolutePath()));
        cmdLine.append(" /installlaunch ");
        cmdLine.append(this.addQuotes(xapFile.getAbsolutePath()));
        cmdLine.append(" /targetdevice:");
        if (deviceId == -1) {
            cmdLine.append("xd");
        } else {
            cmdLine.append(deviceId);
        }
        ExternalProcessUtility processUtility = new ExternalProcessUtility();
        processUtility.execSync(cmdLine.toString(), null, null, null, this.getProgressMonitor(), this.environment, null);
    }

    private File getXapDeployCmd() {
        File xapDeloyCmd = new File(this.sdkLocation, TOOLS + File.separator + XAP_DEPLOYMENT + File.separator + XAP_DEPLOY_CMD_EXE);
        return xapDeloyCmd.exists() ? xapDeloyCmd : null;
    }

    private File getAppDeployCmd() {
        File appDeloyCmd = new File(this.sdkLocation, TOOLS + File.separator + APP_DEPLOY + File.separator + APP_DEPLOY_CMD_EXE);
        return appDeloyCmd.exists() ? appDeloyCmd : null;
    }

    private String addQuotes(String path) {
        return "\"" + path + "\"";
    }

    private static class DeviceListParser
    implements IStreamListener {
        private StringBuffer buffer = new StringBuffer();

        private DeviceListParser() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.buffer.append(text);
        }

        public Map<String, Integer> parseDevices() {
            if (this.buffer == null || this.buffer.length() < 1) {
                return null;
            }
            TreeMap<String, Integer> devices = new TreeMap<String, Integer>();
            try {
                StringReader reader = new StringReader(this.buffer.toString());
                BufferedReader read = new BufferedReader(reader);
                String line = null;
                while ((line = read.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    if (!line.equals("Done.")) {
                        String[] segments = line.split("\t\t");
                        try {
                            int index = Integer.valueOf(segments[0].trim());
                            String name = segments[1].trim();
                            if ("Device".equals(name)) continue;
                            devices.put(name, index);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                WPCore.log(4, "Error during listing Windows Phone 8 devices", e);
            }
            return devices;
        }
    }
}

