/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.lami.ui.Activator;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisReport;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewFactory;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewTabPage;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.Messages;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public final class LamiReportView
extends TmfView {
    public static final String VIEW_ID = "org.eclipse.tracecompass.analysis.lami.views.reportview";
    private final @Nullable LamiAnalysisReport fReport = LamiReportViewFactory.getCurrentReport();
    private final List<LamiReportViewTabPage> fTabPages = new ArrayList<LamiReportViewTabPage>();
    private @Nullable CTabFolder fTabFolder;

    public LamiReportView() {
        super(VIEW_ID);
    }

    public void createPartControl(@Nullable Composite parent) {
        LamiAnalysisReport report = this.fReport;
        if (report == null || parent == null) {
            return;
        }
        this.setPartName(report.getName());
        this.fTabFolder = new CTabFolder(parent, 0);
        this.fTabFolder.setSimple(false);
        for (LamiResultTable table : report.getTables()) {
            String name = table.getTableClass().getTableTitle();
            CTabItem tabItem = new CTabItem(this.fTabFolder, 0);
            tabItem.setText(name);
            SashForm sf = new SashForm((Composite)this.fTabFolder, 0);
            this.fTabPages.add(new LamiReportViewTabPage((Composite)sf, table));
            tabItem.setControl((Control)sf);
        }
        ToggleTableAction toggleTableAction = new ToggleTableAction();
        toggleTableAction.setText(Messages.LamiReportView_ActivateTableAction_ButtonName);
        toggleTableAction.setToolTipText(Messages.LamiReportView_ActivateTableAction_ButtonTooltip);
        toggleTableAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/table.gif"));
        IToolBarManager toolbarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolbarMgr.add((IAction)toggleTableAction);
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        NewChartAction newBarChartAction = new NewChartAction(LamiChartModel.ChartType.BAR_CHART);
        NewChartAction newXYScatterAction = new NewChartAction(LamiChartModel.ChartType.XY_SCATTER);
        newBarChartAction.setText(Messages.LamiReportView_NewCustomBarChart);
        newXYScatterAction.setText(Messages.LamiReportView_NewCustomScatterChart);
        Action clearCustomViewsAction = new Action(){

            public void run() {
                LamiReportViewTabPage tabPage = LamiReportView.this.getCurrentSelectedPage();
                if (tabPage == null) {
                    return;
                }
                tabPage.clearAllCustomViewers();
                tabPage.getControl().layout();
            }
        };
        clearCustomViewsAction.setText(Messages.LamiReportView_ClearAllCustomViews);
        menuMgr.add((IAction)newBarChartAction);
        menuMgr.add((IAction)newXYScatterAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)clearCustomViewsAction);
        CTabFolder tf = (CTabFolder)NonNullUtils.checkNotNull((Object)this.fTabFolder);
        if (tf.getItemCount() > 0) {
            tf.setSelection(0);
        }
    }

    public void setFocus() {
        if (this.fTabFolder != null) {
            this.fTabFolder.setFocus();
        }
    }

    private @Nullable LamiReportViewTabPage getCurrentSelectedPage() {
        CTabFolder tf = this.fTabFolder;
        if (tf == null) {
            return null;
        }
        int idx = tf.getSelectionIndex();
        return this.fTabPages.get(idx);
    }

    private class NewChartAction
    extends Action {
        private final LamiChartModel.ChartType fChartType;

        public NewChartAction(LamiChartModel.ChartType chartType) {
            this.fChartType = chartType;
        }

        public void run() {
            LamiReportViewTabPage page = LamiReportView.this.getCurrentSelectedPage();
            if (page == null) {
                return;
            }
            page.createNewCustomChart(this.fChartType);
        }
    }

    private class ToggleTableAction
    extends Action {
        private ToggleTableAction() {
        }

        public void run() {
            LamiReportViewTabPage page = LamiReportView.this.getCurrentSelectedPage();
            if (page == null) {
                return;
            }
            page.toggleTableViewer();
        }
    }
}

