/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.inputoutput;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputStateProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class InputOutputAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.inputoutput";

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        IKernelAnalysisEventLayout layout = trace instanceof IKernelTrace ? ((IKernelTrace)trace).getKernelEventLayout() : DefaultEventLayout.getInstance();
        return new InputOutputStateProvider(trace, layout);
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        HashSet<IAnalysisModule> modules = new HashSet<IAnalysisModule>();
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException();
        }
        Iterable kernelModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class);
        Iterator iterator = kernelModules.iterator();
        if (iterator.hasNext()) {
            KernelAnalysisModule kernelModule = (KernelAnalysisModule)((Object)iterator.next());
            modules.add((IAnalysisModule)kernelModule);
        }
        return modules;
    }
}

