/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class CpuUsageComposite
extends AbstractTmfTreeViewer {
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private KernelCpuUsageAnalysis fModule = null;
    private String fSelectedThread = null;
    private static final String[] COLUMN_NAMES = new String[]{Messages.CpuUsageComposite_ColumnTID, Messages.CpuUsageComposite_ColumnProcess, Messages.CpuUsageComposite_ColumnPercent, Messages.CpuUsageComposite_ColumnTime};
    private final Map<String, String> fProcessNameMap = new HashMap<String, String>();
    private final @NonNull Set<@NonNull Integer> fCpus = new TreeSet<Integer>();

    public CpuUsageComposite(Composite parent) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new CpuLabelProvider());
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            public List<TmfTreeColumnData> getColumnData() {
                ArrayList<TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>();
                TmfTreeColumnData column = new TmfTreeColumnData(COLUMN_NAMES[0]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        CpuUsageEntry n1 = (CpuUsageEntry)((Object)e1);
                        CpuUsageEntry n2 = (CpuUsageEntry)((Object)e2);
                        return n1.getTid().compareTo(n2.getTid());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[1]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        CpuUsageEntry n1 = (CpuUsageEntry)((Object)e1);
                        CpuUsageEntry n2 = (CpuUsageEntry)((Object)e2);
                        return n1.getProcessName().compareTo(n2.getProcessName());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[2]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        CpuUsageEntry n1 = (CpuUsageEntry)((Object)e1);
                        CpuUsageEntry n2 = (CpuUsageEntry)((Object)e2);
                        return n1.getPercent().compareTo(n2.getPercent());
                    }
                });
                column.setPercentageProvider(new TmfTreeColumnData.ITmfColumnPercentageProvider(){

                    public double getPercentage(Object data) {
                        CpuUsageEntry parent = (CpuUsageEntry)((Object)data);
                        return parent.getPercent() / 100.0;
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[3]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        CpuUsageEntry n1 = (CpuUsageEntry)((Object)e1);
                        CpuUsageEntry n2 = (CpuUsageEntry)((Object)e2);
                        return n1.getTime().compareTo(n2.getTime());
                    }
                });
                columns.add(column);
                return columns;
            }
        };
    }

    protected void contentChanged(ITmfTreeViewerEntry rootEntry) {
        String selectedThread = this.fSelectedThread;
        if (selectedThread != null) {
            for (ITmfTreeViewerEntry entry : rootEntry.getChildren()) {
                if (!(entry instanceof CpuUsageEntry) || !selectedThread.equals(((CpuUsageEntry)entry).getTid())) continue;
                List<ITmfTreeViewerEntry> list = Collections.singletonList(entry);
                super.setSelection(list);
                return;
            }
        }
    }

    public void initializeDataSource() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        this.fModule = (KernelCpuUsageAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        if (this.fModule == null) {
            return;
        }
        this.fModule.schedule();
        this.fModule.waitForInitialization();
        this.fProcessNameMap.clear();
    }

    protected ITmfTreeViewerEntry updateElements(long start, long end, boolean isSelection) {
        if (isSelection || start == end) {
            return null;
        }
        if (this.getTrace() == null || this.fModule == null) {
            return null;
        }
        this.fModule.waitForInitialization();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return null;
        }
        boolean complete = false;
        long currentEnd = Math.max(start, ss.getStartTime());
        while (!complete && currentEnd < end) {
            complete = ss.waitUntilBuilt(500L);
            currentEnd = ss.getCurrentEndTime();
        }
        Map cpuUsageMap = this.fModule.getCpuUsageInRange(this.fCpus, Math.max(start, this.getStartTime()), Math.min(end, this.getEndTime()));
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        List entryList = root.getChildren();
        for (Map.Entry entry : cpuUsageMap.entrySet()) {
            String[] strings;
            if ((Long)entry.getValue() == 0L || !((String)entry.getKey()).startsWith("total") || (strings = ((String)entry.getKey()).split("/", 2)).length <= 1 || strings[1].equals("0")) continue;
            CpuUsageEntry obj = new CpuUsageEntry(strings[1], this.getProcessName(strings[1]), (double)((Long)entry.getValue()).longValue() / (double)(end - start) * 100.0, (Long)entry.getValue());
            entryList.add(obj);
        }
        return root;
    }

    private String getProcessName(String tid) {
        String execName = this.fProcessNameMap.get(tid);
        if (execName != null) {
            return execName;
        }
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return tid;
        }
        ITmfStateSystem kernelSs = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (kernelSs == null) {
            return tid;
        }
        try {
            int cpusNode = kernelSs.getQuarkAbsolute(new String[]{"Threads"});
            List cpuNodes = kernelSs.getSubAttributes(cpusNode, false);
            for (Integer tidQuark : cpuNodes) {
                List execNameIntervals;
                if (!kernelSs.getAttributeName(tidQuark.intValue()).equals(tid)) continue;
                try {
                    int execNameQuark = kernelSs.getQuarkRelative(tidQuark.intValue(), new String[]{"Exec_name"});
                    execNameIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)kernelSs, (int)execNameQuark, (long)this.getStartTime(), (long)this.getEndTime());
                }
                catch (AttributeNotFoundException | TimeRangeException e) {
                    continue;
                }
                catch (StateSystemDisposedException e) {
                    break;
                }
                for (ITmfStateInterval execNameInterval : execNameIntervals) {
                    if (execNameInterval.getStateValue().isNull() || execNameInterval.getStateValue().getType() != ITmfStateValue.Type.STRING) continue;
                    execName = execNameInterval.getStateValue().unboxStr();
                    this.fProcessNameMap.put(tid, execName);
                    return execName;
                }
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return tid;
    }

    public void setSelectedThread(String tid) {
        this.fSelectedThread = tid;
    }

    public void addCpu(int core) {
        this.fCpus.add(core);
        this.updateContent(this.getWindowStartTime(), this.getWindowEndTime(), false);
    }

    public void removeCpu(int core) {
        this.fCpus.remove(core);
        this.updateContent(this.getWindowStartTime(), this.getWindowEndTime(), false);
    }

    public void clearCpu() {
        this.fCpus.clear();
        this.updateContent(this.getWindowStartTime(), this.getWindowEndTime(), false);
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.initSelection();
        this.initCPU();
        super.traceSelected(signal);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.initSelection();
        this.initCPU();
        super.traceOpened(signal);
    }

    private void initSelection() {
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        String thread = (String)ctx.getData("org.eclipse.tracecompass.analysis.os.linux.views.cpuusage.CPU_USAGE_SELECTED_TRHEAD");
        this.setSelectedThread(thread);
    }

    private void initCPU() {
        this.clearCpu();
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        Object data = ctx.getData("org.eclipse.tracecompass.analysis.os.linux.views.cpuusage.FOLLOW_CPU");
        if (data instanceof Set) {
            Set set = (Set)data;
            for (Object coreObject : set) {
                Integer core;
                if (!(coreObject instanceof Integer) || (core = (Integer)coreObject) < 0) continue;
                this.addCpu(core);
            }
        }
    }

    protected static class CpuLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected CpuLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            CpuUsageEntry obj = (CpuUsageEntry)((Object)element);
            if (columnIndex == 0) {
                return obj.getTid();
            }
            if (columnIndex == 1) {
                return obj.getProcessName();
            }
            if (columnIndex == 2) {
                return String.format(Messages.CpuUsageComposite_TextPercent, obj.getPercent());
            }
            if (columnIndex == 3) {
                return NLS.bind((String)Messages.CpuUsageComposite_TextTime, (Object)obj.getTime());
            }
            return element.toString();
        }
    }
}

