/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.store;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;

public class LazyArrayListStore<@NonNull E extends ISegment>
implements ISegmentStore<E> {
    private static final String ERROR_MESSAGE = "Cannot remove from a segment store";
    private final Comparator<E> COMPARATOR = (o1, o2) -> {
        int ret = Long.compare(o1.getStart(), o2.getStart());
        if (ret == 0) {
            return Long.compare(o1.getEnd(), o2.getEnd());
        }
        return ret;
    };
    private final ReentrantLock fLock = new ReentrantLock(false);
    private final @NonNull List<E> fStore = new ArrayList();
    private transient @Nullable Iterable<E> fLastSnapshot = null;
    private volatile boolean fDirty = false;

    public LazyArrayListStore() {
    }

    public LazyArrayListStore(Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] instanceof ISegment) {
                ISegment element = (ISegment)array[i];
                this.setDirtyIfNeeded(element);
                this.fStore.add(element);
            }
            ++i;
        }
        if (this.fDirty) {
            this.sortStore();
        }
    }

    private void setDirtyIfNeeded(@NonNull E value) {
        if (!this.fStore.isEmpty() && this.COMPARATOR.compare((ISegment)this.fStore.get(this.size() - 1), value) > 0) {
            this.fDirty = true;
        }
    }

    public Iterator<E> iterator() {
        this.fLock.lock();
        try {
            ImmutableList lastSnapshot;
            if (this.fDirty) {
                this.sortStore();
            }
            if ((lastSnapshot = this.fLastSnapshot) == null) {
                this.fLastSnapshot = lastSnapshot = ImmutableList.copyOf(this.fStore);
            }
            Iterator iterator = (Iterator)NonNullUtils.checkNotNull(lastSnapshot.iterator());
            return iterator;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void sortStore() {
        this.fStore.sort(this.COMPARATOR);
        this.fDirty = false;
    }

    public boolean add(@Nullable E val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot add null value");
        }
        this.fLock.lock();
        try {
            this.setDirtyIfNeeded(val);
            this.fStore.add(val);
            this.fLastSnapshot = null;
            return true;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public int size() {
        return this.fStore.size();
    }

    public boolean isEmpty() {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.isEmpty();
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public boolean contains(@Nullable Object o) {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.contains(o);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public boolean containsAll(@Nullable Collection<?> c) {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.containsAll(c);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public Object[] toArray() {
        this.fLock.lock();
        try {
            if (this.fDirty) {
                this.sortStore();
            }
            Object[] objectArray = this.fStore.toArray();
            return objectArray;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public <T> T[] toArray(T[] a) {
        this.fLock.lock();
        try {
            if (this.fDirty) {
                this.sortStore();
            }
            T[] TArray = this.fStore.toArray(a);
            return TArray;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public boolean addAll(@Nullable Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.lock();
        try {
            boolean changed = false;
            for (ISegment elem : c) {
                if (!this.add((E)elem)) continue;
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public boolean removeAll(@Nullable Collection<?> c) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public boolean retainAll(@Nullable Collection<?> c) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public boolean remove(@Nullable Object o) {
        throw new UnsupportedOperationException(ERROR_MESSAGE);
    }

    public void clear() {
        this.fLock.lock();
        try {
            this.fStore.clear();
            this.fLastSnapshot = null;
            this.fDirty = false;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public Iterable<E> getIntersectingElements(long position) {
        this.fLock.lock();
        if (this.fDirty) {
            this.sortStore();
        }
        try {
            Iterable iterable = this.fStore.stream().filter(element -> position >= element.getStart() && position <= element.getEnd()).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public Iterable<E> getIntersectingElements(long start, long end) {
        this.fLock.lock();
        if (this.fDirty) {
            this.sortStore();
        }
        try {
            Iterable iterable = this.fStore.stream().filter(element -> start <= element.getEnd() && end >= element.getStart()).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void dispose() {
        this.fLock.lock();
        try {
            this.fStore.clear();
            this.fDirty = false;
        }
        finally {
            this.fLock.unlock();
        }
    }
}

