/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue;

import java.nio.ByteBuffer;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferReader;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferWriter;
import org.eclipse.tracecompass.internal.statesystem.core.statevalue.SafeByteBufferWrapper;

public final class SafeByteBufferFactory {
    private SafeByteBufferFactory() {
    }

    public static ISafeByteBufferReader wrapReader(ByteBuffer buffer, int size) {
        int pos = buffer.position();
        ByteBuffer readOnlyBuffer = buffer.slice().asReadOnlyBuffer();
        readOnlyBuffer.limit(size);
        buffer.position(pos + size);
        return new SafeByteBufferWrapper(readOnlyBuffer);
    }

    public static ISafeByteBufferWriter wrapWriter(ByteBuffer buffer, int size) {
        int pos = buffer.position();
        ByteBuffer readWriteBuffer = buffer.slice();
        readWriteBuffer.limit(size);
        buffer.position(pos + size);
        return new SafeByteBufferWrapper(readWriteBuffer);
    }

    public static int getStringSizeInBuffer(String string) {
        return SafeByteBufferWrapper.getStringSizeInBuffer(string);
    }
}

