/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core;

import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public final class StateSystemBuilderUtils {
    private StateSystemBuilderUtils() {
    }

    public static void incrementAttributeLong(ITmfStateSystemBuilder ssb, long t, int attributeQuark, long increment) throws StateValueTypeException, AttributeNotFoundException {
        ITmfStateValue stateValue = ssb.queryOngoingState(attributeQuark);
        long prevValue = 0L;
        if (!stateValue.isNull()) {
            prevValue = stateValue.unboxLong();
        }
        ssb.modifyAttribute(t, TmfStateValue.newValueLong(prevValue + increment), attributeQuark);
    }

    public static void incrementAttributeInt(ITmfStateSystemBuilder ssb, long t, int attributeQuark, int increment) throws StateValueTypeException, AttributeNotFoundException {
        ITmfStateValue stateValue = ssb.queryOngoingState(attributeQuark);
        int prevValue = 0;
        if (!stateValue.isNull()) {
            prevValue = stateValue.unboxInt();
        }
        ssb.modifyAttribute(t, TmfStateValue.newValueInt(prevValue + increment), attributeQuark);
    }
}

