/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;

public abstract class AbstractXmlViewInfo {
    private final String fViewId;
    private @Nullable String fViewName;

    public AbstractXmlViewInfo(String viewId) {
        this.fViewId = viewId;
        this.fViewName = null;
    }

    public void setName(@NonNull String name) {
        this.fViewName = name;
    }

    protected @Nullable String getName() {
        return this.fViewName;
    }

    protected IDialogSettings getPersistentPropertyStore() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.fViewId);
        if (section == null && (section = settings.addNewSection(this.fViewId)) == null) {
            throw new IllegalStateException("The persistent property section could not be added " + this.fViewId);
        }
        if (this.fViewName == null) {
            return section;
        }
        IDialogSettings subSection = section.getSection(this.fViewName);
        if (subSection == null && (subSection = section.addNewSection(this.fViewName)) == null) {
            throw new IllegalStateException("The persistent property section could not be added: " + this.fViewName);
        }
        return subSection;
    }

    public abstract void setViewData(@NonNull String var1);

    protected abstract void savePersistentData();
}

