/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.AbstractXmlViewInfo;
import org.w3c.dom.Element;

@NonNullByDefault
public class XmlViewInfo
extends AbstractXmlViewInfo {
    private static final String XML_VIEW_ID_PROPERTY = "XmlViewId";
    private static final String XML_VIEW_FILE_PROPERTY = "XmlViewFile";
    private final CountDownLatch fInitialized = new CountDownLatch(1);
    private @Nullable String fId = null;
    private @Nullable String fFilePath = null;
    private boolean fIsDirty = false;

    public XmlViewInfo(String viewId) {
        super(viewId);
    }

    public boolean waitForInitialization() {
        try {
            this.fInitialized.await();
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized void setViewData(String data) {
        String[] idFile = data.split(";;;");
        this.fId = idFile.length > 0 ? idFile[0] : null;
        this.fFilePath = idFile.length > 1 ? idFile[1] : null;
        String viewName = this.getName();
        if (viewName != null) {
            this.savePersistentData();
        } else {
            this.fIsDirty = true;
        }
    }

    @Override
    public synchronized void setName(String name) {
        super.setName(name);
        if (this.fIsDirty) {
            this.savePersistentData();
        } else {
            IDialogSettings settings = this.getPersistentPropertyStore();
            this.fId = settings.get(XML_VIEW_ID_PROPERTY);
            this.fFilePath = settings.get(XML_VIEW_FILE_PROPERTY);
        }
        this.fInitialized.countDown();
    }

    @Override
    protected void savePersistentData() {
        IDialogSettings settings = this.getPersistentPropertyStore();
        settings.put(XML_VIEW_ID_PROPERTY, this.fId);
        settings.put(XML_VIEW_FILE_PROPERTY, this.fFilePath);
    }

    public @Nullable Element getViewElement(String xmlTag) {
        String id = this.fId;
        if (id == null) {
            return null;
        }
        Element viewElement = XmlUtils.getElementInFile((String)this.fFilePath, (String)xmlTag, (String)id);
        return viewElement;
    }

    public @Nullable String getViewTitle(Element viewElement) {
        Element label;
        Element head;
        List labels;
        Iterator iterator;
        List heads = XmlUtils.getChildElements((Element)viewElement, (String)"head");
        String title = null;
        if (!heads.isEmpty() && (iterator = (labels = XmlUtils.getChildElements((Element)(head = (Element)heads.get(0)), (String)"label")).iterator()).hasNext() && !(label = (Element)iterator.next()).getAttribute("value").isEmpty()) {
            title = label.getAttribute("value");
        }
        return title;
    }

    public Set<String> getViewAnalysisIds(Element viewElement) {
        List heads = XmlUtils.getChildElements((Element)viewElement, (String)"head");
        HashSet<String> analysisIds = new HashSet<String>();
        if (!heads.isEmpty()) {
            Element head = (Element)heads.get(0);
            List applicableAnalysis = XmlUtils.getChildElements((Element)head, (String)"analysis");
            for (Element oneAnalysis : applicableAnalysis) {
                analysisIds.add(oneAnalysis.getAttribute("id"));
            }
        }
        return analysisIds;
    }
}

