/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.tracecompass.tmf.core";
    private static Activator fPlugin;

    public Activator() {
        Activator.setDefault(this);
    }

    public static Activator getDefault() {
        return fPlugin;
    }

    private static void setDefault(Activator plugin) {
        fPlugin = plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Activator.setDefault(this);
        TmfCoreTracer.init();
        TmfTraceManager.getInstance();
        TmfAnalysisManager.initialize();
    }

    public void stop(BundleContext context) throws Exception {
        TmfCoreTracer.stop();
        TmfSignalManager.dispose();
        Activator.setDefault(null);
        super.stop(context);
    }

    public static void log(IStatus status) {
        fPlugin.getLog().log(status);
    }

    public static void logInfo(String message) {
        fPlugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void logInfo(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(1, PLUGIN_ID, message, exception));
    }

    public static void logWarning(String message) {
        fPlugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public static void logWarning(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, message, exception));
    }

    public static void logError(String message) {
        fPlugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void logError(String message, Throwable exception) {
        fPlugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, exception));
    }
}

