/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisParameterProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public abstract class TmfAbstractAnalysisParamProvider
implements IAnalysisParameterProvider {
    private IAnalysisModule fModule;

    @Override
    public void registerModule(IAnalysisModule module) {
        if (module == null) {
            throw new IllegalArgumentException();
        }
        ITmfTrace selectedTrace = TmfTraceManager.getInstance().getActiveTrace();
        if (selectedTrace == null) {
            this.fModule = module;
            return;
        }
        IAnalysisModule selectedModule = selectedTrace.getAnalysisModule(module.getId());
        if (selectedModule == module) {
            this.fModule = module;
        }
    }

    protected IAnalysisModule getModule() {
        return this.fModule;
    }

    protected void notifyParameterChanged(String name) {
        IAnalysisModule module = this.fModule;
        if (module != null && name != null) {
            module.notifyParameterChanged(name);
        }
    }
}

