/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import com.google.common.collect.Iterables;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventContent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CustomEvent
extends TmfEvent {
    @Deprecated
    protected static final String TIMESTAMP_INPUT_FORMAT_KEY = "CE_TS_I_F";
    protected static final String NO_MESSAGE = "";
    private @NonNull ITmfTimestamp customEventTimestamp;
    private ITmfEventField customEventContent;
    private ITmfEventType customEventType;
    protected CustomTraceDefinition fDefinition;
    protected Map<Object, String> fData;

    public CustomEvent(CustomTraceDefinition definition) {
        super(null, -1L, null, null, null);
        this.fDefinition = definition;
        this.fData = new HashMap<Object, String>();
        this.customEventTimestamp = TmfTimestamp.ZERO;
    }

    public CustomEvent(CustomTraceDefinition definition, @NonNull TmfEvent other) {
        super(other);
        this.fDefinition = definition;
        this.fData = new HashMap<Object, String>();
        this.customEventTimestamp = other.getTimestamp();
        this.customEventContent = other.getContent();
        this.customEventType = other.getType();
    }

    public CustomEvent(CustomTraceDefinition definition, ITmfTrace parentTrace, ITmfTimestamp timestamp, TmfEventType type) {
        super(parentTrace, -1L, null, null, null);
        this.fDefinition = definition;
        this.fData = new HashMap<Object, String>();
        this.customEventTimestamp = timestamp == null ? TmfTimestamp.ZERO : timestamp;
        this.customEventContent = null;
        this.customEventType = type;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        if (this.fData != null) {
            this.processData();
        }
        return this.customEventTimestamp;
    }

    @Override
    public ITmfEventField getContent() {
        if (this.fData != null) {
            this.processData();
        }
        return this.customEventContent;
    }

    @Override
    public ITmfEventType getType() {
        return this.customEventType;
    }

    @Override
    public String getName() {
        if (this.fData != null) {
            this.processData();
        }
        return super.getName();
    }

    protected void setTimestamp(@NonNull ITmfTimestamp timestamp) {
        this.customEventTimestamp = timestamp;
    }

    protected void setContent(ITmfEventField content) {
        this.customEventContent = content;
    }

    Object getContentValue() {
        return this.customEventContent.getValue();
    }

    protected void setType(ITmfEventType type) {
        this.customEventType = type;
    }

    @Deprecated
    public String getEventString(int index) {
        Collection<? extends ITmfEventField> fields = this.getContent().getFields();
        if (index < 0 || index >= fields.size()) {
            return NO_MESSAGE;
        }
        return NonNullUtils.nullToEmptyString((Object)((ITmfEventField)NonNullUtils.checkNotNull((Object)((ITmfEventField)Iterables.get(fields, (int)index)))).getValue());
    }

    private void processData() {
        String timestampString = this.fData.get((Object)CustomTraceDefinition.Tag.TIMESTAMP);
        String timestampInputFormat = this.fData.get((Object)Key.TIMESTAMP_INPUT_FORMAT);
        ITmfTimestamp timestamp = null;
        if (timestampInputFormat != null && timestampString != null) {
            TmfTimestampFormat timestampFormat = new TmfTimestampFormat(timestampInputFormat);
            try {
                long time = timestampFormat.parseValue(timestampString);
                timestamp = TmfTimestamp.fromNanos(this.getTrace().getTimestampTransform().transform(time));
                this.setTimestamp(timestamp);
            }
            catch (ParseException e) {
                this.setTimestamp(TmfTimestamp.ZERO);
            }
        } else {
            this.setTimestamp(TmfTimestamp.ZERO);
        }
        String eventName = this.fData.get((Object)CustomTraceDefinition.Tag.EVENT_TYPE);
        ITmfEventType type = this.getType();
        if (eventName != null && type instanceof CustomEventType) {
            ((CustomEventType)type).setName(eventName);
        }
        ArrayList<TmfEventField> fields = new ArrayList<TmfEventField>(this.fDefinition.outputs.size());
        for (CustomTraceDefinition.OutputColumn outputColumn : this.fDefinition.outputs) {
            Object key;
            Object object = key = outputColumn.tag.equals((Object)CustomTraceDefinition.Tag.OTHER) ? outputColumn.name : outputColumn.tag;
            if (outputColumn.tag.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP)) {
                if (timestamp == null || this.fDefinition.timeStampOutputFormat == null || this.fDefinition.timeStampOutputFormat.isEmpty()) continue;
                TmfTimestampFormat timestampFormat = new TmfTimestampFormat(this.fDefinition.timeStampOutputFormat);
                fields.add(new TmfEventField(outputColumn.name, timestampFormat.format(timestamp.getValue()), null));
                continue;
            }
            if (outputColumn.tag.equals((Object)CustomTraceDefinition.Tag.EVENT_TYPE)) continue;
            fields.add(new TmfEventField(outputColumn.name, NonNullUtils.nullToEmptyString((Object)this.fData.get(key)), null));
        }
        this.setContent(new CustomEventContent(this.customEventContent.getName(), this.customEventContent.getValue(), fields.toArray(new ITmfEventField[0])));
        this.fData = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fDefinition == null ? 0 : this.fDefinition.hashCode());
        result = 31 * result + this.customEventTimestamp.hashCode();
        result = 31 * result + (this.customEventContent == null ? 0 : this.customEventContent.hashCode());
        result = 31 * result + (this.customEventType == null ? 0 : this.customEventType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CustomEvent)) {
            return false;
        }
        CustomEvent other = (CustomEvent)obj;
        if (!Objects.equals(this.fDefinition, other.fDefinition)) {
            return false;
        }
        if (!this.customEventTimestamp.equals(other.customEventTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.customEventContent, other.customEventContent)) {
            return false;
        }
        return Objects.equals(this.customEventType, other.customEventType);
    }

    protected static enum Key {
        TIMESTAMP_INPUT_FORMAT;

    }
}

