/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statistics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;

public class TmfStateStatistics
implements ITmfStatistics {
    private final ITmfStateSystem totalsStats;
    private final ITmfStateSystem typesStats;

    public TmfStateStatistics(@NonNull ITmfStateSystem totals, @NonNull ITmfStateSystem eventTypes) {
        this.totalsStats = totals;
        this.typesStats = eventTypes;
    }

    public ITmfStateSystem getTotalsSS() {
        return this.totalsStats;
    }

    public ITmfStateSystem getEventTypesSS() {
        return this.typesStats;
    }

    @Override
    public void dispose() {
        this.totalsStats.dispose();
        this.typesStats.dispose();
    }

    @Override
    public List<Long> histogramQuery(long start, long end, int nb) {
        long count;
        long curTotal;
        LinkedList<Long> list = new LinkedList<Long>();
        long increment = (end - start) / (long)nb;
        if (this.totalsStats.isCancelled()) {
            return list;
        }
        long prevTotal = start == this.totalsStats.getStartTime() ? 0L : this.getEventCountAt(start);
        long curTime = start + increment;
        int i = 0;
        while (i < nb - 1) {
            curTotal = this.getEventCountAt(curTime);
            count = curTotal - prevTotal;
            list.add(count);
            curTime += increment;
            prevTotal = curTotal;
            ++i;
        }
        curTotal = this.getEventCountAt(end);
        count = curTotal - prevTotal;
        list.add(count);
        return list;
    }

    @Override
    public long getEventsTotal() {
        long endTime = this.totalsStats.getCurrentEndTime();
        int count = 0;
        try {
            int quark = this.totalsStats.getQuarkAbsolute(new String[]{"total"});
            count = this.totalsStats.querySingleState(endTime, quark).getStateValue().unboxInt();
        }
        catch (StateSystemDisposedException e) {
            return 0L;
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    public Map<@NonNull String, @NonNull Long> getEventTypesTotal() {
        HashMap<@NonNull String, @NonNull Long> map = new HashMap<String, Long>();
        long endTime = this.typesStats.getCurrentEndTime();
        try {
            int quark = this.typesStats.getQuarkAbsolute(new String[]{"event_types"});
            List quarks = this.typesStats.getSubAttributes(quark, false);
            List endState = this.typesStats.queryFullState(endTime);
            Iterator iterator = quarks.iterator();
            while (iterator.hasNext()) {
                int typeQuark = (Integer)iterator.next();
                String curEventName = this.typesStats.getAttributeName(typeQuark);
                long eventCount = ((ITmfStateInterval)endState.get(typeQuark)).getStateValue().unboxInt();
                map.put(curEventName, eventCount);
            }
        }
        catch (StateSystemDisposedException quark) {
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public long getEventsInRange(long start, long end) {
        long startCount = start == this.totalsStats.getStartTime() ? 0L : this.getEventCountAt(start - 1L);
        long endCount = this.getEventCountAt(end);
        return endCount - startCount;
    }

    @Override
    public Map<String, Long> getEventTypesInRange(long start, long end) {
        List quarks;
        HashMap<String, Long> map = new HashMap<String, Long>();
        long startTime = TmfStateStatistics.checkStartTime(start, this.typesStats);
        long endTime = TmfStateStatistics.checkEndTime(end, this.typesStats);
        if (endTime < startTime) {
            return map;
        }
        try {
            int quark = this.typesStats.getQuarkAbsolute(new String[]{"event_types"});
            quarks = this.typesStats.getSubAttributes(quark, false);
        }
        catch (AttributeNotFoundException e) {
            return map;
        }
        try {
            List endState = this.typesStats.queryFullState(endTime);
            if (startTime == this.typesStats.getStartTime()) {
                Iterator iterator = quarks.iterator();
                while (iterator.hasNext()) {
                    int typeQuark = (Integer)iterator.next();
                    String curEventName = this.typesStats.getAttributeName(typeQuark);
                    long eventCount = ((ITmfStateInterval)endState.get(typeQuark)).getStateValue().unboxInt();
                    if (eventCount == -1L) {
                        eventCount = 0L;
                    }
                    map.put(curEventName, eventCount);
                }
            } else {
                List startState = this.typesStats.queryFullState(startTime - 1L);
                Iterator iterator = quarks.iterator();
                while (iterator.hasNext()) {
                    int typeQuark = (Integer)iterator.next();
                    String curEventName = this.typesStats.getAttributeName(typeQuark);
                    long countAtStart = ((ITmfStateInterval)startState.get(typeQuark)).getStateValue().unboxInt();
                    long countAtEnd = ((ITmfStateInterval)endState.get(typeQuark)).getStateValue().unboxInt();
                    if (countAtStart == -1L) {
                        countAtStart = 0L;
                    }
                    if (countAtEnd == -1L) {
                        countAtEnd = 0L;
                    }
                    long eventCount = countAtEnd - countAtStart;
                    map.put(curEventName, eventCount);
                }
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return map;
    }

    private long getEventCountAt(long timestamp) {
        long ts = TmfStateStatistics.checkStartTime(timestamp, this.totalsStats);
        ts = TmfStateStatistics.checkEndTime(ts, this.totalsStats);
        try {
            int quark = this.totalsStats.getQuarkAbsolute(new String[]{"total"});
            long count = this.totalsStats.querySingleState(ts, quark).getStateValue().unboxInt();
            return count;
        }
        catch (StateSystemDisposedException quark) {
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private static long checkStartTime(long initialStart, ITmfStateSystem ss) {
        long start = initialStart;
        if (start < ss.getStartTime()) {
            return ss.getStartTime();
        }
        return start;
    }

    private static long checkEndTime(long initialEnd, ITmfStateSystem ss) {
        long end = initialEnd;
        if (end > ss.getCurrentEndTime()) {
            return ss.getCurrentEndTime();
        }
        return end;
    }

    public static class Attributes {
        public static final String TOTAL = "total";
        public static final String EVENT_TYPES = "event_types";
        public static final String LOST_EVENTS = "lost_events";
    }
}

