/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.operations;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.Messages;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;

public class NewExperimentOperation
implements IRunnableWithProgress {
    private final @NonNull String fExperimentName;
    private final @NonNull TmfExperimentFolder fExperimentFolderRoot;
    private @Nullable IFolder fExperimentFolder = null;
    private @NonNull IStatus fStatus = Status.OK_STATUS;

    public NewExperimentOperation(@NonNull TmfExperimentFolder experimentFolder, @NonNull String experimentName) {
        this.fExperimentFolderRoot = experimentFolder;
        this.fExperimentName = experimentName;
    }

    public void run(IProgressMonitor monitor) {
        IFolder experimentFolder = this.createExperiment(this.fExperimentName);
        try {
            monitor.beginTask("", 1000);
            ModalContext.checkCanceled((IProgressMonitor)monitor);
            experimentFolder.create(false, true, monitor);
            IConfigurationElement ce = TmfTraceType.getTraceAttributes((String)"org.eclipse.linuxtools.tmf.core.experiment.generic");
            if (ce != null) {
                experimentFolder.setPersistentProperty(TmfCommonConstants.TRACETYPE, ce.getAttribute("id"));
            }
            this.fExperimentFolder = experimentFolder;
            this.setStatus(Status.OK_STATUS);
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
        }
        catch (CoreException | InvalidRegistryObjectException e) {
            String msg = NLS.bind((String)Messages.NewExperimentOperation_CreationError, (Object)this.fExperimentName);
            Activator.getDefault().logError(msg, e);
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", msg, e));
        }
    }

    public @Nullable IFolder getExperimentFolder() {
        return this.fExperimentFolder;
    }

    private IFolder createExperiment(String experimentName) {
        IFolder expResource = this.fExperimentFolderRoot.getResource();
        IWorkspaceRoot workspaceRoot = expResource.getWorkspace().getRoot();
        IPath folderPath = expResource.getFullPath().append(experimentName);
        IFolder folder = workspaceRoot.getFolder(folderPath);
        return folder;
    }

    protected void setStatus(@NonNull IStatus status) {
        this.fStatus = status;
    }

    public @NonNull IStatus getStatus() {
        return this.fStatus;
    }
}

