/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.js.util;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.ui.IServerModule;

public final class ChromiumUtil {
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String JSDT_CHROMIUM = ".jsdt-chromium";

    private ChromiumUtil() {
    }

    public static String getChromiumUserDataDir() {
        File chromiumDir = new File(USER_HOME, JSDT_CHROMIUM);
        chromiumDir.mkdir();
        return chromiumDir.getAbsolutePath();
    }

    public static int getRandomOpenPort() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (ServerSocket socket = new ServerSocket(0);){
            return socket.getLocalPort();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String guessUrl() {
        String url = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IStructuredSelection ssel;
            Object firstSelectedElement;
            ISelection selection;
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                IWorkbenchPart part = page.getActivePart();
                IFile activeEditorFile = ChromiumUtil.getEditorFile(part);
                url = ChromiumUtil.toUrl((IResource)activeEditorFile);
            }
            if (url == null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection && (firstSelectedElement = (ssel = (IStructuredSelection)selection).getFirstElement()) != null) {
                url = ChromiumUtil.getUrlFromSelection(firstSelectedElement);
            }
        }
        return url;
    }

    public static String toUrl(IResource resource) {
        IPath location;
        String url = null;
        if (resource != null && (location = resource.getLocation()) != null) {
            url = location.toFile().toURI().toASCIIString();
        }
        return url;
    }

    public static IProject guessProject() {
        IStructuredSelection ssel;
        Object firstSelectedElement;
        IProject project = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && (firstSelectedElement = (ssel = (IStructuredSelection)selection).getFirstElement()) != null) {
            IServerModule serverModule = (IServerModule)ResourceUtil.getAdapter((Object)firstSelectedElement, IServerModule.class, (boolean)false);
            IModule module = serverModule.getModule()[0];
            project = module.getProject();
        }
        return project;
    }

    private static IFile getEditorFile(IWorkbenchPart part) {
        IEditorPart editorPart;
        IFile file = null;
        if (part instanceof IEditorPart && (editorPart = (IEditorPart)part).getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorPart.getEditorInput();
            file = fileEditorInput.getFile();
        }
        return file;
    }

    private static IFile getSelectedFile(Object firstSelectedElement) {
        IFile file = null;
        file = (IFile)Platform.getAdapterManager().getAdapter(firstSelectedElement, IFile.class);
        if (file == null && firstSelectedElement instanceof IAdaptable) {
            file = (IFile)((IAdaptable)firstSelectedElement).getAdapter(IFile.class);
        }
        return file;
    }

    private static String getUrlFromSelection(Object firstSelectedElement) {
        IServerModule serverModule;
        String url = null;
        if (firstSelectedElement instanceof IFile) {
            IFile selectedFile = ChromiumUtil.getSelectedFile(firstSelectedElement);
            url = ChromiumUtil.toUrl((IResource)selectedFile);
        } else if (Platform.getBundle((String)"org.eclipse.wst.server.core") != null && Platform.getBundle((String)"org.eclipse.wst.server.ui") != null && (serverModule = (IServerModule)ResourceUtil.getAdapter((Object)firstSelectedElement, IServerModule.class, (boolean)false)) != null) {
            url = ChromiumUtil.toUrl(serverModule);
        }
        return url;
    }

    private static String toUrl(IServerModule serverModule) {
        String url = null;
        IServer server = serverModule.getServer();
        IModule[] module = serverModule.getModule();
        if (server.getServerState() == 2 && module.length == 1) {
            IModule selectedModule = module[0];
            Object serverAdapter = server.loadAdapter(IURLProvider.class, null);
            if (serverAdapter != null && selectedModule != null) {
                URL moduleRootUrl = ((IURLProvider)serverAdapter).getModuleRootURL(selectedModule);
                url = moduleRootUrl.toString();
            }
        }
        return url;
    }
}

