/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.esprima;

import java.util.Map;
import java.util.Stack;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.esprima.ESTreeNodeTypes;

public class EStreeVisitor {
    private final Stack<WorkElement> workStack = new Stack();

    public void traverse(ScriptObjectMirror root) {
        this.workStack.push(new WorkElement(root, null, false));
        while (!this.workStack.empty()) {
            WorkElement element = this.workStack.pop();
            VisitOptions vo = this.callVisit(element);
            if (vo == VisitOptions.BREAK) {
                return;
            }
            if (!element.endVisit) {
                this.workStack.push(new WorkElement(element.node, element.key, true));
            }
            if (element.endVisit || vo == VisitOptions.SKIP) continue;
            ESTreeNodeTypes nodeType = this.getNodeType(element);
            Assert.isNotNull((Object)((Object)nodeType));
            String[] keys = nodeType.getVisitorKeys();
            int i = keys.length - 1;
            while (i > -1) {
                Object o = element.node.getMember(keys[i]);
                if (o instanceof ScriptObjectMirror) {
                    ScriptObjectMirror candidate = (ScriptObjectMirror)o;
                    if (candidate.isArray()) {
                        Object[] arrayElements = candidate.entrySet().toArray();
                        int j = arrayElements.length - 1;
                        while (j > -1) {
                            Map.Entry entry = (Map.Entry)arrayElements[j];
                            Object result = entry.getValue();
                            if (result instanceof ScriptObjectMirror) {
                                this.workStack.push(new WorkElement((ScriptObjectMirror)result, keys[i], false));
                            }
                            --j;
                        }
                    } else {
                        this.workStack.push(new WorkElement(candidate, keys[i], false));
                    }
                }
                --i;
            }
        }
    }

    private VisitOptions callVisit(WorkElement element) {
        ESTreeNodeTypes nodeType = this.getNodeType(element);
        Assert.isNotNull((Object)((Object)nodeType));
        if (element.endVisit) {
            return this.endVisit(element.node, nodeType, element.key);
        }
        return this.visit(element.node, nodeType, element.key);
    }

    private ESTreeNodeTypes getNodeType(WorkElement element) {
        String type = (String)element.node.get((Object)"type");
        ESTreeNodeTypes nodeType = ESTreeNodeTypes.valueOf(type);
        return nodeType;
    }

    public VisitOptions visit(ScriptObjectMirror object, ESTreeNodeTypes nodeType, String key) {
        return VisitOptions.CONTINUE;
    }

    public VisitOptions endVisit(ScriptObjectMirror object, ESTreeNodeTypes nodeType, String key) {
        return VisitOptions.CONTINUE;
    }

    public static enum VisitOptions {
        CONTINUE,
        SKIP,
        BREAK;

    }

    class WorkElement {
        ScriptObjectMirror node;
        boolean endVisit;
        String key;

        public WorkElement(ScriptObjectMirror node, String key, boolean endVisit) {
            this.node = node;
            this.key = key;
            this.endVisit = endVisit;
        }
    }
}

