/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.core.internal.Logger;
import org.eclipse.wst.json.core.internal.document.ISourceGenerator;
import org.eclipse.wst.json.core.internal.document.JSONDocumentImpl;
import org.eclipse.wst.json.core.internal.document.JSONGeneratorImpl;
import org.eclipse.wst.json.core.internal.document.JSONModelNotifier;
import org.eclipse.wst.json.core.internal.document.JSONModelNotifierImpl;
import org.eclipse.wst.json.core.internal.document.JSONModelParser;
import org.eclipse.wst.json.core.internal.document.JSONModelUpdater;
import org.eclipse.wst.json.core.internal.document.StructuredDocumentRegionManagementException;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.w3c.dom.Document;

public class JSONModelImpl
extends AbstractStructuredModel
implements IStructuredDocumentListener,
IJSONModel {
    private static String TRACE_PARSER_MANAGEMENT_EXCEPTION = "parserManagement";
    private Object active = null;
    private JSONDocumentImpl document = (JSONDocumentImpl)this.internalCreateDocument();
    private ISourceGenerator generator = null;
    private JSONModelNotifier notifier = null;
    private JSONModelParser parser = null;
    private boolean refresh = false;
    private JSONModelUpdater updater = null;

    public void aboutToChangeModel() {
        super.aboutToChangeModel();
        this.getModelNotifier().beginChanging();
    }

    public void aboutToReinitializeModel() {
        JSONModelNotifier notifier = this.getModelNotifier();
        notifier.cancelPending();
        super.aboutToReinitializeModel();
    }

    protected void pairReplaced(IJSONObject element, IJSONPair newAttr, IJSONPair oldAttr) {
        if (element == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            JSONModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.replaceAttr(element, newAttr, oldAttr);
            this.setActive(null);
        }
        this.getModelNotifier().pairReplaced(element, newAttr, oldAttr);
    }

    public void changedModel() {
        if (this.isModelChangeStateOnVergeOfEnding()) {
            this.endLock();
            this.fLockObject = null;
            this.getModelNotifier().endChanging();
        }
        super.changedModel();
        this.handleRefresh();
    }

    protected void childReplaced(IJSONNode parentNode, IJSONNode newChild, IJSONNode oldChild) {
        if (parentNode == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            JSONModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.replaceChild(parentNode, newChild, oldChild);
            this.setActive(null);
        }
        this.getModelNotifier().childReplaced(parentNode, newChild, oldChild);
    }

    private JSONModelParser getActiveParser() {
        if (this.parser == null) {
            return null;
        }
        if (this.parser != this.active) {
            return null;
        }
        return this.parser;
    }

    private JSONModelUpdater getActiveUpdater() {
        if (this.updater == null) {
            return null;
        }
        if (this.updater != this.active) {
            return null;
        }
        return this.updater;
    }

    public Object getAdapter(Class adapter) {
        if (Document.class.equals((Object)adapter)) {
            return this.getDocument();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IJSONDocument getDocument() {
        return this.document;
    }

    public ISourceGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = JSONGeneratorImpl.getInstance();
        }
        return this.generator;
    }

    public IndexedRegion getIndexedRegion(int offset) {
        if (this.document == null) {
            return null;
        }
        IJSONNode parent = null;
        int length = this.document.getEndOffset();
        if (offset * 2 < length) {
            IJSONNode child = this.document.getFirstChild();
            while (child != null) {
                if (child.getEndOffset() <= offset) {
                    child = child.getNextSibling();
                    continue;
                }
                if (child.getStartOffset() <= offset) {
                    IStructuredDocumentRegion startStructuredDocumentRegion = child.getStartStructuredDocumentRegion();
                    if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.getEnd() > offset) {
                        return child;
                    }
                    IStructuredDocumentRegion endStructuredDocumentRegion = child.getEndStructuredDocumentRegion();
                    if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.getStart() <= offset) {
                        IJSONValue value;
                        if (child instanceof IJSONPair && ((value = ((IJSONPair)child).getValue()) instanceof IJSONObject || value instanceof IJSONArray) && value.getStartOffset() < offset) {
                            child = value;
                            continue;
                        }
                        return child;
                    }
                    parent = child;
                    if (parent != null && parent.getNodeType() == 2) {
                        IJSONPair pair = (IJSONPair)parent;
                        child = pair.getValue();
                        continue;
                    }
                    child = parent.getFirstChild();
                    continue;
                }
                break;
            }
        } else {
            IJSONNode child = this.document.getLastChild();
            while (child != null) {
                if (child.getStartOffset() > offset) {
                    child = child.getPreviousSibling();
                    continue;
                }
                if (child.getEndOffset() > offset) {
                    IStructuredDocumentRegion startStructuredDocumentRegion = child.getStartStructuredDocumentRegion();
                    if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.getEnd() > offset) {
                        return child;
                    }
                    IStructuredDocumentRegion endStructuredDocumentRegion = child.getEndStructuredDocumentRegion();
                    if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.getStart() <= offset) {
                        IJSONValue value;
                        if (child instanceof IJSONPair && ((value = ((IJSONPair)child).getValue()) instanceof IJSONObject || value instanceof IJSONArray) && value.getStartOffset() < offset) {
                            child = value;
                            continue;
                        }
                        return child;
                    }
                    parent = child;
                    if (parent != null && parent.getNodeType() == 2) {
                        IJSONPair pair = (IJSONPair)parent;
                        child = pair.getValue();
                        continue;
                    }
                    child = parent.getLastChild();
                    continue;
                }
                break;
            }
        }
        return parent != null ? parent : this.document.getFirstChild();
    }

    public JSONModelNotifier getModelNotifier() {
        if (this.notifier == null) {
            this.notifier = new JSONModelNotifierImpl();
        }
        return this.notifier;
    }

    private JSONModelParser getModelParser() {
        if (this.parser == null) {
            this.parser = this.createModelParser();
        }
        return this.parser;
    }

    protected JSONModelParser createModelParser() {
        return new JSONModelParser(this);
    }

    private JSONModelUpdater getModelUpdater() {
        if (this.updater == null) {
            this.updater = this.createModelUpdater();
        }
        return this.updater;
    }

    protected JSONModelUpdater createModelUpdater() {
        return new JSONModelUpdater(this);
    }

    private void handleRefresh() {
        if (!this.refresh) {
            return;
        }
        JSONModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging(true);
        }
        JSONModelParser parser = this.getModelParser();
        this.setActive(parser);
        this.document.removeChildNodes();
        try {
            try {
                this.refresh = false;
                parser.replaceStructuredDocumentRegions(this.getStructuredDocument().getRegionList(), null);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                }
            }
        }
        finally {
            this.setActive(null);
            if (!isChanging) {
                notifier.endChanging();
            }
        }
    }

    protected IJSONDocument internalCreateDocument() {
        JSONDocumentImpl document = new JSONDocumentImpl();
        document.setModel(this);
        return document;
    }

    boolean isReparsing() {
        return this.active != null;
    }

    public void newModel(NewDocumentEvent structuredDocumentEvent) {
        if (structuredDocumentEvent == null) {
            return;
        }
        IStructuredDocument structuredDocument = structuredDocumentEvent.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (this.fStructuredDocument != null && this.fStructuredDocument != structuredDocument) {
            this.setStructuredDocument(structuredDocument);
        }
        this.internalSetNewDocument(structuredDocument);
    }

    private void internalSetNewDocument(IStructuredDocument structuredDocument) {
        if (structuredDocument == null) {
            return;
        }
        IStructuredDocumentRegionList flatNodes = structuredDocument.getRegionList();
        if (flatNodes == null || flatNodes.getLength() == 0) {
            return;
        }
        if (this.document == null) {
            return;
        }
        JSONModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceStructuredDocumentRegions(flatNodes, null);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                }
            }
            finally {
                this.setActive(null);
            }
            return;
        }
        JSONModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        this.getModelNotifier().beginChanging(true);
        JSONModelParser parser = this.getModelParser();
        this.setActive(parser);
        this.document.removeChildNodes();
        try {
            try {
                parser.replaceStructuredDocumentRegions(flatNodes, null);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.setActive(null);
                if (!isChanging) {
                    this.getModelNotifier().endChanging();
                }
                this.refresh = false;
            }
        }
        finally {
            this.setActive(null);
            if (!isChanging) {
                this.getModelNotifier().endChanging();
            }
            this.refresh = false;
        }
    }

    public void noChange(NoChangeEvent event) {
        JSONModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceStructuredDocumentRegions(null, null);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                }
            }
            finally {
                this.setActive(null);
            }
            return;
        }
    }

    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent event) {
        block25: {
            if (event == null) {
                return;
            }
            IStructuredDocumentRegionList oldStructuredDocumentRegions = event.getOldStructuredDocumentRegions();
            IStructuredDocumentRegionList newStructuredDocumentRegions = event.getNewStructuredDocumentRegions();
            JSONModelUpdater updater = this.getActiveUpdater();
            if (updater != null) {
                try {
                    try {
                        updater.replaceStructuredDocumentRegions(newStructuredDocumentRegions, oldStructuredDocumentRegions);
                    }
                    catch (Exception ex) {
                        Logger.logException(ex);
                        this.refresh = true;
                        this.handleRefresh();
                        this.setActive(null);
                    }
                }
                finally {
                    this.setActive(null);
                }
                return;
            }
            JSONModelNotifier notifier = this.getModelNotifier();
            boolean isChanging = notifier.isChanging();
            if (!isChanging) {
                notifier.beginChanging();
            }
            JSONModelParser parser = this.getModelParser();
            this.setActive(parser);
            try {
                try {
                    boolean reloadModel = false;
                    if (newStructuredDocumentRegions != null) {
                        int newCount = newStructuredDocumentRegions.getLength();
                        int i = 0;
                        while (i < newCount - 1) {
                            if (newStructuredDocumentRegions.item(i).getType().equals("JSON_COMMA")) {
                                IStructuredDocumentRegion nextNode = newStructuredDocumentRegions.item(i).getNext();
                                while (nextNode != null) {
                                    if (nextNode.getType().equals("JSON_OBJECT_KEY") || nextNode.getType().equals("JSON_OBJECT_OPEN") || nextNode.getType().equals("JSON_ARRAY_OPEN")) {
                                        reloadModel = true;
                                        break;
                                    }
                                    nextNode = nextNode.getNext();
                                }
                            }
                            ++i;
                        }
                    }
                    if (!reloadModel && oldStructuredDocumentRegions != null && oldStructuredDocumentRegions.getLength() > 0 && (oldStructuredDocumentRegions.item(0).getType().equals("JSON_OBJECT_OPEN") || oldStructuredDocumentRegions.getLength() > 3)) {
                        reloadModel = true;
                    }
                    if (reloadModel) {
                        this.refresh = true;
                        this.handleRefresh();
                        break block25;
                    }
                    parser.replaceStructuredDocumentRegions(newStructuredDocumentRegions, oldStructuredDocumentRegions);
                }
                catch (Exception ex) {
                    if (ex.getClass().equals(StructuredDocumentRegionManagementException.class)) {
                        Logger.traceException(TRACE_PARSER_MANAGEMENT_EXCEPTION, ex);
                    } else {
                        Logger.logException(ex);
                    }
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                    if (!isChanging) {
                        notifier.endChanging();
                        this.handleRefresh();
                    }
                }
            }
            finally {
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                    this.handleRefresh();
                }
            }
        }
    }

    public void regionChanged(RegionChangedEvent event) {
        if (event == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        ITextRegion region = event.getRegion();
        if (region == null) {
            return;
        }
        JSONModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.changeRegion(event, flatNode, region);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                }
            }
            finally {
                this.setActive(null);
            }
            return;
        }
        JSONModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging();
        }
        JSONModelParser parser = this.getModelParser();
        this.setActive(parser);
        try {
            try {
                parser.changeRegion(event, flatNode, region);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.refresh = true;
                this.handleRefresh();
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                    this.handleRefresh();
                }
            }
        }
        finally {
            this.setActive(null);
            if (!isChanging) {
                notifier.endChanging();
                this.handleRefresh();
            }
        }
    }

    public void regionsReplaced(RegionsReplacedEvent event) {
        block22: {
            if (event == null) {
                return;
            }
            IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
            if (flatNode == null) {
                return;
            }
            ITextRegionList oldRegions = event.getOldRegions();
            ITextRegionList newRegions = event.getNewRegions();
            if (oldRegions == null && newRegions == null) {
                return;
            }
            JSONModelUpdater updater = this.getActiveUpdater();
            if (updater != null) {
                try {
                    try {
                        updater.replaceRegions(flatNode, newRegions, oldRegions);
                    }
                    catch (Exception ex) {
                        Logger.logException(ex);
                        this.refresh = true;
                        this.handleRefresh();
                        this.setActive(null);
                    }
                }
                finally {
                    this.setActive(null);
                }
                return;
            }
            JSONModelNotifier notifier = this.getModelNotifier();
            boolean isChanging = notifier.isChanging();
            if (!isChanging) {
                notifier.beginChanging();
            }
            JSONModelParser parser = this.getModelParser();
            this.setActive(parser);
            try {
                try {
                    boolean reloadModel = false;
                    if (flatNode.getType().equals("JSON_COMMA")) {
                        IStructuredDocumentRegion nextNode = flatNode.getNext();
                        while (nextNode != null) {
                            if (nextNode.getType().equals("JSON_OBJECT_KEY") || nextNode.getType().equals("JSON_OBJECT_OPEN") || nextNode.getType().equals("JSON_ARRAY_OPEN")) {
                                reloadModel = true;
                            }
                            nextNode = nextNode.getNext();
                        }
                    }
                    if (reloadModel) {
                        this.refresh = true;
                        this.handleRefresh();
                        break block22;
                    }
                    parser.replaceRegions(flatNode, newRegions, oldRegions);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                    this.setActive(null);
                    if (!isChanging) {
                        notifier.endChanging();
                        this.handleRefresh();
                    }
                }
            }
            finally {
                this.setActive(null);
                if (!isChanging) {
                    notifier.endChanging();
                    this.handleRefresh();
                }
            }
        }
    }

    public void releaseFromEdit() {
        this.isShared();
        super.releaseFromEdit();
    }

    public void releaseFromRead() {
        this.isShared();
        super.releaseFromRead();
    }

    private void setActive(Object active) {
        this.active = active;
    }

    public void setModelNotifier(JSONModelNotifier notifier) {
        this.notifier = notifier;
    }

    public void setModelParser(JSONModelParser parser) {
        this.parser = parser;
    }

    public void setModelUpdater(JSONModelUpdater updater) {
        this.updater = updater;
    }

    public void setStructuredDocument(IStructuredDocument structuredDocument) {
        IStructuredDocument oldStructuredDocument = super.getStructuredDocument();
        if (structuredDocument == oldStructuredDocument) {
            return;
        }
        if (oldStructuredDocument != null) {
            oldStructuredDocument.removeDocumentChangingListener((IStructuredDocumentListener)this);
        }
        super.setStructuredDocument(structuredDocument);
        if (structuredDocument != null) {
            this.internalSetNewDocument(structuredDocument);
            structuredDocument.addDocumentChangingListener((IStructuredDocumentListener)this);
        }
    }

    protected void startTagChanged(IJSONObject element) {
        if (element == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            JSONModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeStartTag(element);
            this.setActive(null);
        }
        this.getModelNotifier().startTagChanged(element);
    }

    protected void valueChanged(IJSONNode node) {
        if (node == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            JSONModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeValue(node);
            this.setActive(null);
        }
        this.getModelNotifier().valueChanged(node);
    }
}

