/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import java.util.Iterator;
import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.core.internal.document.JSONArrayImpl;
import org.eclipse.wst.json.core.internal.document.JSONBooleanValueImpl;
import org.eclipse.wst.json.core.internal.document.JSONModelContext;
import org.eclipse.wst.json.core.internal.document.JSONModelImpl;
import org.eclipse.wst.json.core.internal.document.JSONNodeImpl;
import org.eclipse.wst.json.core.internal.document.JSONNullValueImpl;
import org.eclipse.wst.json.core.internal.document.JSONNumberValueImpl;
import org.eclipse.wst.json.core.internal.document.JSONObjectImpl;
import org.eclipse.wst.json.core.internal.document.JSONPairImpl;
import org.eclipse.wst.json.core.internal.document.JSONStringValueImpl;
import org.eclipse.wst.json.core.internal.document.JSONStructureImpl;
import org.eclipse.wst.json.core.internal.document.JSONValueImpl;
import org.eclipse.wst.json.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class JSONModelParser {
    private JSONModelContext context = null;
    private JSONModelImpl model = null;

    protected JSONModelParser(JSONModelImpl model) {
        if (model != null) {
            this.model = model;
        }
    }

    private void changeAttrName(IStructuredDocumentRegion flatNode, ITextRegion region) {
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        JSONNodeImpl root = (JSONNodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        IJSONNode node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 2) {
            return;
        }
        JSONPairImpl pair = (JSONPairImpl)node;
        String name = flatNode.getText(region);
        pair.setName(name);
        JSONObjectImpl parentObj = (JSONObjectImpl)node.getParentNode();
        if (parentObj != null && parentObj.getParentOrPairNode() instanceof JSONPairImpl) {
            JSONPairImpl parentPair = (JSONPairImpl)parentObj.getParentOrPairNode();
            parentPair.setValue(parentObj);
        }
    }

    private void changeAttrValue(IStructuredDocumentRegion flatNode, ITextRegion region) {
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        JSONNodeImpl root = (JSONNodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        IJSONNode node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        JSONValueImpl value = (JSONValueImpl)this.createJSONValue(region.getType());
        value.setStructuredDocumentRegion(flatNode);
        if (node.getNodeType() == 2) {
            JSONPairImpl pair = (JSONPairImpl)node;
            pair.updateValue(value);
        } else if (this.isJSONValue(node.getFirstStructuredDocumentRegion().getType())) {
            JSONValueImpl oldValue = (JSONValueImpl)node;
            oldValue.updateValue(value);
        } else if (node instanceof JSONArrayImpl && (value.getValueRegionType().equals("JSON_VALUE_BOOLEAN") || value.getValueRegionType().equals("JSON_VALUE_NULL"))) {
            JSONArrayImpl array = (JSONArrayImpl)node;
            node.insertBefore(value, null);
            array.add(value);
            JSONPairImpl ownerPair = (JSONPairImpl)array.getParentOrPairNode();
            if (ownerPair.getValue() == null) {
                ownerPair.setValue(array);
            } else {
                ownerPair.updateValue(array);
            }
        }
    }

    void changeRegion(RegionChangedEvent change, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (flatNode == null || region == null) {
            return;
        }
        if (this.model.getDocument() == null) {
            return;
        }
        this.context = new JSONModelContext(this.model.getDocument());
        boolean isWhitespaceChange = false;
        if (change.getText() != null && change.getText().length() > 0) {
            isWhitespaceChange = Character.isWhitespace(change.getText().charAt(0));
        } else if (change.getDeletedText() != null && change.getDeletedText().length() > 0) {
            isWhitespaceChange = Character.isWhitespace(change.getDeletedText().charAt(0));
        }
        if (isWhitespaceChange) {
            return;
        }
        String regionType = region.getType();
        if (regionType == "JSON_OBJECT_KEY") {
            this.changeAttrName(flatNode, region);
        } else if (this.isJSONValue(regionType)) {
            this.changeAttrValue(flatNode, region);
        } else {
            if (regionType == "JSON_UNKNOWN") {
                return;
            }
            this.changeStructuredDocumentRegion(flatNode);
        }
    }

    private void changeStartObject(IStructuredDocumentRegion flatNode, ITextRegionList newRegions, ITextRegionList oldRegions) {
        Iterator e;
        int offset = flatNode.getStart();
        if (offset < 0) {
            return;
        }
        JSONNodeImpl root = (JSONNodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        IJSONNode node = root.getNodeAt(offset);
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 0) {
            this.changeStructuredDocumentRegion(flatNode);
            return;
        }
        JSONObjectImpl cfr_ignored_0 = (JSONObjectImpl)node;
        if (newRegions != null && (e = newRegions.iterator()).hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            region.getType();
            this.changeStructuredDocumentRegion(flatNode);
            return;
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
    }

    private void changeStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return;
        }
        if (this.model.getDocument() == null) {
            return;
        }
        this.setupContext(flatNode);
        this.removeStructuredDocumentRegion(flatNode);
        this.context.setLast();
        this.insertStructuredDocumentRegion(flatNode);
        this.cleanupEndTag();
    }

    /*
     * Unable to fully structure code
     */
    private void cleanupEndTag() {
        parent = this.context.getParentNode();
        next = this.context.getNextNode();
        ** GOTO lbl22
        {
            if (next.getNodeType() == 0) {
                (JSONObjectImpl)next;
            }
            if ((first = next.getFirstChild()) != null) {
                parent = next;
                next = first;
                this.context.setCurrentNode(next);
            } else {
                next = next.getNextSibling();
                this.context.setCurrentNode(next);
            }
            do {
                if (next != null) continue block0;
                next = parent.getNextSibling();
                parent = parent.getParentNode();
                if (next != null) {
                    this.context.setCurrentNode(next);
                    continue;
                }
                this.context.setParentNode(parent);
lbl22:
                // 3 sources

            } while (parent != null);
        }
    }

    private void demoteNodes(IJSONNode root, IJSONNode newParent, IJSONNode oldParent, IJSONNode next) {
        if (newParent.getNodeType() != 0) {
            return;
        }
        JSONObjectImpl newElement = (JSONObjectImpl)newParent;
        while (next == null) {
            if (oldParent.getNodeType() != 0) {
                return;
            }
            JSONObjectImpl oldElement = (JSONObjectImpl)oldParent;
            if (oldElement.hasEndTag()) {
                return;
            }
            oldParent = oldElement.getParentNode();
            if (oldParent == null) {
                return;
            }
            next = oldElement.getNextSibling();
        }
        block1: while (next != null) {
            JSONObjectImpl nextElement;
            boolean done = false;
            if (next.getNodeType() == 0 && !(nextElement = (JSONObjectImpl)next).hasStartTag()) {
                IJSONNode nextChild = nextElement.getFirstChild();
                if (nextChild != null) {
                    next = nextChild;
                    oldParent = nextElement;
                    continue;
                }
                next = nextElement.getNextSibling();
                oldParent.removeChild(nextElement);
                done = true;
            }
            if (!done) {
                IJSONNode child = next;
                next = next.getNextSibling();
                oldParent.removeChild(child);
                this.insertNode(newElement, child, null);
                IJSONNode childParent = child.getParentNode();
                if (childParent != newElement) {
                    newElement = (JSONObjectImpl)childParent;
                }
            }
            while (next == null) {
                if (oldParent.getNodeType() != 0) {
                    return;
                }
                JSONObjectImpl oldElement = (JSONObjectImpl)oldParent;
                if (!oldElement.hasChildNodes() && !oldElement.hasStartTag()) {
                    oldParent = oldElement.getParentNode();
                    if (oldParent == null) {
                        return;
                    }
                    next = oldElement;
                    continue block1;
                }
                if (oldElement.hasEndTag()) {
                    return;
                }
                oldParent = oldElement.getParentNode();
                if (oldParent == null) {
                    return;
                }
                next = oldElement.getNextSibling();
            }
        }
    }

    protected final IJSONModel getModel() {
        return this.model;
    }

    private void updateEndObject(IStructuredDocumentRegion flatNode) {
        JSONObjectImpl start = (JSONObjectImpl)this.context.findParentObject();
        if (start != null) {
            start.setEndStructuredDocumentRegion(flatNode);
            this.context.setParentNode(start.getParentNode());
        }
    }

    private void insertNode(IJSONNode node) {
        if (node == null || this.context == null) {
            return;
        }
        IJSONNode parent = this.context.getParentNode();
        if (parent == null) {
            return;
        }
        if (parent.getNodeType() == 2) {
            IJSONPair pair = (IJSONPair)parent;
            ((JSONPairImpl)pair).setValue((IJSONValue)node);
            return;
        }
        if (parent.getLastChild() != null && parent.getLastChild().getNodeType() == 2) {
            IJSONPair pair = (IJSONPair)parent.getLastChild();
            ((JSONPairImpl)pair).setValue((IJSONValue)node);
            return;
        }
        IJSONNode next = this.context.getNextNode();
        this.insertNode(parent, node, next);
        next = node.getNextSibling();
        if (next != null) {
            this.context.setCurrentNode(next);
        } else {
            this.context.setParentNode(node.getParentNode());
        }
    }

    private void insertNode(IJSONNode parent, IJSONNode node, IJSONNode next) {
        while (next != null && next.getNodeType() == 0) {
            JSONObjectImpl nextElement = (JSONObjectImpl)next;
            if (nextElement.hasStartTag()) break;
            parent = nextElement;
            next = nextElement.getFirstChild();
        }
        parent.insertBefore(node, next);
    }

    private void insertObject(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        JSONObjectImpl element = null;
        element = this.context.getCurrentNode() != null && this.context.getCurrentNode() instanceof IJSONObject ? (JSONObjectImpl)this.context.getCurrentNode() : (JSONObjectImpl)this.model.getDocument().createJSONObject();
        if (element == null) {
            return;
        }
        element.setStartStructuredDocumentRegion(flatNode);
        this.insertStartObjectOLD(element);
    }

    protected void insertStartObjectOLD(IJSONObject element) {
        if (element == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        this.insertNode(element);
        JSONObjectImpl newElement = (JSONObjectImpl)element;
        if (newElement.isEmptyTag() || !newElement.isContainer()) {
            return;
        }
        newElement.getStartStructuredDocumentRegion().getLastRegion().getType();
        IJSONNode parent = this.context.getParentNode();
        if (parent == null) {
            return;
        }
        IJSONNode next = this.context.getNextNode();
        this.demoteNodes(element, element, parent, next);
        IJSONNode firstChild = element.getFirstChild();
        if (firstChild != null) {
            this.context.setCurrentNode(firstChild);
        } else {
            this.context.setParentNode(element);
        }
    }

    protected void insertStartArray(IJSONArray element) {
        if (element == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        this.insertNode(element);
        JSONArrayImpl newElement = (JSONArrayImpl)element;
        newElement.getStartStructuredDocumentRegion().getLastRegion().getType();
        IJSONNode parent = this.context.getParentNode();
        if (parent == null) {
            return;
        }
        IJSONNode next = this.context.getNextNode();
        this.demoteNodes(element, element, parent, next);
        IJSONNode firstChild = element.getFirstChild();
        if (firstChild != null) {
            this.context.setCurrentNode(firstChild);
        } else {
            this.context.setParentNode(element);
        }
    }

    private void insertArray(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        JSONArrayImpl element = (JSONArrayImpl)this.model.getDocument().createJSONArray();
        element.setStartStructuredDocumentRegion(flatNode);
        this.insertStartArray(element);
    }

    private void updateEndArray(IStructuredDocumentRegion flatNode) {
        JSONArrayImpl start = (JSONArrayImpl)this.context.findParentArray();
        if (start != null) {
            start.setEndStructuredDocumentRegion(flatNode);
            this.context.setParentNode(start.getParentNode());
        }
    }

    protected void insertStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        String regionType = StructuredDocumentRegionUtil.getFirstRegionType(flatNode);
        if (regionType == "JSON_OBJECT_OPEN") {
            this.insertObject(flatNode);
        } else if (regionType == "JSON_OBJECT_CLOSE") {
            this.updateEndObject(flatNode);
        } else if (regionType == "JSON_ARRAY_OPEN") {
            this.insertArray(flatNode);
        } else if (regionType == "JSON_ARRAY_CLOSE") {
            this.updateEndArray(flatNode);
        } else if (regionType == "JSON_OBJECT_KEY") {
            this.insertObjectKey(flatNode);
        } else if (regionType == "JSON_VALUE_BOOLEAN") {
            this.insertValue(flatNode, regionType);
        } else if (regionType == "JSON_VALUE_NULL") {
            this.insertValue(flatNode, regionType);
        } else if (regionType == "JSON_VALUE_NUMBER") {
            this.insertValue(flatNode, regionType);
        } else if (regionType == "JSON_VALUE_STRING") {
            this.insertValue(flatNode, regionType);
        }
    }

    private void insertValue(IStructuredDocumentRegion flatNode, String regionType) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        StructuredDocumentRegionUtil.getFirstRegion(flatNode);
        JSONValueImpl value = (JSONValueImpl)this.createJSONValue(regionType);
        value.setStructuredDocumentRegion(flatNode);
        if (this.context.getCurrentNode() != null && this.context.getCurrentNode() instanceof JSONPairImpl) {
            JSONPairImpl pair = (JSONPairImpl)this.context.getCurrentNode();
            pair.setValue(value);
            JSONNodeImpl parent = (JSONNodeImpl)this.context.getParentNode();
            parent.insertBefore(pair, this.context.getNextNode());
            if (parent instanceof IJSONObject) {
                JSONObjectImpl parentObject = (JSONObjectImpl)parent;
                parentObject.add(pair);
            }
        } else {
            JSONStructureImpl structure = (JSONStructureImpl)this.context.findParentStructure();
            if (structure != null) {
                if (structure.getNodeType() == 0) {
                    if (structure.getLastChild() != null && structure.getLastChild().getNodeType() == 2) {
                        ((JSONPairImpl)structure.getLastChild()).setValue(value);
                    }
                    if (structure.getParentOrPairNode() instanceof JSONPairImpl) {
                        JSONPairImpl parentPair = (JSONPairImpl)structure.getParentOrPairNode();
                        parentPair.setValue(structure);
                    }
                } else if (structure.getNodeType() == 1) {
                    JSONArrayImpl array = (JSONArrayImpl)structure;
                    structure.insertBefore(value, null);
                    array.add(value);
                    JSONPairImpl ownerPair = (JSONPairImpl)array.getParentOrPairNode();
                    if (ownerPair.getValue() == null) {
                        ownerPair.setValue(array);
                    } else {
                        ownerPair.updateValue(array);
                    }
                } else {
                    this.insertNode(structure, value, null);
                }
            }
        }
    }

    private IJSONValue createJSONValue(String regionType) {
        if (regionType == "JSON_VALUE_BOOLEAN") {
            return this.model.getDocument().createBooleanValue();
        }
        if (regionType == "JSON_VALUE_NULL") {
            return this.model.getDocument().createNullValue();
        }
        if (regionType == "JSON_VALUE_NUMBER") {
            return this.model.getDocument().createNumberValue();
        }
        if (regionType == "JSON_VALUE_STRING") {
            return this.model.getDocument().createStringValue();
        }
        return null;
    }

    private void insertNumberValue(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        StructuredDocumentRegionUtil.getFirstRegion(flatNode);
        JSONStructureImpl array = (JSONStructureImpl)this.context.findParentStructure();
        if (array != null) {
            JSONNumberValueImpl value = (JSONNumberValueImpl)this.model.getDocument().createNumberValue();
            this.insertNode(array, value, null);
        }
    }

    private void insertNullValue(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        StructuredDocumentRegionUtil.getFirstRegion(flatNode);
        JSONStructureImpl array = (JSONStructureImpl)this.context.findParentStructure();
        if (array != null) {
            JSONNullValueImpl value = (JSONNullValueImpl)this.model.getDocument().createNullValue();
            this.insertNode(array, value, null);
        }
    }

    private void insertStringValue(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        StructuredDocumentRegionUtil.getFirstRegion(flatNode);
        JSONStructureImpl array = (JSONStructureImpl)this.context.findParentStructure();
        if (array != null) {
            JSONStringValueImpl value = (JSONStringValueImpl)this.model.getDocument().createStringValue();
            this.insertNode(array, value, null);
        }
    }

    private void insertObjectKey(IStructuredDocumentRegion flatNode) {
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return;
        }
        JSONObjectImpl object = (JSONObjectImpl)this.context.findParentObject();
        if (object == null) {
            return;
        }
        JSONPairImpl pair = null;
        for (ITextRegion region : regions) {
            JSONStructureImpl value;
            if (region == null) continue;
            if (region.getType() == "JSON_OBJECT_KEY") {
                String name = flatNode.getText(region);
                pair = (JSONPairImpl)this.model.getDocument().createJSONPair(name);
                pair.setStartStructuredDocumentRegion(flatNode);
                pair.setNameRegion(region);
                if (this.context.getCurrentNode() != null && this.context.getCurrentNode().getStartOffset() > pair.getStartOffset()) {
                    this.insertNode(object, pair, this.context.getCurrentNode());
                } else {
                    this.insertNode(object, pair, this.context.getNextNode());
                }
                object.add(pair);
                if (this.context.getCurrentNode() != null && this.context.getCurrentNode().getStartOffset() == pair.getStartOffset()) {
                    this.context.setCurrentNode(pair);
                }
                if (!(object.getParentOrPairNode() instanceof JSONPairImpl)) continue;
                JSONPairImpl parentPair = (JSONPairImpl)object.getParentOrPairNode();
                parentPair.setValue(object);
                continue;
            }
            if (region.getType() == "JSON_COLON") {
                pair.setEqualRegion(region);
                continue;
            }
            if (region.getType() == "JSON_VALUE_BOOLEAN") {
                value = (JSONBooleanValueImpl)this.model.getDocument().createBooleanValue();
                pair.setValue(value);
                continue;
            }
            if (region.getType() == "JSON_VALUE_NULL") {
                value = (JSONNullValueImpl)this.model.getDocument().createNullValue();
                pair.setValue(value);
                continue;
            }
            if (region.getType() == "JSON_VALUE_NUMBER") {
                value = (JSONNumberValueImpl)this.model.getDocument().createNumberValue();
                pair.setValue(value);
                continue;
            }
            if (region.getType() != "JSON_VALUE_STRING") continue;
            value = (JSONStringValueImpl)this.model.getDocument().createStringValue();
            pair.setValue(value);
        }
    }

    protected boolean isNestedTag(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedCommentText(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedCommentOpen(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedTagName(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedContent(String regionType) {
        boolean result = false;
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void promoteNodes(IJSONNode root, IJSONNode newParent, IJSONNode newNext, IJSONNode oldParent, IJSONNode next) {
        newElement = null;
        if (newParent.getNodeType() == 0) {
            newElement = (JSONObjectImpl)newParent;
        }
        rootParent = root.getParentNode();
        ** GOTO lbl59
        {
            done = false;
            endTag = false;
            if (next.getNodeType() != 0 || (nextElement = (JSONObjectImpl)next).hasStartTag()) ** GOTO lbl18
            nextChild = nextElement.getFirstChild();
            if (nextChild != null) {
                next = nextChild;
                oldParent = nextElement;
            } else {
                next = nextElement.getNextSibling();
                oldParent.removeChild(nextElement);
                done = true;
lbl18:
                // 2 sources

                if (!done) {
                    if (!endTag && newElement != null) {
                        newParent = newElement.getParentNode();
                        if (newParent == null) {
                            return;
                        }
                        elementNext = newElement.getNextSibling();
                        this.promoteNodes(newElement, newParent, elementNext, newElement, newNext);
                        newNext = newElement.getNextSibling();
                        newElement = newParent.getNodeType() == 0 ? (JSONObjectImpl)newParent : null;
                    } else {
                        child = next;
                        next = next.getNextSibling();
                        oldParent.removeChild(child);
                        this.insertNode(newParent, child, newNext);
                        childParent = child.getParentNode();
                        if (childParent != newParent) {
                            newParent = childParent;
                            newElement = (JSONObjectImpl)newParent;
                            newNext = child.getNextSibling();
                        }
                    }
                }
            }
            do {
                if (next != null) continue block0;
                if (oldParent.getNodeType() != 0) {
                    return;
                }
                oldElement = (JSONObjectImpl)oldParent;
                if ((oldParent = oldElement.getParentNode()) == null) {
                    return;
                }
                next = oldElement.getNextSibling();
                if (!oldElement.hasEndTag()) continue;
                end = null;
                if (!oldElement.hasChildNodes() && !oldElement.hasStartTag()) {
                    oldParent.removeChild(oldElement);
                    end = oldElement;
                }
                if (end == null) continue;
                this.insertNode(newParent, end, newNext);
                endParent = end.getParentNode();
                if (endParent == newParent) continue;
                newParent = endParent;
                newElement = (JSONObjectImpl)newParent;
                newNext = end.getNextSibling();
lbl59:
                // 5 sources

            } while (oldParent != rootParent);
        }
    }

    private void removeEndTag(IJSONNode element) {
        if (element == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        IJSONNode parent = element.getParentNode();
        if (parent == null) {
            return;
        }
        if (!((JSONObjectImpl)element).isContainer()) {
            IJSONNode elementNext = element.getNextSibling();
            if (elementNext != null) {
                this.context.setCurrentNode(elementNext);
            } else {
                this.context.setParentNode(parent);
            }
            return;
        }
        IJSONNode next = element.getNextSibling();
        JSONObjectImpl newElement = (JSONObjectImpl)element;
        IJSONNode last = newElement.getLastChild();
        while (last != null) {
            JSONObjectImpl lastElement;
            if (last.getNodeType() != 0 || (lastElement = (JSONObjectImpl)last).hasEndTag() || lastElement.isEmptyTag() || !lastElement.isContainer()) break;
            newElement = lastElement;
            last = last.getLastChild();
        }
        IJSONNode lastChild = newElement.getLastChild();
        this.demoteNodes(element, newElement, parent, next);
        IJSONNode newNext = null;
        newNext = lastChild != null ? lastChild.getNextSibling() : newElement.getFirstChild();
        if (newNext != null) {
            this.context.setCurrentNode(newNext);
        } else {
            this.context.setParentNode(newElement);
        }
    }

    private void removeNode(IJSONNode node) {
        JSONObjectImpl newElement;
        if (node == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        IJSONNode parent = node.getParentNode();
        if (parent == null && node instanceof IJSONValue && (parent = node.getParentOrPairNode()) == null) {
            return;
        }
        IJSONNode next = node.getNextSibling();
        IJSONNode prev = node.getPreviousSibling();
        IJSONNode oldParent = this.context.getParentNode();
        if (node == oldParent) {
            if (next != null) {
                this.context.setCurrentNode(next);
            } else {
                this.context.setParentNode(parent);
            }
        } else {
            IJSONNode oldNext = this.context.getNextNode();
            if (node == oldNext) {
                this.context.setCurrentNode(next);
            }
        }
        parent.removeChild(node);
        if (prev != null && prev.getNodeType() == 0 && !(newElement = (JSONObjectImpl)prev).hasEndTag() && !newElement.isEmptyTag() && newElement.isContainer()) {
            IJSONNode last = newElement.getLastChild();
            while (last != null) {
                JSONObjectImpl lastElement;
                if (last.getNodeType() != 0 || (lastElement = (JSONObjectImpl)last).hasEndTag() || lastElement.isEmptyTag() || !lastElement.isContainer()) break;
                newElement = lastElement;
                last = last.getLastChild();
            }
            IJSONNode lastChild = newElement.getLastChild();
            this.demoteNodes(prev, newElement, parent, next);
            IJSONNode newNext = null;
            newNext = lastChild != null ? lastChild.getNextSibling() : newElement.getFirstChild();
            if (newNext != null) {
                this.context.setCurrentNode(newNext);
            } else {
                this.context.setParentNode(newElement);
            }
        }
    }

    private void removeStartObject(IJSONObject element) {
        if (element == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        JSONObjectImpl oldElement = (JSONObjectImpl)element;
        IJSONNode elementParent = element.getParentNode();
        IJSONNode parent = elementParent;
        if (parent == null) {
            return;
        }
        IJSONNode first = element.getFirstChild();
        JSONObjectImpl firstElement = null;
        if (first != null) {
            IJSONNode child;
            IJSONNode nextChild;
            JSONObjectImpl newElement = null;
            IJSONNode last = element.getPreviousSibling();
            while (last != null) {
                JSONObjectImpl lastElement;
                if (last.getNodeType() != 0 || (lastElement = (JSONObjectImpl)last).hasEndTag() || lastElement.isEmptyTag() || !lastElement.isContainer()) break;
                newElement = lastElement;
                last = last.getLastChild();
            }
            IJSONNode next = first;
            if (newElement != null) {
                while (next != null) {
                    JSONObjectImpl nextElement;
                    if (!newElement.hasEndTag() && newElement.hasStartTag() && next.getNodeType() == 0 && !(nextElement = (JSONObjectImpl)next).hasStartTag() && nextElement.hasEndTag()) {
                        IJSONNode newParent;
                        IJSONNode elementChild = nextElement.getFirstChild();
                        while (elementChild != null) {
                            nextChild = elementChild.getNextSibling();
                            nextElement.removeChild(elementChild);
                            newElement.appendChild(elementChild);
                            elementChild = nextChild;
                        }
                        next = nextElement.getNextSibling();
                        element.removeChild(nextElement);
                        if (nextElement == first) {
                            firstElement = newElement;
                        }
                        if ((newParent = newElement.getParentNode()) == parent || newParent == null || newParent.getNodeType() != 0) break;
                        newElement = (JSONObjectImpl)newParent;
                        continue;
                    }
                    child = next;
                    next = next.getNextSibling();
                    element.removeChild(child);
                    newElement.appendChild(child);
                }
                newElement = null;
            }
            if (parent.getNodeType() == 0) {
                newElement = (JSONObjectImpl)parent;
            }
            while (next != null) {
                if (newElement == null) {
                    child = next;
                    next = next.getNextSibling();
                    element.removeChild(child);
                    parent.insertBefore(child, element);
                    continue;
                }
                parent = newElement.getParentNode();
                if (parent == null) {
                    return;
                }
                IJSONNode newNext = newElement.getNextSibling();
                IJSONNode child2 = element;
                while (child2 != null) {
                    nextChild = child2.getNextSibling();
                    newElement.removeChild(child2);
                    parent.insertBefore(child2, newNext);
                    child2 = nextChild;
                }
                newElement.hasEndTag();
                if (!newElement.hasStartTag() && !newElement.hasChildNodes()) {
                    parent.removeChild(newElement);
                }
                newElement = parent.getNodeType() == 0 ? (JSONObjectImpl)parent : null;
            }
        }
        IJSONNode newNext = element;
        JSONObjectImpl startElement = null;
        if (oldElement.hasEndTag()) {
            JSONObjectImpl newElement = null;
            IJSONNode last = element.getPreviousSibling();
            while (last != null) {
                JSONObjectImpl lastElement;
                if (last.getNodeType() != 0 || (lastElement = (JSONObjectImpl)last).hasEndTag() || lastElement.isEmptyTag() || !lastElement.isContainer()) break;
                newElement = lastElement;
                last = last.getLastChild();
            }
            if (newElement != null) {
                IJSONNode next = element;
                while (next != null) {
                    JSONObjectImpl nextElement;
                    if (!newElement.hasEndTag() && newElement.hasStartTag() && next.getNodeType() == 0 && !(nextElement = (JSONObjectImpl)next).hasStartTag() && nextElement.hasEndTag()) {
                        IJSONNode newParent;
                        IJSONNode elementChild = nextElement.getFirstChild();
                        while (elementChild != null) {
                            IJSONNode nextChild = elementChild.getNextSibling();
                            nextElement.removeChild(elementChild);
                            newElement.appendChild(elementChild);
                            elementChild = nextChild;
                        }
                        next = nextElement.getNextSibling();
                        parent.removeChild(nextElement);
                        if (nextElement == newNext) {
                            startElement = newElement;
                        }
                        if ((newParent = newElement.getParentNode()) != parent && newParent != null && newParent.getNodeType() == 0) {
                            newElement = (JSONObjectImpl)newParent;
                            continue;
                        }
                        break;
                    }
                    IJSONObject child = next;
                    next = next.getNextSibling();
                    parent.removeChild(child);
                    newElement.appendChild(child);
                }
            }
        } else {
            newNext = oldElement.getNextSibling();
            parent.removeChild(oldElement);
        }
        IJSONNode oldParent = this.context.getParentNode();
        IJSONNode oldNext = this.context.getNextNode();
        if (element == oldParent) {
            if (oldNext != null) {
                this.context.setCurrentNode(oldNext);
            } else if (newNext != null) {
                this.context.setCurrentNode(newNext);
            } else {
                this.context.setParentNode(parent);
            }
        } else if (element == oldNext) {
            if (firstElement != null) {
                this.context.setParentNode(firstElement);
            } else if (first != null) {
                this.context.setCurrentNode(first);
            } else if (startElement != null) {
                this.context.setParentNode(startElement);
            } else {
                this.context.setCurrentNode(newNext);
            }
        }
    }

    private void removeStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        short nodeType;
        JSONNodeImpl node = (JSONNodeImpl)this.context.getCurrentNode();
        if (node != null && ((nodeType = node.getNodeType()) == 0 || nodeType == 1 || nodeType == 2)) {
            this.removeNode(node);
            return;
        }
    }

    void replaceRegions(IStructuredDocumentRegion flatNode, ITextRegionList newRegions, ITextRegionList oldRegions) {
        String regionType;
        if (flatNode == null) {
            return;
        }
        if (this.model.getDocument() == null) {
            return;
        }
        this.context = new JSONModelContext(this.model.getDocument());
        boolean isWhiteSpaces = false;
        if (newRegions != null && (oldRegions == null || oldRegions.size() == 0)) {
            isWhiteSpaces = true;
            Iterator e = newRegions.iterator();
            while (e.hasNext() && isWhiteSpaces) {
                ITextRegion region = (ITextRegion)e.next();
                String regionType2 = region.getType();
                boolean bl = isWhiteSpaces = regionType2 == "WHITE_SPACE";
            }
            if (isWhiteSpaces) {
                return;
            }
        }
        if ((regionType = StructuredDocumentRegionUtil.getFirstRegionType(flatNode)) == "JSON_OBJECT_OPEN") {
            this.changeStartObject(flatNode, newRegions, oldRegions);
        }
        if (regionType == "JSON_OBJECT_KEY") {
            this.changeAttrName(flatNode, flatNode.getFirstRegion());
        } else if (this.isJSONValue(regionType)) {
            this.changeAttrValue(flatNode, flatNode.getFirstRegion());
        } else {
            if (regionType == "JSON_UNKNOWN") {
                return;
            }
            this.changeStructuredDocumentRegion(flatNode);
        }
    }

    void replaceStructuredDocumentRegions(IStructuredDocumentRegionList newStructuredDocumentRegions, IStructuredDocumentRegionList oldStructuredDocumentRegions) {
        IStructuredDocumentRegion documentRegion;
        int i;
        if (this.model.getDocument() == null) {
            return;
        }
        this.context = new JSONModelContext(this.model.getDocument());
        int newCount = newStructuredDocumentRegions != null ? newStructuredDocumentRegions.getLength() : 0;
        int oldCount = oldStructuredDocumentRegions != null ? oldStructuredDocumentRegions.getLength() : 0;
        int index = 0;
        while (index < oldCount - 1) {
            if (!oldStructuredDocumentRegions.item(index).getType().equals("JSON_COMMA")) break;
            ++index;
        }
        if (oldCount > 0 && !oldStructuredDocumentRegions.item(index).getType().equals("JSON_COMMA")) {
            this.setupContext(oldStructuredDocumentRegions.item(index));
            i = index;
            while (i < oldCount) {
                documentRegion = oldStructuredDocumentRegions.item(i);
                this.removeStructuredDocumentRegion(documentRegion);
                ++i;
            }
        } else {
            if (newCount == 0) {
                return;
            }
            index = 0;
            while (index < newCount - 1) {
                if (!newStructuredDocumentRegions.item(index).getType().equals("JSON_COMMA")) break;
                ++index;
            }
            if (newCount > 0 && !newStructuredDocumentRegions.item(index).getType().equals("JSON_COMMA")) {
                this.setupContext(newStructuredDocumentRegions.item(index));
            }
        }
        this.context.setLast();
        if (newCount > 0) {
            i = 0;
            while (i < newCount) {
                documentRegion = newStructuredDocumentRegions.item(i);
                this.insertStructuredDocumentRegion(documentRegion);
                ++i;
            }
        }
        this.context.setCurrentNode(null);
    }

    /*
     * Unable to fully structure code
     */
    private void setupContext(IStructuredDocumentRegion startStructuredDocumentRegion) {
        offset = startStructuredDocumentRegion.getStart();
        if (offset < 0) {
            return;
        }
        root = (JSONNodeImpl)this.context.getRootNode();
        if (root == null) {
            return;
        }
        if (offset == 0) {
            child = root.getFirstChild();
            if (child != null) {
                this.context.setCurrentNode(child);
            } else {
                this.context.setParentNode(root);
            }
            return;
        }
        node = (JSONNodeImpl)root.getNodeAt(offset);
        if (node == null) {
            this.context.setParentNode(root);
            this.context.setLast();
            return;
        }
        if (node.getStartStructuredDocumentRegion() != null) {
            if (offset == node.getStartStructuredDocumentRegion().getStartOffset()) {
                this.context.setCurrentNode(node);
                return;
            }
            if (node.getEndStructuredDocumentRegion() != null && offset == node.getEndStructuredDocumentRegion().getStartOffset()) {
                this.context.setCurrentNode(node);
                return;
            }
        }
        if (node instanceof JSONPairImpl && ((JSONPairImpl)node).getValue() == null && this.isJSONValue(startStructuredDocumentRegion.getType())) {
            this.context.setCurrentNode(node);
            return;
        }
        child = node.getFirstChild();
        while (child != null) {
            if (offset >= ((JSONNodeImpl)child).getEndOffset()) {
                if (child instanceof JSONPairImpl && ((JSONPairImpl)child).getValue() == null) {
                    if (this.isJSONValue(startStructuredDocumentRegion.getType())) {
                        this.context.setCurrentNode(child);
                        return;
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                this.context.setCurrentNode(child);
                return;
            }
            child = child.getNextSibling();
        }
        this.context.setParentNode(node);
        this.context.setLast();
    }

    protected JSONModelContext getContext() {
        return this.context;
    }

    private boolean isJSONValue(String regionType) {
        return regionType == "JSON_VALUE_STRING" || regionType == "JSON_VALUE_BOOLEAN" || regionType == "JSON_VALUE_NUMBER" || regionType == "JSON_VALUE_NULL";
    }
}

