/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.format;

import java.util.ArrayList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.cleanup.IJSONCleanupStrategy;
import org.eclipse.wst.json.core.cleanup.JSONCleanupStrategyImpl;
import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.internal.format.CompoundRegion;
import org.eclipse.wst.json.core.internal.format.FormatRegion;
import org.eclipse.wst.json.core.internal.format.IJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.JSONSourceFormatterFactory;
import org.eclipse.wst.json.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public abstract class AbstractJSONSourceFormatter
implements IJSONSourceFormatter {
    protected static final short GENERATE = 0;
    protected static final short FORMAT = 1;
    protected static final short CLEANUP = 2;
    protected static short strategy;

    AbstractJSONSourceFormatter() {
    }

    protected void appendDelimBefore(IJSONNode node, CompoundRegion toAppend, StringBuilder source) {
        boolean needIndent;
        if (node == null || source == null) {
            return;
        }
        if (AbstractJSONSourceFormatter.isCleanup() && !this.getCleanupStrategy(node).isFormatSource()) {
            return;
        }
        String delim = this.getLineDelimiter(node);
        boolean bl = needIndent = !(node instanceof IJSONDocument);
        if (toAppend == null) {
            source.append(delim);
            source.append(this.getIndent(node));
            if (needIndent) {
                source.append(this.getIndentString());
            }
        } else {
            String type = toAppend.getType();
            if (type == "JSON_COMMENT") {
                RegionIterator it = new RegionIterator(toAppend.getDocumentRegion(), toAppend.getTextRegion());
                it.prev();
                ITextRegion prev = it.prev();
                int[] result = null;
                if (prev == null || prev.getType() == "WHITE_SPACE" && (result = TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)it.getStructuredDocumentRegion().getText(prev), (int)0))[0] >= 0) {
                    if (result != null) {
                        void offset = result[0] + DefaultLineTracker.DELIMITERS[result[1]].length();
                        if (offset < it.getStructuredDocumentRegion().getText(prev).length() && TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)it.getStructuredDocumentRegion().getText(prev), (int)offset)[0] >= 0) {
                            source.append(delim);
                        }
                        source.append(delim);
                        source.append(this.getIndent(node));
                        if (needIndent) {
                            source.append(this.getIndentString());
                        }
                    }
                } else if (prev.getType() == "JSON_COMMENT") {
                    int[] delimiterFound;
                    String fullText = toAppend.getDocumentRegion().getFullText(prev);
                    String trimmedText = toAppend.getDocumentRegion().getText(prev);
                    String whiteSpaces = "";
                    if (fullText != null && trimmedText != null) {
                        whiteSpaces = fullText.substring(trimmedText.length());
                    }
                    if ((delimiterFound = TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)whiteSpaces, (int)0))[0] != -1) {
                        source.append(delim);
                    } else {
                        this.appendSpaceBefore(node, toAppend.getText(), source);
                        if (source.toString().endsWith(this.getIndentString())) {
                            source.delete(source.length() - this.getIndentString().length(), source.length());
                        }
                    }
                } else {
                    this.appendSpaceBefore(node, toAppend.getText(), source);
                }
            } else if (type == "JSON_COMMA") {
                int append;
                int length;
                RegionIterator it = new RegionIterator(toAppend.getDocumentRegion(), toAppend.getTextRegion());
                it.prev();
                ITextRegion prev = it.prev();
                Preferences preferences = JSONCorePlugin.getDefault().getPluginPreferences();
                if (prev.getType() == "WHITE_SPACE" && TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)it.getStructuredDocumentRegion().getText(prev), (int)0)[0] >= 0) {
                    source.append(delim);
                    source.append(this.getIndent(node));
                    if (needIndent) {
                        source.append(this.getIndentString());
                    }
                } else if (!(preferences.getInt("lineWidth") <= 0 || preferences.getBoolean("prohibitWrapOnAttr") && node.getOwnerDocument().getNodeType() == 2 || (length = this.getLastLineLength(node, source)) + (append = 1) <= preferences.getInt("lineWidth"))) {
                    source.append(this.getLineDelimiter(node));
                    source.append(this.getIndent(node));
                    if (needIndent) {
                        source.append(this.getIndentString());
                    }
                }
            } else if (type == "JSON_OBJECT_OPEN" || type == "JSON_OBJECT_CLOSE" || type == "JSON_ARRAY_OPEN" || type == "JSON_ARRAY_CLOSE") {
                source.append(delim);
                source.append(this.getIndent(node));
            } else {
                source.append(delim);
                source.append(this.getIndent(node));
                if (needIndent) {
                    source.append(this.getIndentString());
                }
            }
        }
    }

    protected void appendSpaceBefore(IJSONNode node, CompoundRegion toAppend, StringBuilder source) {
        if (node == null || toAppend == null || source == null) {
            return;
        }
        if (AbstractJSONSourceFormatter.isCleanup() && !this.getCleanupStrategy(node).isFormatSource()) {
            return;
        }
        String type = toAppend.getType();
        Preferences preferences = JSONCorePlugin.getDefault().getPluginPreferences();
        boolean cfr_ignored_0 = node instanceof IJSONDocument;
        if ((type == "JSON_OBJECT_OPEN" || type == "JSON_ARRAY_OPEN") && preferences.getBoolean("newLineOnOpenBrace")) {
            String delim = this.getLineDelimiter(node);
            source.append(delim);
            source.append(this.getIndent(node));
        } else {
            this.appendSpaceBefore(node, toAppend.getText(), source);
        }
    }

    protected void appendSpaceBefore(IJSONNode node, String toAppend, StringBuilder source) {
        if (node == null || source == null) {
            return;
        }
        if (AbstractJSONSourceFormatter.isCleanup() && !this.getCleanupStrategy(node).isFormatSource()) {
            return;
        }
        Preferences preferences = JSONCorePlugin.getDefault().getPluginPreferences();
        if (toAppend != null && toAppend.startsWith("{") && preferences.getBoolean("newLineOnOpenBrace")) {
            source.append(this.getLineDelimiter(node));
            source.append(this.getIndent(node));
            return;
        }
        if (preferences.getInt("lineWidth") > 0 && !preferences.getBoolean("prohibitWrapOnAttr")) {
            int append;
            int n = this.getLastLineLength(node, source);
            int n2 = append = toAppend != null ? TextUtilities.indexOf((String[])DefaultLineTracker.DELIMITERS, (String)toAppend, (int)0)[0] : 0;
            if (toAppend != null) {
                int n3 = append = append < 0 ? toAppend.length() : append;
            }
            if (n + append + 1 > preferences.getInt("lineWidth")) {
                source.append(this.getLineDelimiter(node));
                source.append(this.getIndent(node));
                source.append(this.getIndentString());
                return;
            }
        }
        if (!(source.length() > 0 && source.toString().charAt(source.length() - 1) == ' ' || toAppend.length() > 0 && toAppend.charAt(toAppend.length() - 1) == ' ')) {
            source.append(" ");
        }
    }

    @Override
    public final StringBuilder cleanup(IJSONNode node) {
        short oldStrategy = strategy;
        strategy = (short)2;
        StringBuilder source = this.formatProc(node);
        strategy = oldStrategy;
        return source;
    }

    @Override
    public final StringBuilder cleanup(IJSONNode node, IRegion region) {
        short oldStrategy = strategy;
        strategy = (short)2;
        StringBuilder source = this.formatProc(node, region);
        strategy = oldStrategy;
        return source;
    }

    protected String decoratedIdentRegion(CompoundRegion region, IJSONCleanupStrategy stgy) {
        if (AbstractJSONSourceFormatter.isFormat()) {
            return region.getText();
        }
        String text = null;
        text = !stgy.isFormatSource() ? region.getFullText() : region.getText();
        if (AbstractJSONSourceFormatter.isCleanup()) {
            if (stgy.getIdentCase() == 0) {
                return text;
            }
            if (stgy.getIdentCase() == 2) {
                return text.toUpperCase();
            }
            return text.toLowerCase();
        }
        JSONCorePlugin.getDefault().getPluginPreferences();
        return text.toLowerCase();
    }

    protected String decoratedPropNameRegion(CompoundRegion region, IJSONCleanupStrategy stgy) {
        if (AbstractJSONSourceFormatter.isFormat()) {
            return region.getText();
        }
        String text = null;
        text = !stgy.isFormatSource() ? region.getFullText() : region.getText();
        if (AbstractJSONSourceFormatter.isCleanup()) {
            if (stgy.getPropNameCase() == 2) {
                return text.toUpperCase();
            }
            return text.toLowerCase();
        }
        Preferences preferences = JSONCorePlugin.getDefault().getPluginPreferences();
        if (preferences.getInt("propNameCase") == 2) {
            return text.toUpperCase();
        }
        return text.toLowerCase();
    }

    protected String decoratedPropValueRegion(CompoundRegion region, IJSONCleanupStrategy stgy) {
        if (AbstractJSONSourceFormatter.isFormat()) {
            return region.getText();
        }
        String text = null;
        text = !stgy.isFormatSource() ? region.getFullText() : region.getText();
        region.getType();
        if (AbstractJSONSourceFormatter.isCleanup() && stgy.getPropValueCase() != 0) {
            text = stgy.getPropValueCase() == 2 ? text.toUpperCase() : text.toLowerCase();
        }
        return text;
    }

    protected String decoratedRegion(CompoundRegion region, int type, IJSONCleanupStrategy stgy) {
        if (AbstractJSONSourceFormatter.isFormat()) {
            return region.getText();
        }
        JSONCorePlugin.getDefault().getPluginPreferences();
        String text = null;
        text = !stgy.isFormatSource() ? region.getFullText() : region.getText();
        return text;
    }

    @Override
    public final StringBuilder format(IJSONNode node) {
        short oldStrategy = strategy;
        strategy = 1;
        StringBuilder source = this.formatProc(node);
        strategy = oldStrategy;
        return source;
    }

    @Override
    public final StringBuilder format(IJSONNode node, IRegion region) {
        short oldStrategy = strategy;
        strategy = 1;
        StringBuilder source = this.formatProc(node, region);
        strategy = oldStrategy;
        return source;
    }

    protected void formatChildren(IJSONNode node, StringBuilder source) {
        IJSONNode child = node.getFirstChild();
        while (child != null) {
            IJSONSourceFormatter formatter = (IJSONSourceFormatter)child.getAdapterFor(IJSONSourceFormatter.class);
            if (formatter == null) {
                formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(child);
            }
            StringBuilder childSource = ((AbstractJSONSourceFormatter)formatter).formatProc(child);
            source.append((CharSequence)childSource);
            child = child.getNextSibling();
        }
    }

    protected void formatChildren(IJSONNode node, IRegion region, StringBuilder source) {
        IJSONNode child = node.getFirstChild();
        int start = region.getOffset();
        int end = region.getOffset() + region.getLength();
        while (child != null) {
            int curEnd = child.getEndOffset();
            StringBuilder childSource = null;
            boolean toFinish = false;
            if (start < curEnd) {
                int curStart = child.getStartOffset();
                if (curStart < end) {
                    IJSONSourceFormatter formatter = (IJSONSourceFormatter)child.getAdapterFor(IJSONSourceFormatter.class);
                    if (formatter == null) {
                        formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(child);
                    }
                    childSource = AbstractJSONSourceFormatter.includes(region, curStart, curEnd) ? ((AbstractJSONSourceFormatter)formatter).formatProc(child) : ((AbstractJSONSourceFormatter)formatter).formatProc(child, AbstractJSONSourceFormatter.overlappedRegion(region, curStart, curEnd));
                } else {
                    toFinish = true;
                }
            }
            if (childSource != null) {
                source.append((CharSequence)childSource);
            }
            if (toFinish) break;
            child = child.getNextSibling();
        }
    }

    protected abstract void formatPost(IJSONNode var1, StringBuilder var2);

    protected abstract void formatPost(IJSONNode var1, IRegion var2, StringBuilder var3);

    protected abstract void formatPre(IJSONNode var1, StringBuilder var2);

    protected abstract void formatPre(IJSONNode var1, IRegion var2, StringBuilder var3);

    protected final StringBuilder formatProc(IJSONNode node) {
        StringBuilder source = new StringBuilder();
        this.formatPre(node, source);
        this.formatChildren(node, source);
        this.formatPost(node, source);
        return source;
    }

    protected StringBuilder formatProc(IJSONNode node, IRegion region) {
        StringBuilder source = new StringBuilder();
        int curStart = node.getStartOffset();
        int curEnd = node.getEndOffset();
        if (node.hasChildNodes()) {
            curEnd = node.getFirstChild().getStartOffset();
            if (AbstractJSONSourceFormatter.overlaps(region, curStart, curEnd)) {
                if (AbstractJSONSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPre(node, source);
                } else {
                    this.formatPre(node, AbstractJSONSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
            if (AbstractJSONSourceFormatter.overlaps(region, curStart = curEnd, curEnd = node.getLastChild().getEndOffset())) {
                if (AbstractJSONSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatChildren(node, source);
                } else {
                    this.formatChildren(node, AbstractJSONSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
            if (AbstractJSONSourceFormatter.overlaps(region, curStart = curEnd, curEnd = node.getEndOffset())) {
                if (AbstractJSONSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPost(node, source);
                } else {
                    this.formatPost(node, AbstractJSONSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
        } else if (node instanceof IJSONArray || node instanceof IJSONObject) {
            curStart = node.getStartOffset();
            if (AbstractJSONSourceFormatter.overlaps(region, curStart, curEnd = node.getEndOffset())) {
                if (AbstractJSONSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPre(node, source);
                    this.formatPost(node, source);
                } else {
                    this.formatPre(node, AbstractJSONSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                    this.formatPost(node, AbstractJSONSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
        } else {
            int n = curEnd = node.getEndOffset() > 0 ? node.getEndOffset() : -1;
            if (AbstractJSONSourceFormatter.overlaps(region, curStart, curEnd)) {
                if (AbstractJSONSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPre(node, source);
                } else {
                    this.formatPre(node, AbstractJSONSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
            if (AbstractJSONSourceFormatter.overlaps(region, curStart = curEnd, curEnd = node.getEndOffset())) {
                if (AbstractJSONSourceFormatter.includes(region, curStart, curEnd)) {
                    this.formatPost(node, source);
                } else {
                    this.formatPost(node, AbstractJSONSourceFormatter.overlappedRegion(region, curStart, curEnd), source);
                }
            }
        }
        return source;
    }

    protected IJSONCleanupStrategy getCleanupStrategy(IJSONNode node) {
        IJSONCleanupStrategy currentStrategy = JSONCleanupStrategyImpl.getInstance();
        IJSONDocument doc = node.getOwnerDocument();
        if (doc == null) {
            return currentStrategy;
        }
        IJSONModel model = doc.getModel();
        if (model == null) {
            return currentStrategy;
        }
        return currentStrategy;
    }

    protected String getIndent(IJSONNode node) {
        if (node == null) {
            return "";
        }
        IJSONNode parent = node.getParentNode();
        if (parent == null || parent instanceof IJSONDocument) {
            return "";
        }
        String parentIndent = this.getIndent(parent);
        return String.valueOf(parentIndent) + this.getIndentString();
    }

    protected int getLastLineLength(IJSONNode node, StringBuilder source) {
        if (node == null || source == null) {
            return 0;
        }
        String str = new String(source);
        String delim = this.getLineDelimiter(node);
        int n = str.lastIndexOf(delim);
        if (n < 0) {
            return str.length();
        }
        return str.length() - n - delim.length();
    }

    String getLineDelimiter(IJSONNode node) {
        IJSONModel model = node != null ? node.getOwnerDocument().getModel() : null;
        return model != null ? model.getStructuredDocument().getLineDelimiter() : "\n";
    }

    protected CompoundRegion[] getOutsideRegions(IStructuredDocument model, IRegion reg) {
        IStructuredDocumentRegion documentRegion;
        ITextRegion textRegion;
        CompoundRegion[] ret = new CompoundRegion[2];
        RegionIterator it = new RegionIterator(model, reg.getOffset());
        it.prev();
        if (it.hasPrev()) {
            textRegion = it.prev();
            documentRegion = it.getStructuredDocumentRegion();
            ret[0] = new CompoundRegion(documentRegion, textRegion);
        } else {
            ret[0] = null;
        }
        it.reset(model, reg.getOffset() + reg.getLength());
        if (it.hasNext()) {
            textRegion = it.next();
            documentRegion = it.getStructuredDocumentRegion();
            ret[1] = new CompoundRegion(documentRegion, textRegion);
        } else {
            ret[1] = null;
        }
        return ret;
    }

    protected IJSONSourceFormatter getParentFormatter(IJSONNode node) {
        IJSONNode parent = node.getParentNode();
        if (parent != null) {
            IJSONSourceFormatter formatter = (IJSONSourceFormatter)parent.getAdapterFor(IJSONSourceFormatter.class);
            if (formatter == null) {
                formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(parent);
            }
            return formatter;
        }
        return null;
    }

    protected CompoundRegion[] getRegions(IStructuredDocument model, IRegion reg, IRegion exceptFor, String pickupType) {
        int start = reg.getOffset();
        int end = reg.getOffset() + reg.getLength();
        int startE = exceptFor != null ? exceptFor.getOffset() : -1;
        int endE = exceptFor != null ? exceptFor.getOffset() + exceptFor.getLength() : 0;
        ArrayList<CompoundRegion> list = new ArrayList<CompoundRegion>();
        IStructuredDocumentRegion flatNode = model.getRegionAtCharacterOffset(start);
        boolean pickuped = false;
        while (flatNode != null && flatNode.getStartOffset() < end) {
            ITextRegionList regionList = flatNode.getRegions();
            for (ITextRegion region : regionList) {
                if (flatNode.getStartOffset(region) < start) continue;
                if (end <= flatNode.getStartOffset(region)) break;
                if (startE >= 0 && startE <= flatNode.getStartOffset(region) && flatNode.getEndOffset(region) <= endE || pickuped || region.getType() != pickupType) continue;
                list.add(new CompoundRegion(flatNode, region));
                pickuped = true;
            }
            flatNode = flatNode.getNext();
        }
        if (list.size() > 0) {
            CompoundRegion[] regions = new CompoundRegion[list.size()];
            list.toArray(regions);
            return regions;
        }
        return new CompoundRegion[0];
    }

    protected CompoundRegion[] getRegionsWithoutWhiteSpaces(IStructuredDocument model, IRegion reg, IJSONCleanupStrategy stgy) {
        int start = reg.getOffset();
        int end = reg.getOffset() + reg.getLength() - 1;
        ArrayList<CompoundRegion> list = new ArrayList<CompoundRegion>();
        IStructuredDocumentRegion flatNode = model.getRegionAtCharacterOffset(start);
        while (flatNode != null && flatNode.getStartOffset() <= end) {
            ITextRegionList regionList = flatNode.getRegions();
            for (ITextRegion region : regionList) {
                if (flatNode.getStartOffset(region) < start) continue;
                if (end < flatNode.getStartOffset(region)) break;
                if (region.getType() == "WHITE_SPACE" && (!AbstractJSONSourceFormatter.isCleanup() || stgy.isFormatSource())) continue;
                list.add(new CompoundRegion(flatNode, region));
            }
            flatNode = flatNode.getNext();
        }
        if (list.size() > 0) {
            CompoundRegion[] regions = new CompoundRegion[list.size()];
            list.toArray(regions);
            return regions;
        }
        return new CompoundRegion[0];
    }

    public static boolean includes(IRegion region, int start, int end) {
        if (region == null) {
            return false;
        }
        return region.getOffset() <= start && end <= region.getOffset() + region.getLength();
    }

    protected static boolean isCleanup() {
        return strategy == 2;
    }

    protected static boolean isFormat() {
        return strategy == 1;
    }

    protected boolean isIncludesPreEnd(IJSONNode node, IRegion region) {
        return node.getFirstChild() != null && node.getFirstChild().getStartOffset() == region.getOffset() + region.getLength();
    }

    protected static boolean needS(CompoundRegion region) {
        return region != null && region.getType() != "WHITE_SPACE";
    }

    public static IRegion overlappedRegion(IRegion region, int start, int end) {
        if (AbstractJSONSourceFormatter.overlaps(region, start, end)) {
            int offset = region.getOffset() <= start ? start : region.getOffset();
            int length = (end <= region.getOffset() + region.getLength() ? end : region.getOffset() + region.getLength()) - offset;
            return new FormatRegion(offset, length);
        }
        return null;
    }

    public static boolean overlaps(IRegion region, int start, int end) {
        if (region == null) {
            return false;
        }
        return start < region.getOffset() + region.getLength() && region.getOffset() < end;
    }

    protected String getIndentString() {
        StringBuilder indent = new StringBuilder();
        Preferences preferences = JSONCorePlugin.getDefault().getPluginPreferences();
        if (preferences != null) {
            char indentChar = ' ';
            String indentCharPref = preferences.getString("indentationChar");
            if ("tab".equals(indentCharPref)) {
                indentChar = '\t';
            }
            int indentationWidth = preferences.getInt("indentationSize");
            int i = 0;
            while (i < indentationWidth) {
                indent.append(indentChar);
                ++i;
            }
        }
        return indent.toString();
    }

    protected void formatValue(IJSONNode node, StringBuilder source, IJSONNode value) {
        int end;
        int start;
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start = node.getStartOffset(), (end = node.getEndOffset()) - start), stgy);
        if (regions.length > 2) {
            int i = 2;
            while (i < regions.length) {
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
        }
    }

    protected void formatObject(IJSONNode node, StringBuilder source, IJSONNode jsonObject) {
        this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        IStructuredDocumentRegion[] structuredRegions = structuredDocument.getStructuredDocumentRegions(node.getStartOffset(), node.getEndOffset());
        if (structuredRegions.length >= 2) {
            StringBuilder objectSource;
            int start = structuredRegions[1].getStartOffset();
            int end = node.getEndOffset();
            IJSONSourceFormatter formatter = (IJSONSourceFormatter)jsonObject.getAdapterFor(IJSONSourceFormatter.class);
            if (formatter == null) {
                formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(jsonObject);
            }
            if ((objectSource = formatter.format(jsonObject, new FormatRegion(start, end - start))) != null) {
                source.append((CharSequence)objectSource);
            }
        }
    }
}

