/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.util;

import java.util.Enumeration;
import org.eclipse.wst.json.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class JSONUtil {
    public static void debugOut(String str) {
        Logger.log(2, "json warning: " + str);
    }

    public static String extractStringContents(String text) {
        return JSONUtil.stripQuotes(text);
    }

    public static IStructuredDocumentRegion findNextSignificantNode(IStructuredDocumentRegion startNode) {
        if (startNode == null) {
            return null;
        }
        IStructuredDocumentRegion node = startNode.getNext();
        while (node != null) {
            JSONUtil.getStructuredDocumentRegionType(node);
            node = node.getNext();
        }
        return null;
    }

    public static IStructuredDocumentRegion findNodeBackward(IStructuredDocumentRegion startNode, IStructuredDocumentRegion endNode, String type) {
        IStructuredDocumentRegion node = startNode;
        while (node != null) {
            if (node.getStartOffset() < endNode.getStartOffset()) {
                node = null;
                break;
            }
            if (JSONUtil.getStructuredDocumentRegionType(node) == type) break;
            node = node.getPrevious();
        }
        return node;
    }

    public static IStructuredDocumentRegion findNodeForward(IStructuredDocumentRegion startNode, IStructuredDocumentRegion endNode, String type) {
        IStructuredDocumentRegion node = startNode;
        while (node != null) {
            if (endNode.getStartOffset() < node.getStartOffset()) {
                node = null;
                break;
            }
            if (JSONUtil.getStructuredDocumentRegionType(node) == type) break;
            node = node.getNext();
        }
        return node;
    }

    public static IStructuredDocumentRegion findPreviousSignificantNode(IStructuredDocumentRegion startNode) {
        if (startNode == null) {
            return null;
        }
        IStructuredDocumentRegion node = startNode.getPrevious();
        while (node != null) {
            JSONUtil.getStructuredDocumentRegionType(node);
            node = node.getPrevious();
        }
        return null;
    }

    public static String getClassString(Object object) {
        if (object == null) {
            return "null";
        }
        String name = object.getClass().toString();
        int lastPeriod = name.lastIndexOf(46);
        return name.substring(lastPeriod + 1);
    }

    public static String getStructuredDocumentRegionType(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return "JSON_UNKNOWN";
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return "JSON_UNKNOWN";
        }
        ITextRegion region = regions.get(0);
        return region.getType();
    }

    public static int getLengthDifference(IStructuredDocumentRegionList newNodes, IStructuredDocumentRegionList oldNodes) {
        int newLen = JSONUtil.getTextLength(newNodes);
        int oldLen = JSONUtil.getTextLength(oldNodes);
        return newLen - oldLen;
    }

    public static String getRegionText(IStructuredDocumentRegion flatNode, ITextRegionList regions) {
        StringBuffer buf = new StringBuffer();
        if (regions != null) {
            for (ITextRegion region : regions) {
                if (region == null) continue;
                buf.append(flatNode.getText(region));
            }
        }
        return buf.toString();
    }

    public static int getTextLength(IStructuredDocumentRegionList nodes) {
        int length = 0;
        if (nodes != null) {
            Enumeration e = nodes.elements();
            while (e.hasMoreElements()) {
                IStructuredDocumentRegion flatNode = (IStructuredDocumentRegion)e.nextElement();
                if (flatNode == null) continue;
                length += flatNode.getText().length();
            }
        }
        return length;
    }

    public static String stripQuotes(String text) {
        if (text == null) {
            return null;
        }
        String contents = text.trim();
        if (2 <= contents.length()) {
            char first = contents.charAt(0);
            char last = contents.charAt(contents.length() - 1);
            if (first == '\"' && last == '\"' || first == '\'' && last == '\'') {
                contents = contents.substring(1, contents.length() - 1);
            }
        }
        return contents;
    }

    public static String detectQuote(String source, String defaultQuote) {
        if (source == null) {
            return defaultQuote;
        }
        int dIndex = source.indexOf("\"");
        int sIndex = source.indexOf("'");
        if (dIndex < 0 && sIndex < 0) {
            return defaultQuote;
        }
        if (dIndex < 0) {
            return "\"";
        }
        if (sIndex < 0) {
            return "'";
        }
        if (dIndex < sIndex) {
            return "'";
        }
        return "\"";
    }

    public static void stripSurroundingSpace(ITextRegionList regions) {
        ITextRegion region;
        if (regions == null) {
            return;
        }
        if (!regions.isEmpty()) {
            region = regions.get(0);
            region.getType();
        }
        if (!regions.isEmpty()) {
            region = regions.get(regions.size() - 1);
            region.getType();
        }
    }

    public static boolean isJSONSimpleValue(String regionType) {
        return regionType == "JSON_VALUE_BOOLEAN" || regionType == "JSON_VALUE_NULL" || regionType == "JSON_VALUE_NUMBER" || regionType == "JSON_VALUE_STRING";
    }

    public static boolean isStartJSONStructure(String regionType) {
        return regionType == "JSON_ARRAY_OPEN" || regionType == "JSON_OBJECT_OPEN";
    }

    public static boolean isEndJSONStructure(String regionType) {
        return regionType == "JSON_ARRAY_CLOSE" || regionType == "JSON_OBJECT_CLOSE";
    }
}

