/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xsl.launching.config.PreferenceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturePreferences {
    private Map<String, Map<String, String>> typeFeatures;

    public Map<String, String> getFeaturesValues(String typeId) {
        return this.typeFeatures.get(typeId);
    }

    public void setTypeFeatures(Map<String, Map<String, String>> typeFeatures) {
        this.typeFeatures = typeFeatures;
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = PreferenceUtil.getDocument();
        Element config = doc.createElement("featurePreferences");
        doc.appendChild(config);
        for (String typeId : this.typeFeatures.keySet()) {
            Element processorTypeElement = FeaturePreferences.typeAsElement(doc, typeId);
            Map<String, String> featureValues = this.typeFeatures.get(typeId);
            FeaturePreferences.featureValuesAsElement(doc, processorTypeElement, featureValues);
            config.appendChild(processorTypeElement);
        }
        return PreferenceUtil.serializeDocument((Document)doc);
    }

    public static FeaturePreferences fromXML(InputStream inputStream) throws CoreException {
        FeaturePreferences prefs = new FeaturePreferences();
        Document doc = PreferenceUtil.getDocument((InputStream)inputStream);
        Element config = doc.getDocumentElement();
        HashMap<String, Map<String, String>> typeFeatures = new HashMap<String, Map<String, String>>();
        Element[] processorTypeEls = PreferenceUtil.getChildElements((Element)config, (String)"processorType");
        int i = 0;
        while (i < processorTypeEls.length) {
            Element processorTypeEl = processorTypeEls[i];
            String type = FeaturePreferences.elementAsType(processorTypeEl);
            Map<String, String> featureValues = FeaturePreferences.elementAsFeatureValues(processorTypeEl);
            typeFeatures.put(type, featureValues);
            ++i;
        }
        prefs.setTypeFeatures(typeFeatures);
        return prefs;
    }

    private static String elementAsType(Element parent) {
        String id = parent.getAttribute("id");
        return id;
    }

    private static Element typeAsElement(Document doc, String type) {
        Element element = doc.createElement("processorType");
        element.setAttribute("id", type);
        return element;
    }

    private static Map<String, String> elementAsFeatureValues(Element element) {
        Element[] featureEls = PreferenceUtil.getChildElements((Element)element, (String)"feature");
        HashMap<String, String> featureValues = new HashMap<String, String>(featureEls.length);
        Element[] elementArray = featureEls;
        int n = featureEls.length;
        int n2 = 0;
        while (n2 < n) {
            Element featureEl = elementArray[n2];
            String uri = featureEl.getAttribute("uri");
            String value = featureEl.getAttribute("value");
            featureValues.put(uri, value);
            ++n2;
        }
        return featureValues;
    }

    private static void featureValuesAsElement(Document doc, Element featuresEl, Map<String, String> featureValues) {
        if (featureValues != null) {
            for (Map.Entry<String, String> entry2 : featureValues.entrySet()) {
                String uri = entry2.getKey();
                String value = entry2.getValue();
                Element element = doc.createElement("feature");
                element.setAttribute("uri", uri);
                element.setAttribute("value", value);
                featuresEl.appendChild(element);
            }
        }
    }
}

