/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtend.typesystem.xsd.AbstractXMLWorkflowComponent;
import org.eclipse.xtend.typesystem.xsd.OptionsEntry;
import org.eclipse.xtend.typesystem.xsd.XMLReaderImpl;

public class XMLReader
extends AbstractXMLWorkflowComponent {
    private static final String COMPONENT_NAME = "XML Reader";
    private Map<String, Object> options = new HashMap<String, Object>();
    private boolean useDocumentRoot = false;

    public void addOption(OptionsEntry entry) {
        this.options.put(entry.getKey(), entry.getValue());
    }

    public void checkConfiguration(Issues issues) {
        if (this.uri == null) {
            issues.addError((WorkflowComponent)this, "XML File (uri) not specified.");
        }
        super.checkConfiguration(issues);
    }

    public String getLogMessage() {
        return "Loading XML file " + this.uri;
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        XMLReaderImpl reader = new XMLReaderImpl(this.resourceSet, this.getMetaModel());
        reader.setUri(this.uri);
        reader.setUseDocumentRoot(this.useDocumentRoot);
        reader.getOptions().putAll(this.options);
        EObject model = reader.readXML();
        ctx.set(this.getModelSlot(), (Object)model);
    }

    public void setUseDocumentRoot(boolean returnDocumentRoot) {
        this.useDocumentRoot = returnDocumentRoot;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

