/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

class BitBuffer {
    private byte[] m_value = new byte[0];
    private int bitpos = 0;

    public BitBuffer append(int n, int n2) {
        int n3;
        if (this.bitpos + n2 > this.m_value.length * 8) {
            this.expandCapacity(this.bitpos + n2 - 1);
        }
        n <<= 32 - n2;
        int n4 = 0;
        int n5 = this.bitpos / 8;
        while (n2 - n4 + this.bitpos % 8 > 8) {
            n3 = 8 - this.bitpos % 8;
            int n6 = n >>> 32 - n3;
            int n7 = n5++;
            this.m_value[n7] = (byte)(this.m_value[n7] + n6);
            n <<= n3;
            n4 += n3;
            this.bitpos += n3;
            n5 = this.bitpos / 8;
        }
        n3 = n >>> 24 + this.bitpos % 8 & 0xFF;
        int n8 = n5;
        this.m_value[n8] = (byte)(this.m_value[n8] + n3);
        this.bitpos += n2 - n4;
        return this;
    }

    public byte[] toByteArray() {
        return this.m_value;
    }

    private void expandCapacity(int n) {
        int n2 = n / 8 + 1;
        assert (n2 > this.m_value.length);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_value, 0, byArray, 0, this.m_value.length);
        this.m_value = byArray;
    }

    public static void main(String[] stringArray) {
        BitBuffer bitBuffer = new BitBuffer();
        bitBuffer.append(255, 8);
        bitBuffer.append(3, 3);
        bitBuffer.append(13, 5);
        byte[] byArray = bitBuffer.toByteArray();
        int n = 0;
        while (n < byArray.length) {
            System.out.println("byte[" + n + "] = " + Integer.toBinaryString(byArray[n] & 0xFF));
            ++n;
        }
    }
}

