/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.nativeos;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.nativeos.INativeUI;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;

public class NativeUI
implements INativeUI {
    private static final int SWP_SHOWWINDOW = 64;
    String DEFAULT_COMMANDLINE = "";
    String DEFAULT_USEVNC = "false";

    public String getDefaultCommandLine() {
        return this.DEFAULT_COMMANDLINE;
    }

    public String getDefaultUseVnc() {
        return this.DEFAULT_USEVNC;
    }

    public long getWindowHandle(String windowName) {
        AndmoreLogger.debug((Object)this, (String)("Get native window handler for: " + windowName));
        long windowHandle = 0L;
        try {
            TCHAR className = null;
            TCHAR tChrTitle = new TCHAR(0, windowName, true);
            windowHandle = OS.FindWindow(className, (TCHAR)tChrTitle);
        }
        catch (Throwable t) {
            AndmoreLogger.error(this.getClass(), (String)("Failed to retrieve window handler for window " + windowName), (Throwable)t);
        }
        return windowHandle;
    }

    public long getWindowProperties(long windowHandle) {
        long windowLong = OS.GetWindowLong((int)((int)windowHandle), (int)-16);
        return windowLong;
    }

    public void setWindowProperties(long windowHandle, long originalProperties) {
        OS.SetWindowLong((int)((int)windowHandle), (int)-16, (int)((int)originalProperties));
    }

    public long embedWindow(long windowHandle, Composite composite) {
        OS.SetWindowPos((int)((int)windowHandle), (int)0, (int)0, (int)0, (int)0, (int)0, (int)64);
        long originalParent = OS.SetParent((int)((int)windowHandle), (int)composite.handle);
        return originalParent;
    }

    public void unembedWindow(long windowHandle, long originalParent) {
        OS.SetParent((int)((int)windowHandle), (int)((int)originalParent));
    }

    public Point getWindowSize(long originalParentHandle, long windowHandle) {
        RECT rect = new RECT();
        OS.GetClientRect((int)((int)windowHandle), (RECT)rect);
        return new Point(rect.right, rect.bottom);
    }

    public void setWindowStyle(long windowHandle) {
        OS.SetWindowLong((int)((int)windowHandle), (int)-16, (int)0x16000000);
    }

    public void hideWindow(long windowHandle) {
        OS.ShowWindow((int)((int)windowHandle), (int)0);
    }

    public void showWindow(long windowHandle) {
        OS.ShowWindow((int)((int)windowHandle), (int)5);
    }

    public void restoreWindow(long windowHandle) {
        OS.ShowWindow((int)((int)windowHandle), (int)2);
        OS.ShowWindow((int)((int)windowHandle), (int)OS.SW_RESTORE);
    }

    public void sendNextLayoutCommand(long originalParent, long windowHandle) {
        OS.SendMessage((int)((int)windowHandle), (int)256, (int)17, (int)0);
        OS.SendMessage((int)((int)windowHandle), (int)256, (int)123, (int)0);
        OS.SendMessage((int)((int)windowHandle), (int)257, (int)17, (int)0);
        OS.SendMessage((int)((int)windowHandle), (int)257, (int)123, (int)0);
    }

    public boolean isWindowEnabled(long windowHandle) {
        long getFocus = OS.GetForegroundWindow();
        return windowHandle == getFocus;
    }

    public void setWindowFocus(long windowHandle) {
        OS.SetForegroundWindow((int)((int)windowHandle));
    }
}

