/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.commands.DeleteColumnCommand;
import org.eclipse.birt.report.designer.core.commands.DeleteRowCommand;
import org.eclipse.birt.report.designer.core.model.IDropValidator;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.ScriptObjectNode;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.StructuredSelection;

public class DeleteCommand
extends Command {
    protected static final Logger logger = Logger.getLogger(DeleteCommand.class.getName());
    private Object model = null;
    private ArrayList embeddedImageList = new ArrayList();
    private boolean isClear = true;

    public boolean isClear() {
        return this.isClear;
    }

    public void setClear(boolean isClear) {
        this.isClear = isClear;
    }

    public DeleteCommand(Object model) {
        this.model = model;
    }

    public void execute() {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("DeleteCommand >> Starts ... ");
        }
        try {
            this.dropSource(this.model);
            if (!this.embeddedImageList.isEmpty()) {
                int i = 0;
                while (i < this.embeddedImageList.size()) {
                    IStructure item = ((EmbeddedImageHandle)this.embeddedImageList.get(i)).getStructure();
                    String name = ((EmbeddedImageHandle)this.embeddedImageList.get(i)).getName();
                    SessionHandleAdapter.getInstance().getReportDesignHandle().getPropertyHandle("images").removeItem((Object)item);
                    if (DesignerConstants.TRACING_COMMANDS) {
                        System.out.println("DeleteCommand >> Dropping embedded image " + item.getStructName());
                    }
                    String key = ImageManager.getInstance().generateKey(SessionHandleAdapter.getInstance().getReportDesignHandle(), name);
                    ImageManager.getInstance().removeCachedImage(key);
                    ++i;
                }
            }
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("DeleteCommand >> Finished. ");
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("DeleteCommand >> Failed. ");
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void dropSource(Object source) throws SemanticException {
        if ((source = DNDUtil.unwrapToModel(source)) instanceof Object[]) {
            Object[] array = (Object[])source;
            int i = 0;
            while (i < array.length) {
                this.dropSource(array[i]);
                ++i;
            }
        } else if (source instanceof StructuredSelection) {
            this.dropSource(((StructuredSelection)source).toArray());
        } else if (source instanceof DesignElementHandle) {
            this.dropSourceElementHandle((DesignElementHandle)source);
        } else if (source instanceof EmbeddedImageHandle) {
            this.dropEmbeddedImageHandle((EmbeddedImageHandle)source);
        } else if (source instanceof SlotHandle) {
            this.dropSourceSlotHandle((SlotHandle)source);
        } else if (source instanceof CssStyleSheetHandle) {
            this.dropCssStyleHandle((CssStyleSheetHandle)source);
        } else if (source instanceof ScriptObjectNode) {
            ((ScriptObjectNode)source).reset();
        }
    }

    private void dropEmbeddedImageHandle(EmbeddedImageHandle embeddedImage) {
        this.embeddedImageList.add(embeddedImage);
    }

    protected void dropSourceElementHandle(DesignElementHandle handle) throws SemanticException {
        if (handle.getContainer() != null) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("DeleteCommand >> Dropping " + DEUtil.getDisplayLabel(handle));
            }
            if (handle instanceof ExtendedItemHandle && this.isExtendedCell((ExtendedItemHandle)handle)) {
                ExtendedItemHandle extendedHandle = (ExtendedItemHandle)handle;
                List list = extendedHandle.getContents(DEUtil.getDefaultContentName(handle));
                int i = 0;
                while (i < list.size()) {
                    this.dropSourceElementHandle((DesignElementHandle)list.get(i));
                    ++i;
                }
            } else if (handle instanceof CellHandle) {
                this.dropSourceSlotHandle(((CellHandle)handle).getContent());
            } else if (handle instanceof RowHandle) {
                new DeleteRowCommand(handle).execute();
            } else if (handle instanceof ColumnHandle) {
                new DeleteColumnCommand(handle).execute();
            } else if (this.isClear()) {
                handle.dropAndClear();
            } else {
                handle.drop();
            }
        }
    }

    private boolean isExtendedCell(ExtendedItemHandle handle) {
        return handle.getExtensionName().indexOf("Cell") > -1;
    }

    protected void dropSourceSlotHandle(SlotHandle slot) throws SemanticException {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("DeleteCommand >> Dropping slot " + slot.getSlotID() + " of " + DEUtil.getDisplayLabel(slot.getElementHandle()));
        }
        List list = slot.getContents();
        int i = 0;
        while (i < list.size()) {
            this.dropSourceElementHandle((DesignElementHandle)list.get(i));
            ++i;
        }
    }

    protected void dropCssStyleHandle(CssStyleSheetHandle cssStyleHandle) throws SemanticException {
        AbstractThemeHandle theme;
        DesignElementHandle containerHandle;
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("DeleteCommand >> Dropping " + DEUtil.getDisplayLabel(cssStyleHandle.getElementHandle()));
        }
        if ((containerHandle = cssStyleHandle.getContainerHandle()) instanceof ReportDesignHandle) {
            ReportDesignHandle report = (ReportDesignHandle)containerHandle;
            if (report.canDropCssStyleSheet(cssStyleHandle)) {
                report.dropCss(cssStyleHandle);
            }
        } else if (containerHandle instanceof AbstractThemeHandle && (theme = (AbstractThemeHandle)containerHandle).canDropCssStyleSheet(cssStyleHandle)) {
            theme.dropCss(cssStyleHandle);
        }
    }

    public boolean canExecute() {
        return this.canDrop(this.model);
    }

    protected boolean canDrop(Object source) {
        Object dropValidator;
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() == null) {
            return false;
        }
        if (source == null) {
            return false;
        }
        if (source instanceof List) {
            return this.canDrop(((List)source).toArray());
        }
        if (source instanceof StructuredSelection) {
            return this.canDrop(((StructuredSelection)source).toArray());
        }
        if (source instanceof Object[]) {
            Object[] array = (Object[])source;
            if (array.length == 0) {
                return false;
            }
            int i = 0;
            while (i < array.length) {
                if (!DNDUtil.checkContainerExists(array[i], array)) {
                    if (array[i] instanceof MasterPageHandle) {
                        int masterPageCount = SessionHandleAdapter.getInstance().getReportDesignHandle().getMasterPages().getCount();
                        int j = 0;
                        while (j < array.length) {
                            if (array[j] instanceof MasterPageHandle) {
                                --masterPageCount;
                            }
                            ++j;
                        }
                        if (masterPageCount == 0) {
                            return false;
                        }
                    }
                    if (!this.canDrop(array[i])) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        if ((source = DNDUtil.unwrapToModel(source)) instanceof SlotHandle) {
            SlotHandle slot = (SlotHandle)source;
            DesignElementHandle handle = slot.getElementHandle();
            return slot.getContents().size() > 0 && handle != null && handle.canDrop() && this.canDrop(slot.getContents());
        }
        if (source instanceof EmbeddedImageHandle) {
            return true;
        }
        if (source instanceof ExtendedItemHandle && (dropValidator = Platform.getAdapterManager().getAdapter((Object)((ExtendedItemHandle)source), DeleteCommand.class)) instanceof IDropValidator && ((IDropValidator)dropValidator).accpetValidator()) {
            return ((IDropValidator)dropValidator).canDrop();
        }
        if (source instanceof CellHandle) {
            return ((CellHandle)source).getContent().getContents().size() > 0 && ((CellHandle)source).canDrop();
        }
        if (source instanceof MasterPageHandle) {
            return SessionHandleAdapter.getInstance().getReportDesignHandle().getMasterPages().getCount() > 1;
        }
        if (source instanceof ModuleHandle) {
            return false;
        }
        if (source instanceof DesignElementHandle) {
            return ((DesignElementHandle)source).canDrop();
        }
        if (source instanceof LibraryHandle) {
            return ((LibraryHandle)source).getHostHandle() != null;
        }
        if (source instanceof CssStyleSheetHandle) {
            DesignElementHandle elementHandle = ((CssStyleSheetHandle)source).getContainerHandle();
            if (elementHandle instanceof ReportDesignHandle) {
                return ((ReportDesignHandle)elementHandle).canDropCssStyleSheet((CssStyleSheetHandle)source);
            }
            if (elementHandle instanceof AbstractThemeHandle) {
                return ((AbstractThemeHandle)elementHandle).canDropCssStyleSheet((CssStyleSheetHandle)source);
            }
            return false;
        }
        return source instanceof ScriptObjectNode;
    }
}

