/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import java.awt.Color;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public final class ColorManager {
    public static org.eclipse.swt.graphics.Color getColor(int c) {
        RGB rgb = DEUtil.getRGBValue(c);
        return ColorManager.getColor(rgb);
    }

    public static org.eclipse.swt.graphics.Color getColor(int red, int green, int blue) {
        return ColorManager.getColor(new RGB(red, green, blue));
    }

    public static org.eclipse.swt.graphics.Color getColor(String id, RGB defaultRGB) {
        ColorRegistry registry = null;
        if (PlatformUI.isWorkbenchRunning()) {
            registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        }
        RGB rgb = ColorManager.findRGB(registry, id, defaultRGB);
        return ColorManager.getColor(rgb);
    }

    private static RGB findRGB(ColorRegistry registry, String key, RGB defaultRGB) {
        if (registry == null) {
            return defaultRGB;
        }
        RGB rgb = registry.getRGB(key);
        if (rgb != null) {
            return rgb;
        }
        return defaultRGB;
    }

    public static org.eclipse.swt.graphics.Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String key = rgb.toString();
        org.eclipse.swt.graphics.Color color = JFaceResources.getColorRegistry().get(key);
        if (color == null) {
            JFaceResources.getColorRegistry().put(key, rgb);
            color = JFaceResources.getColorRegistry().get(key);
        }
        return color;
    }

    public static org.eclipse.swt.graphics.Color darker(org.eclipse.swt.graphics.Color c) {
        if (c == null) {
            return null;
        }
        Color color = new Color(c.getRed(), c.getGreen(), c.getBlue());
        color = color.darker();
        return ColorManager.getColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static org.eclipse.swt.graphics.Color brighter(org.eclipse.swt.graphics.Color c) {
        if (c == null) {
            return null;
        }
        Color color = new Color(c.getRed(), c.getGreen(), c.getBlue());
        color = color.brighter();
        return ColorManager.getColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static org.eclipse.swt.graphics.Color brighter(org.eclipse.swt.graphics.Color origColor, org.eclipse.swt.graphics.Color brightColor) {
        return ColorManager.getColor((origColor.getRed() + brightColor.getRed()) / 2, (origColor.getGreen() + brightColor.getGreen()) / 2, (origColor.getBlue() + brightColor.getBlue()) / 2);
    }

    public static org.eclipse.swt.graphics.Color darker(org.eclipse.swt.graphics.Color origColor, org.eclipse.swt.graphics.Color darkColor) {
        double redFactor = (double)darkColor.getRed() / 255.0;
        double greenFactor = (double)darkColor.getGreen() / 255.0;
        double blueFactor = (double)darkColor.getBlue() / 255.0;
        return ColorManager.getColor(Math.max((int)((double)origColor.getRed() * redFactor), 0), Math.max((int)((double)origColor.getGreen() * greenFactor), 0), Math.max((int)((double)origColor.getBlue() * blueFactor), 0));
    }
}

