/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WIDException;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WIDParser;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WorkItemDefinition;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WorkItemDefinitionImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public class WIDLoader {
    private static final int BUFFER_SIZE = 1024;
    private static final String WID_FOLDER = "/src/main/resources/META-INF";
    private static final String ICONS_FOLDER = "/src/main/resources/icons";
    private HashMap<String, WorkItemDefinition> projectWIDs = new HashMap();
    private HashMap<String, ImageDescriptor> projectIcons = new HashMap();
    private HashMap<String, WorkItemDefinition> classpathWIDs = new HashMap();
    private HashMap<String, ImageDescriptor> classpathIcons = new HashMap();

    public void load(IProject project) throws CoreException {
        WIDVisitor visitor = new WIDVisitor();
        project.accept((IResourceVisitor)visitor, 2, false);
    }

    public HashMap<String, WorkItemDefinition> getProjectWIDs() {
        return this.projectWIDs;
    }

    public HashMap<String, WorkItemDefinition> getClasspathWIDs() {
        return this.classpathWIDs;
    }

    public HashMap<String, ImageDescriptor> getProjectIcons() {
        return this.projectIcons;
    }

    public HashMap<String, ImageDescriptor> getClasspathIcons() {
        return this.classpathIcons;
    }

    private void getProjectFileWIDs(IFile file) throws CoreException, IOException, WIDException {
        InputStream is = file.getContents();
        String content = WIDLoader.inputStreamToString(is, null);
        HashMap<String, WorkItemDefinition> widMap = WIDParser.parse(content);
        for (WorkItemDefinition wid : widMap.values()) {
            String icon = wid.getIcon();
            if (icon == null || icon.isEmpty()) continue;
            this.getProjectFileIcon(file, icon);
            ((WorkItemDefinitionImpl)wid).setDefinitionFile(file.getFullPath().toFile());
        }
        this.projectWIDs.putAll(widMap);
    }

    private void getProjectFileIcon(IFile file, String icon) throws CoreException, IOException {
        IProject project = file.getProject();
        IFile iconFile = project.getFile((IPath)new Path("/src/main/resources/icons/" + icon));
        InputStream is = null;
        try {
            if (iconFile.exists() && (is = iconFile.getContents()) != null) {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromImageData((ImageData)new ImageData(is));
                this.projectIcons.put(icon, imageDescriptor);
                is.close();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void getJarFileWIDs(File jarFile) throws IOException, WIDException {
        JarFile jar = new JarFile(jarFile);
        InputStream is = null;
        try {
            Enumeration<JarEntry> enumEntries = jar.entries();
            while (enumEntries.hasMoreElements()) {
                String name;
                JarEntry entry = enumEntries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).endsWith(".wid") || (is = jar.getInputStream(entry)) == null) continue;
                String content = WIDLoader.inputStreamToString(is, null);
                HashMap<String, WorkItemDefinition> widMap = WIDParser.parse(content);
                for (WorkItemDefinition wid : widMap.values()) {
                    String icon = wid.getIcon();
                    this.getJarFileIcon(jar, icon);
                    ((WorkItemDefinitionImpl)wid).setDefinitionFile(jarFile.getAbsoluteFile());
                }
                this.classpathWIDs.putAll(widMap);
                is.close();
            }
        }
        finally {
            jar.close();
            if (is != null) {
                is.close();
            }
        }
    }

    private void getJarFileIcon(JarFile jar, String icon) throws IOException {
        ImageDescriptor imageDescriptor = null;
        if (icon != null && !icon.isEmpty() && !this.classpathIcons.containsKey(icon)) {
            InputStream is = null;
            try {
                Enumeration<JarEntry> enumEntries = jar.entries();
                while (enumEntries.hasMoreElements()) {
                    String name;
                    JarEntry entry = enumEntries.nextElement();
                    if (entry.isDirectory() || !icon.equals(name = entry.getName())) continue;
                    is = jar.getInputStream(entry);
                    if (is != null) {
                        imageDescriptor = ImageDescriptor.createFromImageData((ImageData)new ImageData(is));
                        this.classpathIcons.put(icon, imageDescriptor);
                        is.close();
                    }
                    break;
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    private IJavaProject getJavaProject(IProject project) throws IOException {
        if (project != null) {
            try {
                IJavaProject javaProject;
                if (project.getNature("org.eclipse.jdt.core.javanature") != null && (javaProject = JavaCore.create((IProject)project)).exists()) {
                    return javaProject;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String inputStreamToString(InputStream inputStream, Charset charset) throws IOException {
        int length;
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        char[] buffer = new char[1024];
        while ((length = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, length);
        }
        return builder.toString();
    }

    private class WIDVisitor
    implements IResourceVisitor {
        private WIDVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            block12: {
                block11: {
                    if (resource.getType() != 1) break block11;
                    if ("wid".equalsIgnoreCase(((IFile)resource).getFileExtension())) {
                        String folder = resource.getParent().getFullPath().toString();
                        IProject project = resource.getProject();
                        if ((String.valueOf(project.getFullPath().toString()) + WIDLoader.WID_FOLDER).equals(folder)) {
                            WIDLoader.this.getProjectFileWIDs((IFile)resource);
                        }
                        return true;
                    }
                }
                if (resource.getType() != 4) break block12;
                IProject project = (IProject)resource;
                IJavaProject javaProject = WIDLoader.this.getJavaProject(project);
                if (javaProject != null) {
                    IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry e = iClasspathEntryArray[n2];
                        if (e.getEntryKind() == 1) {
                            IPath path = e.getPath();
                            String name = null;
                            name = path.getDevice() != null ? e.getPath().toOSString() : project.getLocation().removeLastSegments(1).append(e.getPath()).toOSString();
                            File jarFile = new File(name);
                            WIDLoader.this.getJarFileWIDs(jarFile);
                        }
                        ++n2;
                    }
                }
                return true;
            }
            try {
                String name;
                if (resource.getType() == 2 && ("bin".equals(name = resource.getName()) || "target".equals(name))) {
                    return false;
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (WIDException e2) {
                e2.printStackTrace();
            }
            return true;
        }
    }
}

