/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.datatype.DataType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.datatype.DataTypeFactory;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.datatype.DataTypeRegistry;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WIDException;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WorkItemDefinition;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wid.WorkItemDefinitionImpl;

public class WIDParser {
    public static HashMap<String, WorkItemDefinition> parse(String content) throws WIDException {
        LinkedHashMap<String, WorkItemDefinition> widMap = new LinkedHashMap<String, WorkItemDefinition>();
        if (content == null) {
            WIDException widException = new WIDException("No data passed to WIDHandler.processWorkDefinitionsContent method");
            throw widException;
        }
        if (widMap != null) {
            ((HashMap)widMap).clear();
        }
        String[] strings = content.split("[\n]+");
        int openBrackets = 0;
        WorkItemDefinitionImpl currentWid = new WorkItemDefinitionImpl();
        Section current = Section.PARAMETERS;
        int i = 0;
        while (i < strings.length) {
            String trim = strings[i].trim();
            if (trim.length() != 0) {
                String name;
                String[] nameValue;
                if (trim.startsWith("[") || trim.endsWith("[") || trim.endsWith(":")) {
                    if (trim.endsWith(":") && i < strings.length - 1) {
                        trim = String.valueOf(strings[i].trim()) + strings[i + 1].trim();
                    } else {
                        ++openBrackets;
                    }
                    nameValue = trim.split("[:]+");
                    if (nameValue.length == 2) {
                        name = nameValue[0].replace('\"', ' ').trim();
                        if (name.equalsIgnoreCase("parameters")) {
                            current = Section.PARAMETERS;
                        } else if (name.equalsIgnoreCase("results")) {
                            current = Section.RESULTS;
                        } else if (name.equalsIgnoreCase("dependencies")) {
                            current = Section.DEPENDENCIES;
                        }
                    }
                }
                if ((trim.startsWith("]") || trim.endsWith("]")) && --openBrackets == 1) {
                    if (currentWid != null && currentWid.getName() != null) {
                        widMap.put(currentWid.getName(), currentWid);
                    }
                    currentWid = new WorkItemDefinitionImpl();
                }
                if (trim.contains(":") && ((nameValue = trim.split("[:]+")).length == 2 || nameValue.length == 3)) {
                    name = nameValue[0].replace('\"', ' ').trim();
                    int valueIndex = 1;
                    if (nameValue.length == 3) {
                        valueIndex = 2;
                        name = String.valueOf(name) + ':' + nameValue[1].replace('\"', ' ').trim();
                    }
                    String value = nameValue[valueIndex].replace('\"', ' ').replace(',', ' ').replace('[', ' ').trim();
                    if (openBrackets == 2 && value.trim().length() > 0) {
                        if (name.equalsIgnoreCase("name")) {
                            currentWid.setName(value);
                        } else if (name.equalsIgnoreCase("displayName")) {
                            currentWid.setDispalyName(value);
                        } else if (name.equalsIgnoreCase("description")) {
                            currentWid.setDescription(value);
                        } else if (name.equalsIgnoreCase("category")) {
                            currentWid.setCategory(value);
                        } else if (name.equalsIgnoreCase("icon")) {
                            currentWid.setIcon(value);
                        } else if (name.equalsIgnoreCase("customEditor")) {
                            currentWid.setCustomEditor(value);
                        } else if (name.equalsIgnoreCase("eclipse:customEditor")) {
                            currentWid.setEclipseCustomEditor(value);
                        }
                    } else if (openBrackets == 3 && value.trim().length() > 0) {
                        int index;
                        DataTypeFactory dtf;
                        if (value.startsWith("new") && value.indexOf("(") > 0 && (dtf = DataTypeRegistry.getFactory(value = value.substring(3, index = value.indexOf("(")).trim())) != null) {
                            DataType dt = dtf.createDataType();
                            value = dt.getStringType();
                        }
                        if (current == Section.PARAMETERS) {
                            currentWid.getParameters().put(name, value);
                        } else if (current == Section.RESULTS) {
                            currentWid.getResults().put(name, value);
                        }
                    }
                }
            }
            ++i;
        }
        return widMap;
    }

    public static enum Section {
        PARAMETERS,
        RESULTS,
        DEPENDENCIES;

    }
}

