/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import ch.ethz.iks.r_osgi.RemoteOSGiService;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.ExtensionRegistryRunnable;
import org.eclipse.ecf.internal.provider.r_osgi.R_OSGiContainerInstantiator;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiRemoteServiceNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSSNamespace;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public final class Activator
implements BundleActivator {
    public static final String CONSUMER_SYNC_EXECUTOR_TYPE = "org.eclipse.ecf.provider.r_osgi.consumerExecutor";
    private static final boolean DELETE_PROXY_BUNDLES_ON_INIT = new Boolean(System.getProperty("ch.ethz.iks.r_osgi.deleteProxyBundlesOnInit", "true"));
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.r_osgi";
    static Activator plugin;
    private BundleContext context;
    private ServiceTracker r_osgi_tracker;
    private ServiceTracker executorServiceTracker;
    private final Object executorServiceTrackerLock = new Object();

    public Activator() {
        plugin = this;
    }

    public void start(final BundleContext bc) throws Exception {
        this.context = bc;
        this.r_osgi_tracker = new ServiceTracker(this.context, RemoteOSGiService.class.getName(), null);
        this.r_osgi_tracker.open();
        if (DELETE_PROXY_BUNDLES_ON_INIT) {
            this.deleteProxyBundles();
        }
        SafeRunner.run((ISafeRunnable)new ExtensionRegistryRunnable(bc){

            protected void runWithoutRegistry() throws Exception {
                bc.registerService(Namespace.class, (Object)new R_OSGiNamespace(), null);
                bc.registerService(Namespace.class, (Object)new R_OSGiWSNamespace(), null);
                bc.registerService(Namespace.class, (Object)new R_OSGiWSSNamespace(), null);
                bc.registerService(Namespace.class, (Object)new R_OSGiRemoteServiceNamespace(), null);
                bc.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.r_osgi.peer", (IContainerInstantiator)new R_OSGiContainerInstantiator(), "R_OSGi Container", true, false), null);
                bc.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.r_osgi.peer.ws", (IContainerInstantiator)new R_OSGiContainerInstantiator(), "R_OSGi Websockets Container", true, false), null);
                bc.registerService(ContainerTypeDescription.class, (Object)new ContainerTypeDescription("ecf.r_osgi.peer.wss", (IContainerInstantiator)new R_OSGiContainerInstantiator(), "R_OSGi Secure Websockets Container", true, false), null);
            }
        });
    }

    private void deleteProxyBundles() {
        Bundle[] bundles = this.context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            Bundle b = bundles[i];
            String bName = b.getSymbolicName();
            if (bName.startsWith("R-OSGi Proxy Bundle generated for Endpoint")) {
                try {
                    b.uninstall();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bc) throws Exception {
        this.r_osgi_tracker.close();
        this.r_osgi_tracker = null;
        Object object = this.executorServiceTrackerLock;
        synchronized (object) {
            if (this.executorServiceTracker != null) {
                this.executorServiceTracker.close();
                this.executorServiceTracker = null;
            }
        }
        this.context = null;
        plugin = null;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public RemoteOSGiService getRemoteOSGiService() {
        if (this.r_osgi_tracker == null) {
            return null;
        }
        return (RemoteOSGiService)this.r_osgi_tracker.getService();
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    private Filter createExecutorFilter(boolean sync) {
        try {
            return this.getContext().createFilter("(&(objectClass=" + IExecutor.class.getName() + ")(" + CONSUMER_SYNC_EXECUTOR_TYPE + "=" + (sync ? "sync" : "async") + "))");
        }
        catch (InvalidSyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutor getExecutor(boolean sync) {
        Object object = this.executorServiceTrackerLock;
        synchronized (object) {
            if (this.executorServiceTracker == null) {
                Filter syncExecutorFilter = this.createExecutorFilter(sync);
                this.executorServiceTracker = new ServiceTracker(this.getContext(), syncExecutorFilter, null);
                this.executorServiceTracker.open();
            }
        }
        return (IExecutor)this.executorServiceTracker.getService();
    }
}

