/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.api.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFRuleAuditDescription;
import org.eclipse.eef.EEFValidationRuleDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFController;
import org.eclipse.eef.core.api.controllers.IValidationRuleResult;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.core.internal.controllers.InvalidValidationRuleResult;
import org.eclipse.eef.core.internal.controllers.ValidationRuleResult;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public abstract class AbstractEEFController
implements IEEFController {
    protected IInterpreter interpreter;
    protected IVariableManager variableManager;
    private IConsumer<List<IValidationRuleResult>> validationConsumer;

    public AbstractEEFController(IVariableManager variableManager, IInterpreter interpreter) {
        this.variableManager = variableManager;
        this.interpreter = interpreter;
    }

    protected EvalFactory.Eval<Object> newEval() {
        return EvalFactory.of(this.interpreter, this.variableManager);
    }

    @Override
    public void onValidation(IConsumer<List<IValidationRuleResult>> consumer) {
        this.validationConsumer = consumer;
    }

    @Override
    public void removeValidationConsumer() {
        this.validationConsumer = null;
    }

    @Override
    public void refresh() {
        List<IValidationRuleResult> validationRuleResults = this.getValidationRuleResults(this.getValidationRulesContainer(), this.getValidationRulesReference());
        if (this.validationConsumer != null) {
            this.validationConsumer.apply(validationRuleResults);
        }
    }

    protected abstract EObject getValidationRulesContainer();

    protected abstract EReference getValidationRulesReference();

    private List<IValidationRuleResult> getValidationRuleResults(EObject eObject, EReference validationRulesReference) {
        ArrayList<IValidationRuleResult> validationRuleResults = new ArrayList<IValidationRuleResult>();
        ArrayList<EEFValidationRuleDescription> descriptions = new ArrayList<EEFValidationRuleDescription>();
        Object validationRules = eObject.eGet((EStructuralFeature)validationRulesReference);
        if (validationRules instanceof Iterable) {
            for (Object validationRule : (Iterable)validationRules) {
                if (!(validationRule instanceof EEFValidationRuleDescription)) continue;
                descriptions.add((EEFValidationRuleDescription)validationRule);
            }
        }
        EAttribute auditEAttribute = EefPackage.Literals.EEF_RULE_AUDIT_DESCRIPTION__AUDIT_EXPRESSION;
        EAttribute messageEAttribute = EefPackage.Literals.EEF_VALIDATION_RULE_DESCRIPTION__MESSAGE_EXPRESSION;
        for (EEFValidationRuleDescription validationRule : descriptions) {
            Object result = null;
            for (EEFRuleAuditDescription audit : validationRule.getAudits()) {
                String auditExpression = audit.getAuditExpression();
                result = this.newEval().logIfBlank(auditEAttribute).evaluate(auditExpression);
                if (!this.isValid(result)) break;
            }
            if (this.isValid(result)) {
                validationRuleResults.add(new ValidationRuleResult(validationRule));
                continue;
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            variables.put("auditResult", result);
            EvalFactory.Eval<Object> eval = EvalFactory.of(this.interpreter, variables);
            String message = eval.logIfBlank(messageEAttribute).logIfInvalidType(String.class).evaluate(validationRule.getMessageExpression());
            validationRuleResults.add(new InvalidValidationRuleResult(validationRule, message, eval, validationRule.getSeverity().getValue()));
        }
        return validationRuleResults;
    }

    private boolean isValid(Object result) {
        boolean isValid = false;
        if (result instanceof Boolean) {
            isValid = (Boolean)result;
        } else if (result instanceof IStatus) {
            isValid = ((IStatus)result).isOK();
        } else if (result instanceof Diagnostic) {
            isValid = ((Diagnostic)result).getSeverity() == 0;
        }
        return isValid;
    }
}

