/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.api.utils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.internal.EEFCorePlugin;
import org.eclipse.eef.core.internal.Messages;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public final class EvalFactory {
    private EvalFactory() {
    }

    public static Eval<Object> of(IInterpreter interpreter, Map<String, Object> variables) {
        return new Eval<Object>(interpreter, variables, Object.class);
    }

    public static Eval<Object> of(IInterpreter interpreter, IVariableManager variableManager) {
        return new Eval<Object>(interpreter, variableManager, Object.class);
    }

    public static final class Eval<TYPE> {
        private IInterpreter interpreter;
        private Map<String, Object> variables = new HashMap<String, Object>();
        private EAttribute eAttribute;
        private TYPE defaultValue;
        private Class<TYPE> type;

        private Eval(IInterpreter interpreter, Map<String, Object> variables, Class<TYPE> type) {
            this.interpreter = interpreter;
            this.variables.putAll(variables);
            this.type = type;
        }

        private Eval(IInterpreter interpreter, IVariableManager variableManager, Class<TYPE> type) {
            this(interpreter, variableManager.getVariables(), type);
        }

        public Eval<TYPE> logIfBlank(EAttribute attribute) {
            this.eAttribute = attribute;
            return this;
        }

        public <E> Eval<E> logIfInvalidType(Class<E> expectedType) {
            TYPE value = null;
            if (expectedType.isInstance(this.defaultValue)) {
                value = (TYPE)expectedType.cast(this.defaultValue);
            }
            return new Eval<E>(this.interpreter, this.variables, expectedType).logIfBlank(this.eAttribute).defaultValue(value);
        }

        public Eval<TYPE> defaultValue(TYPE value) {
            this.defaultValue = value;
            return this;
        }

        public void call(String expression) {
            this.call(expression, null);
        }

        public void call(String expression, IConsumer<TYPE> consumer) {
            if (Util.isBlank((String)expression)) {
                if (this.eAttribute != null && EEFCorePlugin.getPlugin() != null) {
                    EEFCorePlugin.getPlugin().blank(this.eAttribute);
                }
                if (this.defaultValue != null && consumer != null) {
                    consumer.apply(this.defaultValue);
                }
                return;
            }
            IEvaluationResult evaluationResult = this.interpreter.evaluateExpression(this.variables, expression);
            if (evaluationResult.success()) {
                if (consumer != null) {
                    TYPE returnValue = this.defaultValue;
                    Object value = evaluationResult.getValue();
                    if (value != null && this.type.isInstance(value)) {
                        returnValue = this.type.cast(value);
                    } else if (value != null && EEFCorePlugin.getPlugin() != null) {
                        String message = MessageFormat.format(Messages.AbstractEEFWidgetController_InvalidValueForExpression, expression, this.type.getName(), value);
                        EEFCorePlugin.getPlugin().error(message);
                    }
                    consumer.apply(returnValue);
                }
            } else if (EEFCorePlugin.getPlugin() != null) {
                EEFCorePlugin.getPlugin().diagnostic(expression, evaluationResult.getDiagnostic());
            }
        }

        public TYPE evaluate(String expression) {
            if (Util.isBlank((String)expression)) {
                if (this.eAttribute != null && EEFCorePlugin.getPlugin() != null) {
                    EEFCorePlugin.getPlugin().blank(this.eAttribute);
                }
                return this.defaultValue;
            }
            TYPE result = this.defaultValue;
            IEvaluationResult evaluationResult = this.interpreter.evaluateExpression(this.variables, expression);
            if (evaluationResult.success()) {
                Object value = evaluationResult.getValue();
                if (value != null && this.type.isInstance(value)) {
                    TYPE castValue = this.type.cast(value);
                    result = castValue;
                } else if (value != null && EEFCorePlugin.getPlugin() != null) {
                    String message = MessageFormat.format(Messages.AbstractEEFWidgetController_InvalidValueForExpression, expression, this.type.getName(), value);
                    EEFCorePlugin.getPlugin().error(message);
                }
            } else if (EEFCorePlugin.getPlugin() != null) {
                EEFCorePlugin.getPlugin().diagnostic(expression, evaluationResult.getDiagnostic());
            }
            return result;
        }
    }
}

