/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFPageDescription;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EEFGroup;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.IEEFDomainClassTester;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.core.internal.DomainClassPredicate;
import org.eclipse.eef.core.internal.EEFCorePlugin;
import org.eclipse.eef.core.internal.EEFGroupImpl;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFPageImpl
implements EEFPage {
    private IVariableManager variableManager;
    private IInterpreter interpreter;
    private EEFView eefView;
    private EEFPageDescription eefPageDescription;
    private List<EEFGroup> eefGroups = new ArrayList<EEFGroup>();
    private IEEFDomainClassTester domainClassTester;
    private boolean isUnique;

    public EEFPageImpl(EEFView eefView, EEFPageDescription eefPageDescription, IVariableManager variableManager, IInterpreter interpreter, IEEFDomainClassTester domainClassTester, boolean isUnique) {
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.eefView = eefView;
        this.eefPageDescription = eefPageDescription;
        this.domainClassTester = domainClassTester;
        this.isUnique = isUnique;
    }

    public void initialize() {
        EEFCorePlugin.getPlugin().debug("EEFPageImpl#initialize()");
        for (final EEFGroupDescription eefGroupDescription : this.eefPageDescription.getGroups()) {
            String preconditionExpression = eefGroupDescription.getPreconditionExpression();
            Boolean preconditionValid = EvalFactory.of(this.interpreter, this.variableManager).logIfInvalidType(Boolean.class).evaluate(preconditionExpression);
            if (preconditionValid != null && !preconditionValid.booleanValue()) continue;
            IConsumer<Object> consumer = new IConsumer<Object>(){

                @Override
                public void apply(Object value) {
                    DomainClassPredicate domainClassPredicate = new DomainClassPredicate(eefGroupDescription.getDomainClass(), EEFPageImpl.this.domainClassTester);
                    Iterable iterable = Util.asIterable((Object)value, Object.class);
                    Iterable objects = Iterables.filter((Iterable)iterable, (Predicate)domainClassPredicate);
                    for (Object object : objects) {
                        IVariableManager childVariableManager = EEFPageImpl.this.getVariableManager().createChild();
                        childVariableManager.put("self", object);
                        EEFGroupImpl eefGroupImpl = new EEFGroupImpl(EEFPageImpl.this, eefGroupDescription, childVariableManager, EEFPageImpl.this.interpreter);
                        EEFPageImpl.this.eefGroups.add(eefGroupImpl);
                    }
                }
            };
            Object self = this.variableManager.getVariables().get("self");
            String groupSemanticCandidateExpression = eefGroupDescription.getSemanticCandidateExpression();
            EvalFactory.of(this.interpreter, this.variableManager).defaultValue(self).call(groupSemanticCandidateExpression, consumer);
        }
    }

    @Override
    public List<EEFGroup> getGroups() {
        return this.eefGroups;
    }

    @Override
    public EEFPageDescription getDescription() {
        return this.eefPageDescription;
    }

    @Override
    public EEFView getView() {
        return this.eefView;
    }

    @Override
    public IVariableManager getVariableManager() {
        return this.variableManager;
    }

    @Override
    public IInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }
}

