/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.operations.GitScopeUtil;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DevelopReplaceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DiscardChangesOperation operation;
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        try {
            operation = this.createOperation(part, event);
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        if (operation == null) {
            return null;
        }
        WorkspaceJob job = new WorkspaceJob(UIText.DiscardChangesAction_discardChanges){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    operation.execute(monitor);
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus((String)e.getStatus().getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.DISCARD_CHANGES.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(operation.getSchedulingRule());
        job.schedule();
        return null;
    }

    @Nullable
    private DiscardChangesOperation createOperation(IWorkbenchPart part, ExecutionEvent event) throws ExecutionException, IOException {
        IResource[] resourcesInScope;
        String revision;
        IResource[] selectedResources = GitFlowHandlerUtil.gatherResourceToOperateOn(event);
        try {
            revision = GitFlowHandlerUtil.gatherRevision(event);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        try {
            resourcesInScope = GitScopeUtil.getRelatedChanges((IWorkbenchPart)part, (IResource[])selectedResources);
        }
        catch (InterruptedException e) {
            return null;
        }
        return new DiscardChangesOperation(resourcesInScope, revision);
    }
}

