/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.formatting;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.formatting.IContentFormatterFactory;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.formatting.FormattingPreferenceValues;
import org.eclipse.xtext.xbase.formatting.IBasicFormatter;
import org.eclipse.xtext.xbase.formatting.IFormattingPreferenceValuesProvider;
import org.eclipse.xtext.xbase.formatting.TextReplacement;

public class XcoreFormatterFactory
implements IContentFormatterFactory {
    @Inject
    private XcoreContentFormatter formatter;

    public IContentFormatter createConfiguredFormatter(SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        return this.formatter;
    }

    public static class XcoreContentFormatter
    implements IContentFormatter {
        @Inject
        protected IBasicFormatter formatter;
        @Inject
        private IFormattingPreferenceValuesProvider preferencesProvider;

        public void format(IDocument document, final IRegion region) {
            IXtextDocument xtextDocument = (IXtextDocument)document;
            TextEdit textEdit = (TextEdit)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<TextEdit, XtextResource>(){

                public TextEdit exec(XtextResource xtextResource) throws Exception {
                    IParseResult parseResult = xtextResource.getParseResult();
                    if (parseResult == null) {
                        return null;
                    }
                    IPreferenceValues configuration = XcoreContentFormatter.this.preferencesProvider.getPreferenceValues((Resource)xtextResource);
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    try {
                        List edits = XcoreContentFormatter.this.formatter.format(xtextResource, region.getOffset(), region.getLength(), new FormattingPreferenceValues(configuration));
                        for (TextReplacement replacement : edits) {
                            multiTextEdit.addChild((TextEdit)new ReplaceEdit(replacement.getOffset(), replacement.getLength(), replacement.getText()));
                        }
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return multiTextEdit;
                }
            });
            try {
                if (textEdit != null) {
                    textEdit.apply(document);
                }
            }
            catch (BadLocationException exception) {
                throw new RuntimeException(exception);
            }
        }

        public IFormattingStrategy getFormattingStrategy(String contentType) {
            return null;
        }
    }
}

