/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.wizard.pages;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectRepresentationDescriptionWizardPage
extends WizardPage
implements Supplier<RepresentationDescription> {
    private static final String PAGE_MESSAGE = "Select the type of representation to create.";
    private static final String PAGE_TITLE = "Select type of representation";
    private Browser browser;
    private Set<RepresentationDescription> descriptions;
    private Composite pageComposite;
    private Set<String> representationsURIsToActivateByDefault;
    private Supplier<Session> sessionSupplier;
    private TableViewer tableViewer;

    public SelectRepresentationDescriptionWizardPage(Supplier<Session> supplier, Collection<String> representationsToSelectByDefault) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.setMessage(PAGE_MESSAGE);
        this.sessionSupplier = supplier;
        this.descriptions = Sets.newLinkedHashSet();
        this.representationsURIsToActivateByDefault = Sets.newHashSet(representationsToSelectByDefault);
    }

    private StringBuilder appendCss(StringBuilder content) {
        Font currentFont = JFaceResources.getDialogFont();
        FontData data = currentFont.getFontData()[0];
        String fontName = data.getName();
        int fontHeight = data.getHeight() + 3;
        content.append("<style type=\"text/css\">");
        content.append("body{font-family:" + fontName + ",Arial, sans-serif;}");
        content.append("body{font-size:" + fontHeight + "px;}");
        content.append("</style>");
        return content;
    }

    private SelectRepresentationDescriptionWizardPage begin(StringBuilder content) {
        content.append("<html>");
        return this;
    }

    private SelectRepresentationDescriptionWizardPage body(StringBuilder content, RepresentationDescription repDescription) {
        content.append("<body>");
        if (repDescription == null) {
            content.append("<br><br><center><b>Documentation</b></center>");
        } else {
            String endUserDocumentation = repDescription.getDocumentation();
            if (!StringUtil.isEmpty((String)endUserDocumentation)) {
                content.append(repDescription.getEndUserDocumentation());
            } else {
                content.append("no documentation for this representation");
            }
        }
        content.append("</body>");
        return this;
    }

    private boolean containsHTMLDocumentation(RepresentationDescription description) {
        String doc;
        if (description != null && !StringUtil.isEmpty((String)(doc = description.getDocumentation()))) {
            return doc.startsWith("<html>");
        }
        return false;
    }

    private Browser createBrowser(Composite parent) {
        try {
            Browser aBrowser = new Browser(parent, 0);
            GridData gridData = new GridData(4, 4, true, true);
            aBrowser.setLayoutData((Object)gridData);
            return aBrowser;
        }
        catch (SWTError sWTError) {
            return null;
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).create());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.tableViewer = this.createTableViewer(this.pageComposite);
        this.browser = this.createBrowser(this.pageComposite);
        this.setBrowserInput(null);
        this.setControl((Control)this.pageComposite);
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewpointsTableLabelProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    SelectRepresentationDescriptionWizardPage.this.descriptions.clear();
                    Iterators.addAll((Collection)SelectRepresentationDescriptionWizardPage.this.descriptions, (Iterator)Iterators.filter((Iterator)((IStructuredSelection)event.getSelection()).iterator(), RepresentationDescription.class));
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof RepresentationDescription) {
                    SelectRepresentationDescriptionWizardPage.this.setBrowserInput((RepresentationDescription)firstElement);
                }
            }
        });
        return viewer;
    }

    private String end(StringBuilder content) {
        content.append("</html>");
        return content.toString();
    }

    private void extractUrlToRewrite(String document, Set<String> urlToRewrite) {
        int imgSrcStartIndex;
        int imgSrcStopIndex;
        String imgSrcPattern = "img src=\"";
        int patternStartIndex = document.indexOf(imgSrcPattern);
        if (patternStartIndex != -1 && (imgSrcStopIndex = document.indexOf("\"", imgSrcStartIndex = patternStartIndex + imgSrcPattern.length())) != -1) {
            String newToRewrite = document.substring(imgSrcStartIndex, imgSrcStopIndex);
            urlToRewrite.add(newToRewrite);
            this.extractUrlToRewrite(document.substring(imgSrcStopIndex), urlToRewrite);
        }
    }

    public RepresentationDescription get() {
        if (this.descriptions.size() > 0) {
            return this.descriptions.iterator().next();
        }
        return null;
    }

    private Collection<RepresentationDescription> getAvailableDescriptions(Session session) {
        ArrayList result = Lists.newArrayList();
        for (Viewpoint vp : session.getSelectedViewpoints(false)) {
            result.addAll(vp.getOwnedRepresentations());
        }
        return result;
    }

    private String getContentWhenHtml(RepresentationDescription viewpoint) {
        String document = viewpoint.getDocumentation();
        LinkedHashSet urlToRewrite = Sets.newLinkedHashSet();
        this.extractUrlToRewrite(document, urlToRewrite);
        return this.rewriteURLs(viewpoint, document, urlToRewrite);
    }

    private String getContentWhenNoHtml(RepresentationDescription viewpoint) {
        StringBuilder content = new StringBuilder();
        return this.begin(content).head(content).body(content, viewpoint).end(content);
    }

    private SelectRepresentationDescriptionWizardPage head(StringBuilder content) {
        content.append("<head>");
        this.appendCss(content);
        content.append("</head>");
        return this;
    }

    public boolean isPageComplete() {
        String errorMessage = null;
        boolean complete = false;
        if (this.descriptions.size() == 0) {
            errorMessage = "You should select at least one type of representation.";
        } else {
            complete = true;
        }
        this.setErrorMessage(errorMessage);
        return complete;
    }

    private String rewriteURL(RepresentationDescription viewpoint, String url) {
        URI uri = viewpoint.eResource().getURI();
        String pluginId = uri.segment(1);
        String rewrittenURL = "";
        if (uri.isPlatformPlugin()) {
            Bundle bundle = Platform.getBundle((String)pluginId);
            URL imageURL = bundle.getEntry(url);
            String string = rewrittenURL = imageURL != null ? imageURL.toString() : rewrittenURL;
            if (imageURL != null) {
                try {
                    URL fileURL = FileLocator.toFileURL((URL)imageURL);
                    rewrittenURL = fileURL.toString();
                }
                catch (IOException iOException) {}
            }
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path("/" + pluginId + url);
            if (workspace.getRoot().exists((IPath)path)) {
                IResource resource = workspace.getRoot().findMember((IPath)path);
                rewrittenURL = resource.getLocation().toFile().toURI().toString();
            }
        }
        return rewrittenURL;
    }

    private String rewriteURLs(RepresentationDescription viewpoint, String document, Set<String> urls) {
        String newDocument = document;
        for (String url : urls) {
            newDocument = newDocument.replace(url, this.rewriteURL(viewpoint, url));
        }
        StringBuilder css = new StringBuilder();
        this.appendCss(css);
        String headClose = "</head>";
        newDocument = newDocument.replace(headClose, css.append(headClose));
        return newDocument;
    }

    protected void setBrowserInput(RepresentationDescription viewpoint) {
        if (this.browser != null) {
            String content = null;
            content = this.containsHTMLDocumentation(viewpoint) ? this.getContentWhenHtml(viewpoint) : this.getContentWhenNoHtml(viewpoint);
            this.browser.setText(content);
        }
    }

    public void setVisible(boolean visible) {
        Session s;
        if (visible && (s = (Session)this.sessionSupplier.get()) != null) {
            this.tableViewer.setInput(this.getAvailableDescriptions(s));
            if (!this.representationsURIsToActivateByDefault.isEmpty()) {
                int i = 0;
                while (i < this.tableViewer.getTable().getItemCount()) {
                    RepresentationDescription representationDescription;
                    Object object = this.tableViewer.getElementAt(i);
                    if (object instanceof RepresentationDescription && (representationDescription = (RepresentationDescription)object).getName() != null && this.representationsURIsToActivateByDefault.contains(representationDescription.getName())) {
                        this.descriptions.add((RepresentationDescription)object);
                    }
                    ++i;
                }
                if (!this.descriptions.isEmpty()) {
                    this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.descriptions.iterator().next()));
                }
            }
        }
        super.setVisible(visible);
    }

    private class ViewpointsTableLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider {
        public ViewpointsTableLabelProvider() {
            super(ViewHelper.INSTANCE.createAdapterFactory());
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            if (columnIndex == 0) {
                if (element instanceof Viewpoint) {
                    ImageDescriptor desc;
                    Viewpoint vp = (Viewpoint)element;
                    if (vp.getIcon() != null && vp.getIcon().length() > 0 && (desc = SiriusEditPlugin.Implementation.findImageDescriptor((String)vp.getIcon())) != null) {
                        image = SiriusEditPlugin.getPlugin().getImage(desc);
                        image = this.getEnhancedImage(image, vp);
                    }
                    if (image == null) {
                        image = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.getPlugin().getItemImageDescriptor((Object)vp));
                        image = this.getEnhancedImage(image, vp);
                    }
                } else {
                    image = super.getImage(element);
                }
            }
            return image;
        }

        private Image getEnhancedImage(Image image, Viewpoint viewpoint) {
            if (ViewpointRegistry.getInstance().isFromPlugin(viewpoint) && image != null) {
                return SiriusEditPlugin.getPlugin().getImage(this.getOverlayedDescriptor(image, "icons/full/ovr16/plugin_ovr.gif"));
            }
            return image;
        }

        private ImageDescriptor getOverlayedDescriptor(Image baseImage, String decoratorPath) {
            ImageDescriptor decoratorDescriptor = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)decoratorPath);
            return new DecorationOverlayIcon(baseImage, decoratorDescriptor, 2);
        }
    }
}

