/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.parsley.dsl.model.EmfFeatureAccess;
import org.eclipse.emf.parsley.dsl.model.ExtendsClause;
import org.eclipse.emf.parsley.dsl.model.FieldSpecification;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartSpecification;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.ProviderBinding;
import org.eclipse.emf.parsley.dsl.model.TypeBinding;
import org.eclipse.emf.parsley.dsl.model.ValueBinding;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.typing.EmfParsleyDslTypeSystem;
import org.eclipse.emf.parsley.dsl.util.EmfParsleyDslGuiceModuleHelper;
import org.eclipse.emf.parsley.dsl.validation.AbstractEmfParsleyDslValidator;
import org.eclipse.emf.parsley.dsl.validation.EmfParsleyDslExpectedSuperTypes;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.util.Multimaps2;

public class EmfParsleyDslValidator
extends AbstractEmfParsleyDslValidator {
    public static final String TYPE_MISMATCH = "org.eclipse.emf.parsley.dsl.TypeMismatch";
    public static final String CYCLIC_INHERITANCE = "org.eclipse.emf.parsley.dsl.CyclicInheritance";
    public static final String FINAL_FIELD_NOT_INITIALIZED = "org.eclipse.emf.parsley.dsl.FinalFieldNotInitialized";
    public static final String TOO_LITTLE_TYPE_INFORMATION = "org.eclipse.emf.parsley.dsl.TooLittleTypeInformation";
    public static final String DUPLICATE_BINDING = "org.eclipse.emf.parsley.dsl.DuplicateBinding";
    public static final String DUPLICATE_ELEMENT = "org.eclipse.emf.parsley.dsl.DuplicateElement";
    public static final String NON_COMPLIANT_BINDING = "org.eclipse.emf.parsley.dsl.NonCompliantBinding";
    @Inject
    private EmfParsleyDslTypeSystem typeSystem;
    @Inject
    @Extension
    private EmfParsleyDslExpectedSuperTypes _emfParsleyDslExpectedSuperTypes;
    @Inject
    @Extension
    private EmfParsleyDslGuiceModuleHelper _emfParsleyDslGuiceModuleHelper;
    @Inject
    @Extension
    private IJvmModelAssociations _iJvmModelAssociations;
    @Inject
    private ResourceDescriptionsProvider rdp;
    @Inject
    private IContainer.Manager cm;
    private final ModelPackage modelPackage = ModelPackage.eINSTANCE;

    @Check(value=CheckType.NORMAL)
    public void checkDuplicateViewSpecificationAcrossFiles(ViewSpecification viewSpecification) {
        Iterable<IEObjectDescription> descriptions = this.getVisibleEObjectDescriptions(viewSpecification, ModelPackage.Literals.VIEW_SPECIFICATION);
        for (IEObjectDescription desc : descriptions) {
            if (!Objects.equal((Object)desc.getQualifiedName().toString(), (Object)viewSpecification.getId()) || Objects.equal((Object)desc.getEObjectOrProxy(), (Object)viewSpecification) || Objects.equal((Object)desc.getEObjectURI().trimFragment(), (Object)viewSpecification.eResource().getURI())) continue;
            String _id = viewSpecification.getId();
            String _plus = "The part id " + _id;
            String _plus_1 = String.valueOf(_plus) + " is already defined";
            EAttribute _viewSpecification_Id = this.modelPackage.getViewSpecification_Id();
            this.error(_plus_1, (EStructuralFeature)_viewSpecification_Id, DUPLICATE_ELEMENT, new String[0]);
            return;
        }
    }

    private Iterable<IEObjectDescription> getVisibleEObjectDescriptions(EObject o, final EClass type) {
        List<IContainer> _visibleContainers = this.getVisibleContainers(o);
        Functions.Function1<IContainer, Iterable<IEObjectDescription>> _function = new Functions.Function1<IContainer, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(IContainer container) {
                return container.getExportedObjectsByType(type);
            }
        };
        List _map = ListExtensions.map(_visibleContainers, (Functions.Function1)_function);
        return Iterables.concat((Iterable)_map);
    }

    private List<IContainer> getVisibleContainers(EObject o) {
        List _xblockexpression = null;
        Resource _eResource = o.eResource();
        IResourceDescriptions index = this.rdp.getResourceDescriptions(_eResource);
        Resource _eResource_1 = o.eResource();
        URI _uRI = _eResource_1.getURI();
        IResourceDescription rd = index.getResourceDescription(_uRI);
        _xblockexpression = this.cm.getVisibleContainers(rd, index);
        return _xblockexpression;
    }

    @Check
    public void checkViewSpecification(ViewSpecification viewSpecification) {
        JvmTypeReference _type = viewSpecification.getType();
        Class<?> _expectedSupertype = this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(viewSpecification);
        this.checkType(viewSpecification, _type, _expectedSupertype, (EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__TYPE);
    }

    @Check
    public void checkEmfFeatureAccess(EmfFeatureAccess emfFeatureAccess) {
        JvmTypeReference _parameterType = emfFeatureAccess.getParameterType();
        Class<?> _expectedSupertype = this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(emfFeatureAccess);
        this.checkType(emfFeatureAccess, _parameterType, _expectedSupertype, (EStructuralFeature)ModelPackage.Literals.EMF_FEATURE_ACCESS__PARAMETER_TYPE);
    }

    @Check
    public void checkExtendsClause(WithExtendsClause withExtendsClause) {
        if (!Objects.equal((Object)withExtendsClause.getExtendsClause(), null) && !this.hasCycleInHierarchy(withExtendsClause)) {
            ExtendsClause _extendsClause = withExtendsClause.getExtendsClause();
            ExtendsClause _extendsClause_1 = withExtendsClause.getExtendsClause();
            JvmTypeReference _superType = _extendsClause_1.getSuperType();
            Class<?> _expectedSupertype = this._emfParsleyDslExpectedSuperTypes.getExpectedSupertype(withExtendsClause);
            this.checkType(_extendsClause, _superType, _expectedSupertype, (EStructuralFeature)ModelPackage.Literals.EXTENDS_CLAUSE__SUPER_TYPE);
        }
    }

    @Check
    public void checkFieldInitialization(FieldSpecification f) {
        if (!f.isWriteable() && Objects.equal((Object)f.getRight(), null)) {
            String _name = f.getName();
            String _plus = "The blank final field " + _name;
            String _plus_1 = String.valueOf(_plus) + " may not have been initialized";
            this.error(_plus_1, (EStructuralFeature)ModelPackage.Literals.FIELD_SPECIFICATION__NAME, FINAL_FIELD_NOT_INITIALIZED, new String[0]);
        }
        if (Objects.equal((Object)f.getType(), null) && Objects.equal((Object)f.getRight(), null)) {
            String _name_1 = f.getName();
            String _plus_2 = "The field " + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + " needs an explicit type since there is no initialization expression to infer the type from.";
            this.error(_plus_3, f, (EStructuralFeature)ModelPackage.Literals.FIELD_SPECIFICATION__NAME, TOO_LITTLE_TYPE_INFORMATION, new String[0]);
        }
    }

    @Check
    public void checkModule(Module module) {
        Iterable methods;
        boolean _isEmpty;
        boolean _notEquals;
        JvmGenericType guiceModuleClass = this._emfParsleyDslGuiceModuleHelper.getModuleInferredType(module);
        boolean _equals = Objects.equal((Object)guiceModuleClass, null);
        if (_equals) {
            return;
        }
        PartsSpecifications partsSpecifications = module.getPartsSpecifications();
        boolean bl = _notEquals = !Objects.equal((Object)partsSpecifications, null);
        if (_notEquals) {
            EList<PartSpecification> _parts = partsSpecifications.getParts();
            this.checkDuplicateViewSpecifications((List<PartSpecification>)_parts);
        }
        if (_isEmpty = IterableExtensions.isEmpty((Iterable)(methods = guiceModuleClass.getDeclaredOperations()))) {
            return;
        }
        this.checkDuplicateBindings(methods);
        this.checkCorrectValueBindings(guiceModuleClass, methods, module);
        Iterable<JvmGenericType> _allWithExtendsClauseInferredJavaTypes = this._emfParsleyDslGuiceModuleHelper.getAllWithExtendsClauseInferredJavaTypes(module);
        for (JvmGenericType t : _allWithExtendsClauseInferredJavaTypes) {
            this.checkDuplicateSpecifications(t);
        }
    }

    private void checkDuplicateBindings(Iterable<JvmOperation> methods) {
        ListMultimap map = this.duplicatesMultimap();
        for (JvmOperation m : methods) {
            String _simpleName = m.getSimpleName();
            map.put((Object)_simpleName, (Object)m);
        }
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation d) {
                Set _sourceElements = EmfParsleyDslValidator.this._iJvmModelAssociations.getSourceElements((EObject)d);
                EObject source = (EObject)IterableExtensions.head((Iterable)_sourceElements);
                String _duplicateBindingMessage = EmfParsleyDslValidator.this.duplicateBindingMessage(source, d);
                EStructuralFeature _duplicateBindingFeature = EmfParsleyDslValidator.this.duplicateBindingFeature(source);
                EmfParsleyDslValidator.this.error(_duplicateBindingMessage, source, _duplicateBindingFeature, EmfParsleyDslValidator.DUPLICATE_BINDING, new String[0]);
            }
        };
        this.checkDuplicates(map, _function);
    }

    private void checkDuplicateSpecifications(JvmGenericType inferredType) {
        ResolvedFeatures inferredFeatures = this._emfParsleyDslGuiceModuleHelper.getJavaResolvedFeatures(inferredType);
        List methods = inferredFeatures.getDeclaredOperations();
        ListMultimap map = this.duplicatesMultimap();
        final HashSet errorSourceSeen = CollectionLiterals.newHashSet((Object[])new EObject[0]);
        for (IResolvedOperation m : methods) {
            String _javaMethodResolvedErasedSignature = this._emfParsleyDslGuiceModuleHelper.getJavaMethodResolvedErasedSignature(m);
            JvmOperation _declaration = m.getDeclaration();
            map.put((Object)_javaMethodResolvedErasedSignature, (Object)_declaration);
        }
        Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

            public void apply(JvmOperation d) {
                Set _sourceElements = EmfParsleyDslValidator.this._iJvmModelAssociations.getSourceElements((EObject)d);
                EObject source = (EObject)IterableExtensions.head((Iterable)_sourceElements);
                boolean _add = errorSourceSeen.add(source);
                if (_add) {
                    EmfParsleyDslValidator.this.error("Duplicate element", source, null, EmfParsleyDslValidator.DUPLICATE_ELEMENT, new String[0]);
                }
            }
        };
        this.checkDuplicates(map, _function);
    }

    private void checkDuplicateViewSpecifications(List<PartSpecification> parts) {
        ListMultimap map = this.duplicatesMultimap();
        Iterable _filter = Iterables.filter(parts, ViewSpecification.class);
        for (ViewSpecification p : _filter) {
            String _id = p.getId();
            map.put((Object)_id, (Object)p);
        }
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject d) {
                EAttribute _viewSpecification_Id = EmfParsleyDslValidator.this.modelPackage.getViewSpecification_Id();
                EmfParsleyDslValidator.this.error("Duplicate element", d, (EStructuralFeature)_viewSpecification_Id, EmfParsleyDslValidator.DUPLICATE_ELEMENT, new String[0]);
            }
        };
        this.checkDuplicates(map, _function);
    }

    private <T> void checkDuplicates(ListMultimap<String, T> map, Procedures.Procedure1<? super T> errorReporter) {
        Map _asMap = map.asMap();
        Set _entrySet = _asMap.entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (Object d : duplicates) {
                errorReporter.apply(d);
            }
        }
    }

    public void checkCorrectValueBindings(JvmGenericType guiceModuleClass, Iterable<JvmOperation> methods, Module module) {
        Iterable<JvmOperation> superClassValueBindings = this._emfParsleyDslGuiceModuleHelper.getAllGuiceValueBindingsMethodsInSuperclass(guiceModuleClass);
        for (final JvmOperation superBinding : superClassValueBindings) {
            Functions.Function1<JvmOperation, Boolean> _function = new Functions.Function1<JvmOperation, Boolean>(){

                public Boolean apply(JvmOperation it) {
                    String _simpleName = it.getSimpleName();
                    String _simpleName_1 = superBinding.getSimpleName();
                    return Objects.equal((Object)_simpleName, (Object)_simpleName_1);
                }
            };
            JvmOperation matching = (JvmOperation)IterableExtensions.findFirst(methods, (Functions.Function1)_function);
            if (Objects.equal((Object)matching, null) || this.typeSystem.isConformant((EObject)module, superBinding.getReturnType(), matching.getReturnType())) continue;
            JvmTypeReference _returnType = matching.getReturnType();
            String _simpleName = _returnType.getSimpleName();
            String _plus = "Incorrect value binding: " + _simpleName;
            String _plus_1 = String.valueOf(_plus) + " is not compliant with inherited binding's type ";
            JvmTypeReference _returnType_1 = superBinding.getReturnType();
            String _simpleName_1 = _returnType_1.getSimpleName();
            String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
            Set _sourceElements = this._iJvmModelAssociations.getSourceElements((EObject)matching);
            EObject _head = (EObject)IterableExtensions.head((Iterable)_sourceElements);
            EReference _valueBinding_TypeDecl = this.modelPackage.getValueBinding_TypeDecl();
            this.error(_plus_2, _head, (EStructuralFeature)_valueBinding_TypeDecl, NON_COMPLIANT_BINDING, new String[0]);
        }
    }

    protected void checkType(EObject context, JvmTypeReference actualType, Class<?> expectedType, EStructuralFeature feature) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)actualType, null);
        if (_notEquals) {
            boolean _not;
            boolean _isConformant = this.typeSystem.isConformant(context, expectedType, actualType);
            boolean bl2 = _not = !_isConformant;
            if (_not) {
                String _simpleName = actualType.getSimpleName();
                String _plus = "Type mismatch: cannot convert from " + _simpleName;
                String _plus_1 = String.valueOf(_plus) + " to ";
                String _simpleName_1 = expectedType.getSimpleName();
                String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
                this.error(_plus_2, context, feature, TYPE_MISMATCH, new String[0]);
            }
        }
    }

    protected boolean hasCycleInHierarchy(WithExtendsClause withExtendsClause) {
        HashSet _newHashSet;
        boolean _hasCycleInHierarchy;
        JvmType superType;
        ExtendsClause _extendsClause = withExtendsClause.getExtendsClause();
        JvmTypeReference _superType = _extendsClause.getSuperType();
        JvmType _type = null;
        if (_superType != null) {
            _type = _superType.getType();
        }
        if ((superType = _type) instanceof JvmGenericType && (_hasCycleInHierarchy = this.hasCycleInHierarchy((JvmGenericType)superType, _newHashSet = CollectionLiterals.newHashSet((Object[])new JvmGenericType[0])))) {
            String _simpleName = ((JvmGenericType)superType).getSimpleName();
            String _plus = "The inheritance hierarchy of " + _simpleName;
            String _plus_1 = String.valueOf(_plus) + " contains cycles";
            ExtendsClause _extendsClause_1 = withExtendsClause.getExtendsClause();
            this.error(_plus_1, _extendsClause_1, (EStructuralFeature)ModelPackage.Literals.EXTENDS_CLAUSE__SUPER_TYPE, CYCLIC_INHERITANCE, new String[0]);
            return true;
        }
        return false;
    }

    protected boolean hasCycleInHierarchy(JvmGenericType type, Set<JvmGenericType> processedSuperTypes) {
        boolean _contains = processedSuperTypes.contains(type);
        if (_contains) {
            return true;
        }
        processedSuperTypes.add(type);
        EList _superTypes = type.getSuperTypes();
        for (JvmTypeReference superTypeRef : _superTypes) {
            JvmType _type_1;
            boolean _hasCycleInHierarchy;
            JvmType _type = superTypeRef.getType();
            if (!(_type instanceof JvmGenericType) || !(_hasCycleInHierarchy = this.hasCycleInHierarchy((JvmGenericType)(_type_1 = superTypeRef.getType()), processedSuperTypes))) continue;
            return true;
        }
        processedSuperTypes.remove(type);
        return false;
    }

    private <K, T> ListMultimap<K, T> duplicatesMultimap() {
        return Multimaps2.newLinkedHashListMultimap();
    }

    private String duplicateBindingMessage(EObject source, JvmOperation method) {
        JvmTypeReference _returnType;
        String _switchResult = null;
        boolean _matched = false;
        if (source instanceof TypeBinding) {
            _matched = true;
            _returnType = method.getReturnType();
            _switchResult = _returnType.getSimpleName();
        }
        if (!_matched && source instanceof ProviderBinding) {
            _matched = true;
            _returnType = method.getReturnType();
            _switchResult = _returnType.getSimpleName();
        }
        if (!_matched && source instanceof ValueBinding) {
            _matched = true;
            _switchResult = ((ValueBinding)source).getId();
        }
        if (!_matched) {
            _returnType = method.getReturnType();
            _switchResult = _returnType.getSimpleName();
        }
        return "Duplicate binding for: " + _switchResult;
    }

    private EStructuralFeature duplicateBindingFeature(EObject e) {
        EReference _switchResult = null;
        boolean _matched = false;
        if (e instanceof TypeBinding) {
            _matched = true;
            _switchResult = this.modelPackage.getTypeBinding_TypeToBind();
        }
        if (!_matched && e instanceof ProviderBinding) {
            _matched = true;
            _switchResult = this.modelPackage.getProviderBinding_Type();
        }
        if (!_matched && e instanceof ValueBinding) {
            _matched = true;
            _switchResult = this.modelPackage.getValueBinding_Id();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }
}

