/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.Constants;
import org.eclipse.jgit.lfs.server.fs.FileLfsRepository;
import org.eclipse.jgit.lfs.server.fs.FileLfsServlet;

class ObjectDownloadListener
implements WriteListener {
    private static Logger LOG = Logger.getLogger(ObjectDownloadListener.class.getName());
    private final AsyncContext context;
    private final HttpServletResponse response;
    private final ServletOutputStream out;
    private final ReadableByteChannel in;
    private final WritableByteChannel outChannel;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(8192);

    public ObjectDownloadListener(FileLfsRepository repository, AsyncContext context, HttpServletResponse response, AnyLongObjectId id) throws IOException {
        this.context = context;
        this.response = response;
        this.in = repository.getReadChannel(id);
        this.out = response.getOutputStream();
        this.outChannel = Channels.newChannel((OutputStream)this.out);
        response.addHeader("Content-Length", String.valueOf(repository.getSize(id)));
        response.setContentType(Constants.HDR_APPLICATION_OCTET_STREAM);
    }

    public void onWritePossible() throws IOException {
        while (this.out.isReady()) {
            if (this.in.read(this.buffer) != -1) {
                this.buffer.flip();
                this.outChannel.write(this.buffer);
                this.buffer.compact();
                continue;
            }
            this.in.close();
            this.buffer.flip();
            while (this.out.isReady()) {
                if (this.buffer.hasRemaining()) {
                    this.outChannel.write(this.buffer);
                    continue;
                }
                this.context.complete();
            }
        }
    }

    public void onError(Throwable e) {
        try {
            FileLfsServlet.sendError(this.response, 500, e.getMessage());
            this.context.complete();
            this.in.close();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

